/*
 * Decompiled with CFR 0.152.
 */
package edu.mit.wordnet.core.rep.sense.dict;

import edu.mit.jwi.Dictionary;
import edu.mit.jwi.item.ISynset;
import edu.mit.jwi.item.IWord;
import edu.mit.parsing.core.rep.pos.IPosData;
import edu.mit.parsing.core.rep.pos.ITag;
import edu.mit.parsing.core.rep.pos.POSRep;
import edu.mit.parsing.core.rep.pos.PosData;
import edu.mit.parsing.core.rep.sentence.SentenceRep;
import edu.mit.parsing.core.rep.stem.IStemData;
import edu.mit.parsing.core.rep.stem.StemData;
import edu.mit.parsing.core.rep.stem.StemRep;
import edu.mit.parsing.core.rep.token.IBaseToken;
import edu.mit.parsing.core.rep.token.Token;
import edu.mit.parsing.core.rep.token.TokenRep;
import edu.mit.parsing.core.util.BaseWordInfo;
import edu.mit.parsing.core.util.IBaseWordInfo;
import edu.mit.parsing.core.util.WordInfo;
import edu.mit.story.core.StoryPlugin;
import edu.mit.story.core.desc.Desc;
import edu.mit.story.core.desc.IData;
import edu.mit.story.core.desc.IDesc;
import edu.mit.story.core.desc.factory.IDescFactory;
import edu.mit.story.core.desc.factory.IFactoryDescriptor;
import edu.mit.story.core.desc.factory.IFactoryManager;
import edu.mit.story.core.model.IMutableStoryModel;
import edu.mit.story.core.model.IStoryModel;
import edu.mit.story.core.model.StoryModel;
import edu.mit.story.core.model.change.AddRepsWithConfigChange;
import edu.mit.story.core.model.change.IModelChange;
import edu.mit.story.core.property.IConfiguration;
import edu.mit.story.core.rep.IRep;
import edu.mit.story.core.rep.IRepSet;
import edu.mit.story.core.rep.RepUtils;
import edu.mit.story.core.rep.character.CharRep;
import edu.mit.story.core.rep.character.changes.CharChange;
import edu.mit.story.core.rep.text.TextRep;
import edu.mit.wordnet.core.WordnetUtils;
import edu.mit.wordnet.core.rep.sense.ISynsetAnalysis;
import edu.mit.wordnet.core.rep.sense.SynsetAnalysis;
import edu.mit.wordnet.core.rep.sense.dict.IExtendedDictionary;
import java.net.URL;
import java.util.Arrays;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ExtendedDictionary
extends Dictionary
implements IExtendedDictionary {
    private final String id;
    private Map<IRep, IDescFactory> factories;
    private Map<ISynset, ISynsetAnalysis> cache = new Cache();

    public ExtendedDictionary(URL url, String id) {
        super(url);
        this.id = id;
    }

    public String getID() {
        return this.id;
    }

    @Override
    public ISynsetAnalysis getSynsetAnalysis(ISynset synset) {
        ISynsetAnalysis result = this.cache.get(synset);
        if (result != null) {
            return result;
        }
        IMutableStoryModel model = this.createModel();
        model.applyChange(null, (IModelChange)new CharChange(0, 0, synset.getGloss()), true);
        LinkedList<IBaseWordInfo> infos = new LinkedList<IBaseWordInfo>();
        for (IDesc token : model.getData().getDescriptions(TokenRep.getInstance())) {
            WordInfo info = WordInfo.extract((IDesc)token, (IStoryModel)model);
            if (info == null) continue;
            infos.add((IBaseWordInfo)info);
        }
        PosData tag = new PosData((ITag)WordnetUtils.convertToTag(synset.getPOS()), false);
        List words = synset.getWords();
        IBaseWordInfo[] synonyms = new IBaseWordInfo[words.size()];
        int i = 0;
        while (i < words.size()) {
            String synonym = ((IWord)words.get(i)).getLemma();
            synonyms[i] = new BaseWordInfo((IBaseToken)new Token(synonym, synonym, true), (IPosData)tag, (IStemData)new StemData(synonym), null);
            ++i;
        }
        return new SynsetAnalysis(infos, synonyms);
    }

    protected IMutableStoryModel createModel() {
        StoryModel model = new StoryModel(CharRep.getInstance());
        IData data = CharRep.getInstance().reconstitute(null, "", (IStoryModel)model);
        model.getData().add((Object)new Desc(0L, CharRep.getInstance(), 0, 0, data, null));
        Map<IRep, IDescFactory> fs = this.getFactories();
        AddRepsWithConfigChange change = new AddRepsWithConfigChange(fs.keySet(), null, null);
        model.applyChange(null, (IModelChange)change, true);
        for (IDescFactory f : fs.values()) {
            model.setFactory(f);
        }
        return model;
    }

    protected synchronized Map<IRep, IDescFactory> getFactories() {
        if (this.factories == null) {
            List<IRep> seeds = Arrays.asList(StemRep.getInstance(), POSRep.getInstance());
            IRepSet reps = RepUtils.closeWithAntecedents(seeds);
            LinkedHashMap<IRep, IDescFactory> factories = new LinkedHashMap<IRep, IDescFactory>(reps.size());
            for (IRep rep : reps) {
                factories.put(rep, null);
            }
            IFactoryManager fm = StoryPlugin.getDefault().getFactoryManager();
            IFactoryDescriptor fDesc = fm.getDefault(TextRep.getInstance());
            factories.put(TextRep.getInstance(), (IDescFactory)fDesc.create());
            fDesc = fm.getDefault(TokenRep.getInstance());
            factories.put(TokenRep.getInstance(), (IDescFactory)fDesc.create());
            fDesc = fm.getDefault(SentenceRep.getInstance());
            factories.put(SentenceRep.getInstance(), (IDescFactory)fDesc.create());
            fDesc = fm.getDefault(POSRep.getInstance());
            factories.put(POSRep.getInstance(), (IDescFactory)fDesc.create());
            fDesc = fm.getDefault(StemRep.getInstance());
            IConfiguration config = fDesc.getConfigurationDescriptor().createDefault();
            config.put((Object)"stemmer", (Object)this.getID());
            factories.put(StemRep.getInstance(), (IDescFactory)fDesc.create(config));
            for (Map.Entry entry : ((HashMap)factories).entrySet()) {
                if (entry.getValue() != null || (fDesc = fm.getNull((IRep)entry.getKey())) == null) continue;
                entry.setValue((IDescFactory)fDesc.create());
            }
            for (IDescFactory iDescFactory : ((HashMap)factories).values()) {
                iDescFactory.init(null);
            }
            this.factories = factories;
        }
        return this.factories;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    protected class Cache
    extends LinkedHashMap<ISynset, ISynsetAnalysis> {
        private static final long serialVersionUID = 1L;

        public Cache() {
            super(512, 0.75f, false);
        }

        @Override
        protected boolean removeEldestEntry(Map.Entry eldest) {
            return this.size() > 8192;
        }
    }
}

