/*
 * Decompiled with CFR 0.152.
 */
package edu.mit.parsing.core.util;

import edu.mit.parsing.core.rep.colloc.IColloc;
import edu.mit.parsing.core.rep.pos.IPosData;
import edu.mit.parsing.core.rep.sentence.ISentence;
import edu.mit.parsing.core.rep.stem.IStemData;
import edu.mit.parsing.core.rep.token.IBaseToken;
import edu.mit.parsing.core.util.IBaseWordInfo;
import edu.mit.parsing.core.util.IWordInfo;

public class BaseWordInfo
implements IBaseWordInfo {
    private final IBaseToken token;
    private final IStemData stem;
    private final IPosData tag;
    private final ISentence sentence;
    private final boolean isRoot;
    private final boolean isColloc;

    public BaseWordInfo(IBaseToken token, IPosData tag, IStemData stem, ISentence sentence) {
        if (token == null) {
            throw new NullPointerException();
        }
        this.token = token;
        this.tag = tag;
        this.stem = stem;
        this.sentence = sentence;
        this.isRoot = stem == null || token.getSurface().equalsIgnoreCase(stem.getStem());
        this.isColloc = token instanceof IColloc;
    }

    public IBaseToken getBaseToken() {
        return this.token;
    }

    public IStemData getStem() {
        return this.stem;
    }

    public String getBaseForm() {
        if (this.stem == null) {
            return this.token.getSurface();
        }
        return this.stem.getStem();
    }

    public ISentence getSentence() {
        return this.sentence;
    }

    public boolean isRoot() {
        return this.isRoot;
    }

    public boolean isCollocation() {
        return this.isColloc;
    }

    public boolean isSenseTaggable() {
        return !this.tag.isAuxiliary() && this.tag.getTag().isOpenClass();
    }

    public IPosData getPosTag() {
        return this.tag;
    }

    public int hashCode() {
        int result = 1;
        result = 31 * result + this.token.hashCode();
        result = 31 * result + this.tag.hashCode();
        result = 31 * result + (this.stem == null ? 0 : this.stem.hashCode());
        result = 31 * result + (this.sentence == null ? 0 : this.sentence.hashCode());
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof IWordInfo)) {
            return false;
        }
        IWordInfo other = (IWordInfo)obj;
        if (!this.token.equals(other.getBaseToken())) {
            return false;
        }
        if (!this.tag.equals(other.getPosTag())) {
            return false;
        }
        if (this.stem == null ? other.getStem() != null : !this.stem.equals(other.getStem())) {
            return false;
        }
        return !(this.sentence == null ? other.getSentence() != null : !this.sentence.equals(other.getSentence()));
    }

    public String toString() {
        return String.valueOf(this.getBaseToken().getSurface()) + "|" + this.stem.getStem();
    }
}

