/*
 * Decompiled with CFR 0.152.
 */
package edu.mit.parsing.core.model;

import edu.mit.parsing.core.model.ISegmentSetModel;
import edu.mit.story.core.align.IAlignedStoryModel;
import edu.mit.story.core.datamodel.AbstractViewModel;
import edu.mit.story.core.desc.DescSet;
import edu.mit.story.core.desc.IData;
import edu.mit.story.core.desc.IDesc;
import edu.mit.story.core.desc.IDescSet;
import edu.mit.story.core.desc.ISegment;
import edu.mit.story.core.desc.IStructuredData;
import edu.mit.story.core.desc.Segment;
import edu.mit.story.core.model.IStoryModel;
import edu.mit.story.core.model.change.IModelListener;
import edu.mit.story.core.model.change.StoryChangeEvent;
import edu.mit.story.core.position.HasPositionSet;
import edu.mit.story.core.position.IHasPosition;
import edu.mit.story.core.position.IHasPositionSet;
import edu.mit.story.core.position.ImmutableHasPositionSet;
import edu.mit.story.core.rep.IHasRep;
import edu.mit.story.core.rep.IRep;
import edu.mit.story.core.validation.Message;
import java.util.Collection;
import java.util.Comparator;
import java.util.Iterator;
import java.util.LinkedList;
import org.eclipse.jface.dialogs.IMessageProvider;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SegmentSetModel
extends AbstractViewModel
implements IModelListener,
ISegmentSetModel {
    public static final IMessageProvider defaultNoSelectionMsg = new Message("Selection may not be empty", 3);
    public static final IMessageProvider defaultIsValidMsg = Message.NO_MESSAGE;
    protected final IStoryModel storyModel;
    protected final IRep rep;
    protected final IHasPositionSet<ISegment> segments = new HasPositionSet();
    protected final IHasPositionSet<ISegment> rangesExt = new ImmutableHasPositionSet(this.segments);
    protected IMessageProvider noSelectionMsg = defaultNoSelectionMsg;
    protected IMessageProvider isValidMsg = defaultIsValidMsg;

    public SegmentSetModel(IRep rep, IStoryModel storyModel) {
        this(rep, storyModel, true);
    }

    public SegmentSetModel(IRep rep, IStoryModel storyModel, boolean listen) {
        if (rep == null) {
            throw new NullPointerException();
        }
        if (storyModel == null) {
            throw new NullPointerException();
        }
        this.rep = rep;
        this.storyModel = storyModel;
        this.storyModel.addModelListener((IModelListener)this);
    }

    public IRep getRep() {
        return this.rep;
    }

    @Override
    public IStoryModel getStoryModel() {
        return this.storyModel;
    }

    @Override
    public void setNoSelectionMessage(IMessageProvider msg) {
        if (msg == null) {
            throw new NullPointerException();
        }
        this.noSelectionMsg = msg;
        this.setOutOfSync();
    }

    @Override
    public void setIsValidMessage(IMessageProvider msg) {
        if (msg == null) {
            throw new NullPointerException();
        }
        this.isValidMsg = msg;
        this.setOutOfSync();
    }

    @Override
    public void setSegments(Collection<? extends ISegment> segs) {
        this.segments.clear();
        for (ISegment iSegment : segs) {
            if (!this.getRep().isType((IHasRep)iSegment)) {
                throw new IllegalArgumentException();
            }
            this.segments.add((Object)iSegment);
        }
        this.setOutOfSync();
        this.notifyChangeListeners();
    }

    @Override
    public IHasPositionSet<ISegment> getSegments() {
        return this.rangesExt;
    }

    public boolean isEmpty() {
        return this.segments.isEmpty();
    }

    public Iterator<ISegment> iterator() {
        return this.rangesExt.iterator();
    }

    public void modelChanged(StoryChangeEvent e) {
        if (e.getChange(this.rep) == null) {
            return;
        }
        LinkedList<ISegment> toAdd = new LinkedList<ISegment>();
        boolean changed = false;
        Iterator i = this.segments.iterator();
        while (i.hasNext()) {
            ISegment oldSegment = (ISegment)i.next();
            ISegment newSegment = (ISegment)oldSegment.recalculate(null, this.storyModel);
            if (newSegment == oldSegment) continue;
            changed = true;
            i.remove();
            toAdd.add(newSegment);
        }
        this.segments.addAll(toAdd);
        if (!changed) {
            return;
        }
        this.setOutOfSync();
        this.notifyChangeListeners();
    }

    protected void internalClear() {
        this.segments.clear();
    }

    public boolean isCleared() {
        return this.segments.isEmpty();
    }

    protected IMessageProvider calculateMessage() {
        return this.segments.isEmpty() ? this.noSelectionMsg : this.isValidMsg;
    }

    public void dispose() {
        this.storyModel.removeModelListener((IModelListener)this);
    }

    public int getLength() {
        return this.segments.getLength();
    }

    public int getOffset() {
        return this.segments.getOffset();
    }

    public int getRightOffset() {
        return this.segments.getRightOffset();
    }

    public String getDisplayText() {
        return Segment.generateText(this.segments);
    }

    @Override
    public IMessageProvider getIsValidMessage() {
        return this.isValidMsg;
    }

    @Override
    public IMessageProvider getNoSelectionMessage() {
        return this.noSelectionMsg;
    }

    public IDescSet getDescs() {
        DescSet result = new DescSet(this.getRep());
        for (ISegment seg : this.segments) {
            result.addAll((Collection)seg.getDescs());
        }
        return result;
    }

    public IHasPosition calculatePosition() {
        return this.rangesExt;
    }

    public IHasPosition getDisplayPosition() {
        return this.rangesExt;
    }

    public Comparator<? super ISegment> comparator() {
        return null;
    }

    public ISegment first() {
        return (ISegment)this.segments.first();
    }

    public ISegment last() {
        return (ISegment)this.segments.last();
    }

    public boolean add(ISegment o) {
        throw new UnsupportedOperationException();
    }

    public boolean addAll(Collection<? extends ISegment> c) {
        throw new UnsupportedOperationException();
    }

    public boolean contains(Object o) {
        throw new UnsupportedOperationException();
    }

    public boolean containsAll(Collection<?> c) {
        throw new UnsupportedOperationException();
    }

    public boolean remove(Object o) {
        throw new UnsupportedOperationException();
    }

    public boolean removeAll(Collection<?> c) {
        throw new UnsupportedOperationException();
    }

    public boolean retainAll(Collection<?> c) {
        throw new UnsupportedOperationException();
    }

    public int size() {
        return this.segments.size();
    }

    public Object[] toArray() {
        return this.segments.toArray();
    }

    public <T> T[] toArray(T[] a) {
        return this.segments.toArray((Object[])a);
    }

    public IHasPositionSet<ISegment> closedSet(IHasPosition range) {
        throw new UnsupportedOperationException();
    }

    public IHasPositionSet<ISegment> headSet(ISegment toElement) {
        throw new UnsupportedOperationException();
    }

    public IHasPositionSet<ISegment> matchSet(IHasPosition position) {
        throw new UnsupportedOperationException();
    }

    public IHasPositionSet<ISegment> openSet(IHasPosition range) {
        throw new UnsupportedOperationException();
    }

    public IHasPositionSet<ISegment> subSet(ISegment fromElement, ISegment toElement) {
        throw new UnsupportedOperationException();
    }

    public IHasPositionSet<ISegment> tailSet(ISegment fromElement) {
        throw new UnsupportedOperationException();
    }

    public IStructuredData recalculate(IDesc container, IStoryModel model) {
        throw new UnsupportedOperationException();
    }

    public boolean equals(IData tgtData, IAlignedStoryModel model) {
        throw new UnsupportedOperationException();
    }
}

