/*
 * Decompiled with CFR 0.152.
 */
package edu.stanford.nlp.parser.ui;

import edu.stanford.nlp.io.ui.OpenPageDialog;
import edu.stanford.nlp.ling.BasicDocument;
import edu.stanford.nlp.ling.Document;
import edu.stanford.nlp.ling.Sentence;
import edu.stanford.nlp.parser.lexparser.ChineseLexiconAndWordSegmenter;
import edu.stanford.nlp.parser.lexparser.LexicalizedParser;
import edu.stanford.nlp.parser.ui.TreeJPanel;
import edu.stanford.nlp.process.StripTagsProcessor;
import edu.stanford.nlp.process.Tokenizer;
import edu.stanford.nlp.process.WordSegmentingTokenizer;
import edu.stanford.nlp.swing.FontDetector;
import edu.stanford.nlp.trees.PennTreebankLanguagePack;
import edu.stanford.nlp.trees.Tree;
import edu.stanford.nlp.trees.TreebankLanguagePack;
import edu.stanford.nlp.trees.international.pennchinese.ChineseTreebankLanguagePack;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.Font;
import java.awt.Frame;
import java.awt.Toolkit;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.FocusAdapter;
import java.awt.event.FocusEvent;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.MouseMotionAdapter;
import java.io.CharArrayReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.net.URL;
import java.util.Iterator;
import java.util.List;
import javax.swing.BoxLayout;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JFileChooser;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JProgressBar;
import javax.swing.JScrollPane;
import javax.swing.JSplitPane;
import javax.swing.JTextPane;
import javax.swing.Timer;
import javax.swing.border.BevelBorder;
import javax.swing.text.SimpleAttributeSet;
import javax.swing.text.StyleConstants;

public class ParserPanel
extends JPanel {
    public static final int UNTOKENIZED_ENGLISH = 0;
    public static final int TOKENIZED_CHINESE = 1;
    public static final int UNTOKENIZED_CHINESE = 2;
    private static TreebankLanguagePack tlp;
    private String encoding = "UTF-8";
    private boolean segmentWords = false;
    private static final int ONE_SECOND = 1000;
    private static final int PARSER_LOAD_TIME = 60;
    private static final int PARSE_TIME = 30;
    private static final int SEEK_FORWARD = 1;
    private static final int SEEK_BACK = -1;
    private final JFileChooser jfc;
    private OpenPageDialog pageDialog;
    private SimpleAttributeSet normalStyle;
    private SimpleAttributeSet highlightStyle;
    private int startIndex;
    private int endIndex;
    private TreeJPanel treePanel;
    private LexicalizedParser parser;
    private LoadParserThread lpThread;
    private ParseThread parseThread;
    private Timer timer;
    private int count;
    private Component glassPane;
    private boolean scrollWhenDone;
    private JLabel dataFileLabel;
    private JPanel treeContainer;
    private JPanel topPanel;
    private JScrollPane textScrollPane;
    private JButton backButton;
    private JLabel statusLabel;
    private JButton loadFileButton;
    private JPanel loadButtonPanel;
    private JPanel buttonsAndFilePanel;
    private JButton parseButton;
    private JButton parseNextButton;
    private JButton forwardButton;
    private JLabel parserFileLabel;
    private JButton clearButton;
    private JSplitPane splitPane;
    private JPanel statusPanel;
    private JPanel dataFilePanel;
    private JPanel buttonPanel;
    private JTextPane textPane;
    private JProgressBar progressBar;
    private JPanel parserFilePanel;
    private JButton loadParserButton;

    public ParserPanel() {
        this.initComponents();
        this.jfc = new JFileChooser();
        this.pageDialog = new OpenPageDialog(new Frame(), true);
        this.pageDialog.setFileChooser(this.jfc);
        this.setLanguage(0);
        this.timer = new Timer(1000, new TimerListener());
        this.highlightStyle = new SimpleAttributeSet();
        this.normalStyle = new SimpleAttributeSet();
        StyleConstants.ColorConstants.setBackground(this.highlightStyle, Color.yellow);
        StyleConstants.ColorConstants.setBackground(this.normalStyle, this.textPane.getBackground());
    }

    public void scrollBack() {
        this.highlightSentence(this.startIndex - 1);
        this.textPane.setCaretPosition(this.startIndex);
    }

    public void scrollForward() {
        this.highlightSentence(this.endIndex + 1);
        this.textPane.setCaretPosition(this.startIndex);
    }

    private void highlightText(int start, int end, SimpleAttributeSet style) {
        if (start < end) {
            this.textPane.getStyledDocument().setCharacterAttributes(start, end - start + 1, style, false);
        }
    }

    private void highlightSentence(int start) {
        this.highlightSentence(start, -1);
    }

    private void highlightSentence(int start, int end) {
        this.highlightText(0, this.textPane.getText().length(), this.normalStyle);
        this.startIndex = start < 1 ? 0 : this.nearestDelimiter(this.textPane.getText(), start - 1, -1) + 1;
        this.endIndex = this.nearestDelimiter(this.textPane.getText(), end < this.startIndex ? this.startIndex : end, 1);
        if (this.endIndex == -1) {
            this.endIndex = this.textPane.getText().length() - 1;
        }
        this.highlightText(this.startIndex, this.endIndex, this.highlightStyle);
        this.backButton.setEnabled(this.startIndex != 0);
        this.forwardButton.setEnabled(this.endIndex != this.textPane.getText().length() - 1);
        this.parseNextButton.setEnabled(this.forwardButton.isEnabled() && this.parser != null);
    }

    private int nearestDelimiter(String text, int start, int seekDir) {
        int textLeng = text.length();
        String[] puncWords = tlp.sentenceFinalPunctuationWords();
        for (int curIndex = start; curIndex >= 0 && curIndex < textLeng; curIndex += seekDir) {
            for (int i = 0; i < puncWords.length; ++i) {
                if (!puncWords[i].equals(Character.toString(text.charAt(curIndex)))) continue;
                return curIndex;
            }
        }
        return -1;
    }

    private void highlightSelectedSentence() {
        this.highlightSentence(this.textPane.getSelectionStart(), this.textPane.getSelectionEnd());
    }

    private void highlightEditedSentence() {
        this.highlightSentence(this.textPane.getCaretPosition());
    }

    public void setStatus(String status) {
        this.statusLabel.setText(status);
    }

    public void setLanguage(int language) {
        switch (language) {
            case 0: {
                tlp = new PennTreebankLanguagePack();
                this.encoding = tlp.getEncoding();
                this.textPane.setFont(new Font("Sans Serif", 0, 14));
                this.treePanel.setFont(new Font("Sans Serif", 0, 14));
                break;
            }
            case 2: {
                this.segmentWords = true;
            }
            case 1: {
                tlp = new ChineseTreebankLanguagePack();
                this.encoding = "UTF-8";
                List<Font> fonts = FontDetector.supportedFonts(0);
                if (fonts.size() > 0) {
                    Font font = new Font(fonts.get(0).getName(), 0, 14);
                    this.textPane.setFont(font);
                    this.treePanel.setFont(font);
                    System.err.println("Selected font " + font);
                    break;
                }
                if (!FontDetector.hasFont("Watanabe Mincho")) break;
                this.textPane.setFont(new Font("Watanabe Mincho", 0, 14));
                this.treePanel.setFont(new Font("Watanabe Mincho", 0, 14));
            }
        }
    }

    public void parse() {
        if (this.textPane.getText().length() == 0) {
            return;
        }
        String text = this.textPane.getText().substring(this.startIndex, this.endIndex + 1).trim();
        if (this.parser != null && text.length() > 0) {
            if (this.segmentWords) {
                ChineseLexiconAndWordSegmenter lex = (ChineseLexiconAndWordSegmenter)this.parser.getLexicon();
                ChineseTreebankLanguagePack.setTokenizerFactory(WordSegmentingTokenizer.factory(lex));
            }
            Tokenizer toke = tlp.getTokenizerFactory().getTokenizer(new CharArrayReader(text.toCharArray()));
            List wordList = toke.tokenize();
            this.parseThread = new ParseThread(new Sentence(wordList));
            this.parseThread.start();
            this.startProgressMonitor("Parsing", 30);
        }
    }

    public void loadFile() {
        this.pageDialog.setLocation(this.getLocationOnScreen().x + (this.getWidth() - this.pageDialog.getWidth()) / 2, this.getLocationOnScreen().y + (this.getHeight() - this.pageDialog.getHeight()) / 2);
        this.pageDialog.setVisible(true);
        if (this.pageDialog.getStatus() == 1) {
            this.loadFile(this.pageDialog.getPage());
        }
    }

    public void loadFile(String filename) {
        Document doc;
        if (filename == null) {
            return;
        }
        File file = new File(filename);
        String urlOrFile = filename;
        if (!file.exists() && filename.indexOf("://") == -1) {
            urlOrFile = "http://" + filename;
        } else if (filename.indexOf("://") == -1) {
            urlOrFile = "file://" + filename;
        }
        try {
            if (urlOrFile.startsWith("http://") || urlOrFile.endsWith(".htm") || urlOrFile.endsWith(".html")) {
                BasicDocument docPre = new BasicDocument().init(new URL(urlOrFile));
                StripTagsProcessor noTags = new StripTagsProcessor();
                doc = noTags.processDocument(docPre);
            } else {
                doc = new BasicDocument(tlp.getTokenizerFactory()).init(new InputStreamReader((InputStream)new FileInputStream(filename), this.encoding));
            }
        }
        catch (Exception e) {
            JOptionPane.showMessageDialog(this, "Could not load file " + filename + ";" + e, null, 0);
            e.printStackTrace();
            this.setStatus("Error loading document");
            return;
        }
        StringBuilder docStr = new StringBuilder();
        Iterator it = doc.iterator();
        while (it.hasNext()) {
            if (docStr.length() > 0) {
                docStr.append(' ');
            }
            docStr.append(it.next().toString());
        }
        this.textPane.setText(docStr.toString());
        this.dataFileLabel.setText(urlOrFile);
        this.highlightSentence(0);
        this.forwardButton.setEnabled(this.endIndex != this.textPane.getText().length() - 1);
        this.textPane.setCaretPosition(0);
        this.setStatus("Done");
    }

    public void loadParser() {
        this.jfc.setDialogTitle("Load parser");
        int status = this.jfc.showOpenDialog(this);
        if (status == 0) {
            this.loadParser(this.jfc.getSelectedFile().getPath());
        }
    }

    public void loadParser(String filename) {
        if (filename == null) {
            return;
        }
        File file = new File(filename);
        if (file.exists()) {
            this.lpThread = new LoadParserThread(filename);
            this.lpThread.start();
            this.startProgressMonitor("Loading Parser", 60);
        } else {
            JOptionPane.showMessageDialog(this, "Could not find file " + filename, null, 0);
            this.setStatus("Error loading parser");
        }
    }

    private void startProgressMonitor(String text, int maxCount) {
        if (this.glassPane == null && this.getRootPane() != null) {
            this.glassPane = this.getRootPane().getGlassPane();
            this.glassPane.addMouseListener(new MouseAdapter(){

                public void mouseClicked(MouseEvent evt) {
                    Toolkit.getDefaultToolkit().beep();
                }
            });
        }
        if (this.glassPane != null) {
            this.glassPane.setVisible(true);
        }
        this.statusLabel.setText(text);
        this.progressBar.setMaximum(maxCount);
        this.progressBar.setValue(0);
        this.count = 0;
        this.timer.start();
        this.progressBar.setVisible(true);
    }

    private void stopProgressMonitor() {
        this.timer.stop();
        this.progressBar.setVisible(false);
        if (this.glassPane != null) {
            this.glassPane.setVisible(false);
        }
        this.lpThread = null;
        this.parseThread = null;
    }

    private void initComponents() {
        this.splitPane = new JSplitPane();
        this.topPanel = new JPanel();
        this.buttonsAndFilePanel = new JPanel();
        this.loadButtonPanel = new JPanel();
        this.loadFileButton = new JButton();
        this.loadParserButton = new JButton();
        this.buttonPanel = new JPanel();
        this.backButton = new JButton();
        if (this.getClass().getResource("/edu/stanford/nlp/parser/ui/leftarrow.gif") != null) {
            this.backButton.setIcon(new ImageIcon(this.getClass().getResource("/edu/stanford/nlp/parser/ui/leftarrow.gif")));
        } else {
            this.backButton.setText("< Prev");
        }
        this.forwardButton = new JButton();
        if (this.getClass().getResource("/edu/stanford/nlp/parser/ui/rightarrow.gif") != null) {
            this.forwardButton.setIcon(new ImageIcon(this.getClass().getResource("/edu/stanford/nlp/parser/ui/rightarrow.gif")));
        } else {
            this.forwardButton.setText("Next >");
        }
        this.parseButton = new JButton();
        this.parseNextButton = new JButton();
        this.clearButton = new JButton();
        this.dataFilePanel = new JPanel();
        this.dataFileLabel = new JLabel();
        this.textScrollPane = new JScrollPane();
        this.textPane = new JTextPane();
        this.treeContainer = new JPanel();
        this.parserFilePanel = new JPanel();
        this.parserFileLabel = new JLabel();
        this.statusPanel = new JPanel();
        this.statusLabel = new JLabel();
        this.progressBar = new JProgressBar();
        this.progressBar.setVisible(false);
        this.setLayout(new BorderLayout());
        this.splitPane.setOrientation(0);
        this.topPanel.setLayout(new BorderLayout());
        this.buttonsAndFilePanel.setLayout(new BoxLayout(this.buttonsAndFilePanel, 1));
        this.loadButtonPanel.setLayout(new FlowLayout(0));
        this.loadFileButton.setText("Load File");
        this.loadFileButton.setToolTipText("Load a data file.");
        this.loadFileButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                ParserPanel.this.loadFileButtonActionPerformed(evt);
            }
        });
        this.loadButtonPanel.add(this.loadFileButton);
        this.loadParserButton.setText("Load Parser");
        this.loadParserButton.setToolTipText("Load a serialized parser.");
        this.loadParserButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                ParserPanel.this.loadParserButtonActionPerformed(evt);
            }
        });
        this.loadButtonPanel.add(this.loadParserButton);
        this.buttonsAndFilePanel.add(this.loadButtonPanel);
        this.buttonPanel.setLayout(new FlowLayout(0));
        this.backButton.setToolTipText("Scroll backward one sentence.");
        this.backButton.setEnabled(false);
        this.backButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                ParserPanel.this.backButtonActionPerformed(evt);
            }
        });
        this.buttonPanel.add(this.backButton);
        this.forwardButton.setToolTipText("Scroll forward one sentence.");
        this.forwardButton.setEnabled(false);
        this.forwardButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                ParserPanel.this.forwardButtonActionPerformed(evt);
            }
        });
        this.buttonPanel.add(this.forwardButton);
        this.parseButton.setText("Parse");
        this.parseButton.setToolTipText("Parse selected sentence.");
        this.parseButton.setEnabled(false);
        this.parseButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                ParserPanel.this.parseButtonActionPerformed(evt);
            }
        });
        this.buttonPanel.add(this.parseButton);
        this.parseNextButton.setText("Parse >");
        this.parseNextButton.setToolTipText("Parse selected sentence and then scrolls forward one sentence.");
        this.parseNextButton.setEnabled(false);
        this.parseNextButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                ParserPanel.this.parseNextButtonActionPerformed(evt);
            }
        });
        this.buttonPanel.add(this.parseNextButton);
        this.clearButton.setText("Clear");
        this.clearButton.setToolTipText("Clears parse tree.");
        this.clearButton.setEnabled(false);
        this.clearButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                ParserPanel.this.clearButtonActionPerformed(evt);
            }
        });
        this.buttonPanel.add(this.clearButton);
        this.buttonsAndFilePanel.add(this.buttonPanel);
        this.dataFilePanel.setLayout(new FlowLayout(0));
        this.dataFilePanel.add(this.dataFileLabel);
        this.buttonsAndFilePanel.add(this.dataFilePanel);
        this.topPanel.add((Component)this.buttonsAndFilePanel, "North");
        this.textPane.setPreferredSize(new Dimension(250, 250));
        this.textPane.addFocusListener(new FocusAdapter(){

            public void focusLost(FocusEvent evt) {
                ParserPanel.this.textPaneFocusLost(evt);
            }
        });
        this.textPane.addMouseListener(new MouseAdapter(){

            public void mouseClicked(MouseEvent evt) {
                ParserPanel.this.textPaneMouseClicked(evt);
            }
        });
        this.textPane.addMouseMotionListener(new MouseMotionAdapter(){

            public void mouseDragged(MouseEvent evt) {
                ParserPanel.this.textPaneMouseDragged(evt);
            }
        });
        this.textScrollPane.setViewportView(this.textPane);
        this.topPanel.add((Component)this.textScrollPane, "Center");
        this.splitPane.setLeftComponent(this.topPanel);
        this.treeContainer.setLayout(new BorderLayout());
        this.treeContainer.setBackground(new Color(255, 255, 255));
        this.treeContainer.setBorder(new BevelBorder(0));
        this.treeContainer.setForeground(new Color(0, 0, 0));
        this.treeContainer.setPreferredSize(new Dimension(200, 200));
        this.treePanel = new TreeJPanel();
        this.treeContainer.add("Center", this.treePanel);
        this.treePanel.setBackground(Color.white);
        this.parserFilePanel.setLayout(new FlowLayout(0));
        this.parserFilePanel.setBackground(new Color(255, 255, 255));
        this.parserFileLabel.setText("Parser: None");
        this.parserFilePanel.add(this.parserFileLabel);
        this.treeContainer.add((Component)this.parserFilePanel, "North");
        this.splitPane.setRightComponent(this.treeContainer);
        this.add((Component)this.splitPane, "Center");
        this.statusPanel.setLayout(new FlowLayout(0));
        this.statusLabel.setText("Ready");
        this.statusPanel.add(this.statusLabel);
        this.progressBar.setName("");
        this.statusPanel.add(this.progressBar);
        this.add((Component)this.statusPanel, "South");
    }

    private void textPaneFocusLost(FocusEvent evt) {
        this.highlightEditedSentence();
    }

    private void parseNextButtonActionPerformed(ActionEvent evt) {
        this.parse();
        this.scrollWhenDone = true;
    }

    private void clearButtonActionPerformed(ActionEvent evt) {
        this.treePanel.setTree(null);
        this.clearButton.setEnabled(false);
    }

    private void textPaneMouseDragged(MouseEvent evt) {
        this.highlightSelectedSentence();
    }

    private void textPaneMouseClicked(MouseEvent evt) {
        this.highlightSelectedSentence();
    }

    private void parseButtonActionPerformed(ActionEvent evt) {
        this.parse();
        this.scrollWhenDone = false;
    }

    private void loadParserButtonActionPerformed(ActionEvent evt) {
        this.loadParser();
    }

    private void loadFileButtonActionPerformed(ActionEvent evt) {
        this.loadFile();
    }

    private void backButtonActionPerformed(ActionEvent evt) {
        this.scrollBack();
    }

    private void forwardButtonActionPerformed(ActionEvent evt) {
        this.scrollForward();
    }

    private class TimerListener
    implements ActionListener {
        private TimerListener() {
        }

        public void actionPerformed(ActionEvent e) {
            ParserPanel.this.progressBar.setValue(Math.min(ParserPanel.this.count++, ParserPanel.this.progressBar.getMaximum() - 1));
        }
    }

    private class ParseThread
    extends Thread {
        Sentence sentence;

        public ParseThread(Sentence sentence) {
            this.sentence = sentence;
        }

        public void run() {
            boolean successful;
            try {
                successful = ParserPanel.this.parser.parse(this.sentence);
            }
            catch (Exception e) {
                ParserPanel.this.stopProgressMonitor();
                JOptionPane.showMessageDialog(ParserPanel.this, "Could not parse selected sentence\n(sentence probably too long)", null, 0);
                ParserPanel.this.setStatus("Error parsing");
                return;
            }
            ParserPanel.this.stopProgressMonitor();
            ParserPanel.this.setStatus("Done");
            if (successful) {
                Tree tree = ParserPanel.this.parser.getBestParse();
                ParserPanel.this.treePanel.setTree(tree);
                ParserPanel.this.clearButton.setEnabled(true);
            } else {
                JOptionPane.showMessageDialog(ParserPanel.this, "Could not parse selected sentence", null, 0);
                ParserPanel.this.setStatus("Error parsing");
                ParserPanel.this.treePanel.setTree(null);
                ParserPanel.this.clearButton.setEnabled(false);
            }
            if (ParserPanel.this.scrollWhenDone) {
                ParserPanel.this.scrollForward();
            }
        }
    }

    private class LoadParserThread
    extends Thread {
        String filename;

        LoadParserThread(String filename) {
            this.filename = filename;
        }

        public void run() {
            try {
                ParserPanel.this.parser = new LexicalizedParser(this.filename);
            }
            catch (Exception ex) {
                JOptionPane.showMessageDialog(ParserPanel.this, "Error loading parser: " + this.filename, null, 0);
                ParserPanel.this.setStatus("Error loading parser");
                ParserPanel.this.parser = null;
            }
            catch (OutOfMemoryError e) {
                JOptionPane.showMessageDialog(ParserPanel.this, "Could not load parser. Out of memory.", null, 0);
                ParserPanel.this.setStatus("Error loading parser");
                ParserPanel.this.parser = null;
            }
            ParserPanel.this.stopProgressMonitor();
            if (ParserPanel.this.parser != null) {
                ParserPanel.this.setStatus("Loaded parser.");
                ParserPanel.this.parserFileLabel.setText("Parser: " + this.filename);
                ParserPanel.this.parseButton.setEnabled(true);
                ParserPanel.this.parseNextButton.setEnabled(true);
            }
        }
    }
}

