/*
 * Decompiled with CFR 0.152.
 */
package edu.mit.wordnet.core.rep.sense.evidence;

import edu.mit.wordnet.core.rep.sense.evidence.EvidenceType;
import edu.mit.wordnet.core.rep.sense.evidence.IEvidence;
import edu.mit.wordnet.core.rep.sense.evidence.UnknownEvidence;

public abstract class Evidence
implements IEvidence {
    public static char typeContentSepChar = (char)58;
    private final String contentStr;

    public Evidence(String contentStr) {
        if (contentStr == null) {
            throw new NullPointerException();
        }
        this.contentStr = contentStr;
    }

    public String getContentString() {
        return this.contentStr;
    }

    public static IEvidence reconstitute(String evStr) {
        if (evStr == null || evStr.length() == 0) {
            return null;
        }
        int idx = evStr.indexOf(typeContentSepChar);
        if (idx >= 0) {
            String typeStr = evStr.substring(0, idx);
            String contentStr = evStr.substring(idx + 1);
            EvidenceType type = EvidenceType.valueOf(typeStr);
            if (type == null) {
                return new UnknownEvidence(typeStr, contentStr);
            }
            return type.getEvidence(typeStr, contentStr);
        }
        EvidenceType type = EvidenceType.NUMERIC;
        return type.getEvidence(type.getID(), evStr);
    }

    public static String serialize(IEvidence e) {
        if (e == null) {
            return "";
        }
        String typeStr = e.getTypeString();
        String contentStr = e.getContentString();
        StringBuilder sb = new StringBuilder(typeStr.length() + 1 + contentStr.length());
        sb.append(typeStr);
        sb.append(typeContentSepChar);
        sb.append(contentStr);
        return sb.toString();
    }
}

