/*
 * Decompiled with CFR 0.152.
 */
package edu.mit.story.core.property;

import edu.mit.story.core.StoryMessages;
import edu.mit.story.core.mappers.PropertyMapper;
import edu.mit.story.core.property.AbstractProperty;
import edu.mit.story.core.property.IProperty;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Property
extends AbstractProperty {
    private String key;
    private String value;

    public Property(Map.Entry<String, String> entry) {
        this(entry.getKey(), entry.getValue());
    }

    public Property(String key, String value) {
        if (key == null || value == null) {
            throw new NullPointerException();
        }
        this.setKey(key);
        this.setValue(value);
    }

    @Override
    public String getKey() {
        return this.key;
    }

    @Override
    public String getValue() {
        return this.value;
    }

    @Override
    public String setKey(String key) {
        if (Property.isInvalidPart(key)) {
            throw new IllegalArgumentException(StoryMessages.MSG_InvalidPropertyString);
        }
        String old = this.key;
        this.key = key;
        return old;
    }

    @Override
    public String setValue(String value) {
        if (Property.isInvalidPart(value)) {
            throw new IllegalArgumentException(StoryMessages.MSG_InvalidPropertyString);
        }
        String old = this.value;
        this.value = value;
        return old;
    }

    public String toString() {
        return String.valueOf(this.key) + "=" + this.value;
    }

    public static boolean equalAsProperties(IProperty one, IProperty two) {
        if (one == two) {
            return true;
        }
        if (one == null || two == null) {
            return false;
        }
        return ((String)one.getKey()).equals(two.getKey()) && ((String)one.getValue()).equals(two.getValue());
    }

    public static List<IProperty> copy(Collection<? extends Map.Entry<String, String>> properties) {
        ArrayList<IProperty> result = new ArrayList<IProperty>(properties.size());
        for (Map.Entry<String, String> entry : properties) {
            result.add(new Property(entry));
        }
        return result;
    }

    public static boolean isInvalidPart(String part) {
        return part.indexOf(PropertyMapper.entrySeparator) != -1 || part.indexOf(PropertyMapper.keyValueSeparator) != -1;
    }

    public static boolean containsKey(String key, List<IProperty> ps) {
        for (IProperty p : ps) {
            if (!((String)p.getKey()).equals(key)) continue;
            return true;
        }
        return false;
    }

    public static IProperty getProperty(String key, List<IProperty> ps) {
        for (IProperty p : ps) {
            if (!((String)p.getKey()).equals(key)) continue;
            return p;
        }
        return null;
    }
}

