/*
 * Decompiled with CFR 0.152.
 */
package edu.mit.story.core.position;

import edu.mit.story.core.position.IHasPosition;
import edu.mit.story.core.position.IRegionSet;
import edu.mit.story.core.position.ImmutablePosition;
import edu.mit.story.core.position.PositionComparator;
import edu.mit.story.core.position.PositionUtils;
import edu.mit.story.core.util.Debug;
import java.util.AbstractSet;
import java.util.Collection;
import java.util.Comparator;
import java.util.Iterator;
import java.util.Map;
import java.util.NoSuchElementException;
import java.util.SortedMap;
import java.util.SortedSet;
import java.util.TreeMap;
import java.util.TreeSet;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class RegionSet
extends AbstractSet<IHasPosition>
implements IRegionSet {
    private static final long serialVersionUID = -6675830020707391303L;
    protected final RegionSet parent;
    protected final boolean openRange;
    protected final int fromOffset;
    protected final int toOffset;
    protected final IHasPosition fromPos;
    protected final IHasPosition toPos;
    protected final SortedMap<Integer, SortedSet<IHasPosition>> offsetMap;

    public RegionSet() {
        this.parent = null;
        this.offsetMap = this.createOffsetMap(null);
        this.fromPos = null;
        this.toPos = null;
        this.fromOffset = 0;
        this.toOffset = 0x7FFFFFFE;
        this.openRange = false;
    }

    public RegionSet(Collection<? extends IHasPosition> c) {
        if (c == null) {
            throw new NullPointerException();
        }
        this.parent = null;
        this.offsetMap = this.createOffsetMap(c);
        this.fromPos = null;
        this.toPos = null;
        this.fromOffset = 0;
        this.toOffset = 0x7FFFFFFE;
        this.openRange = false;
    }

    protected RegionSet(RegionSet parent, IHasPosition fromPos, IHasPosition toPos, int fromOffset, int toOffset, boolean open) {
        this.parent = parent;
        this.offsetMap = parent == null ? this.createOffsetMap(null) : parent.offsetMap;
        this.fromPos = fromPos;
        this.toPos = toPos;
        this.fromOffset = fromOffset;
        this.toOffset = toOffset;
        this.openRange = open;
        if (PositionUtils.definesNullSet(fromPos, toPos, fromOffset, toOffset)) {
            throw new IllegalArgumentException("the range of the of set is null");
        }
    }

    protected RegionSet getSubsetParent() {
        return this.parent == null ? this : this.parent;
    }

    protected boolean isValid(IHasPosition p) {
        if (p == null) {
            return false;
        }
        if (this.parent == null) {
            return true;
        }
        return this.isWithinBounds(p) & this.isWithinRange(p);
    }

    protected boolean isWithinBounds(IHasPosition p) {
        if (p == null) {
            return false;
        }
        if (this.fromPos != null && this.comparator().compare(this.fromPos, p) > 0) {
            return false;
        }
        return this.toPos == null || this.comparator().compare(p, this.toPos) < 0;
    }

    protected boolean isWithinRange(IHasPosition p) {
        if (p == null) {
            return false;
        }
        if (this.openRange) {
            if (p.getOffset() == this.fromOffset & p.getRightOffset() == this.toOffset) {
                return true;
            }
            if (p.getLength() == 0 && (p.getOffset() == this.fromOffset || p.getRightOffset() == this.toOffset)) {
                return true;
            }
            if (p.getRightOffset() <= this.fromOffset) {
                return false;
            }
            return this.toOffset > p.getOffset();
        }
        return this.fromOffset <= p.getRightOffset() & p.getOffset() <= this.toOffset;
    }

    protected boolean isSubview(Collection<? extends IHasPosition> c) {
        if (!(c instanceof RegionSet)) {
            return false;
        }
        RegionSet ps = (RegionSet)c;
        if (this.getSubsetParent() != ps.parent) {
            return false;
        }
        if (this.fromOffset > ps.fromOffset) {
            return false;
        }
        if (this.fromOffset == ps.fromOffset && this.openRange & !ps.openRange) {
            return false;
        }
        if (this.toOffset < ps.toOffset) {
            return false;
        }
        if (this.toOffset == ps.toOffset && this.openRange & !ps.openRange) {
            return false;
        }
        if (this.fromPos != null) {
            if (ps.fromPos == null) {
                return false;
            }
            if (this.comparator().compare(this.fromPos, ps.fromPos) > 0) {
                return false;
            }
        }
        if (this.toPos != null) {
            if (ps.toPos == null) {
                return false;
            }
            if (this.comparator().compare(this.toPos, ps.toPos) < 0) {
                return false;
            }
        }
        return true;
    }

    protected void throwException(IHasPosition p) {
        StringBuffer sb = new StringBuffer();
        sb.append("The argument is out of range for this set: the argument ");
        if (p != null) {
            sb.append(PositionUtils.toString(p));
            sb.append(" ");
        }
        int length = sb.length();
        if (this.fromPos != null & this.toPos != null) {
            sb.append("must fall between the left-closed range {from=");
            sb.append(PositionUtils.toString(this.fromPos));
            sb.append(", to=");
            sb.append(PositionUtils.toString(this.toPos));
            sb.append("}");
        } else if (this.fromPos != null) {
            sb.append("must be strictly less than ");
            sb.append(PositionUtils.toString(this.fromPos));
        } else if (this.toPos != null) {
            sb.append("must be greater than or equal to ");
            sb.append(PositionUtils.toString(this.toPos));
        }
        if (sb.length() > length) {
            sb.append("; and it");
        }
        sb.append(" must overlap the ");
        sb.append(this.openRange ? "open" : "closed");
        sb.append(" index range=[" + this.fromOffset + "," + this.toOffset + "]");
        throw new IllegalArgumentException(sb.toString());
    }

    @Override
    public int getOffset() {
        OffsetIterator itr = new OffsetIterator();
        return itr.nextOffset();
    }

    @Override
    public int getLength() {
        int left = -1;
        int right = -1;
        OffsetIterator itr = new OffsetIterator();
        while (itr.hasNext()) {
            int nextRight;
            if (left == -1) {
                left = itr.nextOffset();
            }
            if (right >= (nextRight = ((IHasPosition)itr.next().last()).getRightOffset())) continue;
            right = nextRight;
        }
        return left != -1 & right != -1 ? right - left : -1;
    }

    @Override
    public int getRightOffset() {
        int right = -1;
        OffsetIterator itr = new OffsetIterator();
        while (itr.hasNext()) {
            if (!itr.next().isEmpty()) continue;
            Debug.out("Got here");
        }
        itr = new OffsetIterator();
        while (itr.hasNext()) {
            Object next = itr.next();
            int nextRight = ((IHasPosition)next.last()).getRightOffset();
            if (right >= nextRight) continue;
            right = nextRight;
        }
        return right;
    }

    @Override
    public boolean add(IHasPosition p) {
        SortedSet<IHasPosition> subset;
        if (!this.isValid(p)) {
            this.throwException(p);
        }
        if ((subset = (SortedSet<IHasPosition>)this.offsetMap.get(p.getOffset())) == null) {
            subset = this.createOffsetSet(null);
            this.offsetMap.put(p.getOffset(), subset);
        }
        boolean result = subset.add(p);
        return result;
    }

    @Override
    public boolean addAll(Collection<? extends IHasPosition> c) {
        if (c.isEmpty()) {
            return false;
        }
        if (!(c instanceof RegionSet)) {
            return super.addAll(c);
        }
        if (this.isSubview(c)) {
            return false;
        }
        boolean changed = false;
        for (Map.Entry<Integer, SortedSet<IHasPosition>> entry : ((RegionSet)c).offsetMap.entrySet()) {
            changed |= this.addUniformOffsetCollection(entry.getKey(), (Collection<IHasPosition>)entry.getValue());
        }
        return changed;
    }

    protected boolean addUniformOffsetCollection(int offset, Collection<IHasPosition> c) {
        if (offset < 0 | c == null) {
            return false;
        }
        if (c.isEmpty()) {
            return false;
        }
        for (IHasPosition p : c) {
            if (this.isValid(p)) continue;
            this.throwException(p);
        }
        SortedSet<IHasPosition> subset = (SortedSet<IHasPosition>)this.offsetMap.get(offset);
        if (subset == null) {
            subset = this.createOffsetSet(null);
            this.offsetMap.put(offset, subset);
        }
        boolean result = subset.addAll(c);
        return result;
    }

    @Override
    public boolean contains(Object o) {
        if (!(o instanceof IHasPosition)) {
            return false;
        }
        IHasPosition p = (IHasPosition)o;
        if (!this.isValid(p)) {
            return false;
        }
        SortedSet subset = (SortedSet)this.offsetMap.get(p.getOffset());
        if (subset == null) {
            return false;
        }
        return subset.contains(p);
    }

    @Override
    public Iterator<IHasPosition> iterator() {
        return new HasPositionSetIterator();
    }

    protected Iterator<SortedSet<IHasPosition>> offsetIterator() {
        return new OffsetIterator();
    }

    @Override
    public Comparator<? super IHasPosition> comparator() {
        return PositionComparator.getInstance();
    }

    @Override
    public boolean remove(Object o) {
        if (o == null) {
            return false;
        }
        if (!(o instanceof IHasPosition)) {
            return false;
        }
        IHasPosition p = (IHasPosition)o;
        if (!this.isValid(p)) {
            return false;
        }
        int offset = p.getOffset();
        SortedSet subset = (SortedSet)this.offsetMap.get(offset);
        if (subset == null) {
            return false;
        }
        return subset.remove(p);
    }

    @Override
    public int size() {
        int result = 0;
        Iterator<SortedSet<IHasPosition>> i = this.offsetIterator();
        while (i.hasNext()) {
            result += i.next().size();
        }
        return result;
    }

    @Override
    public IHasPosition first() {
        Iterator<SortedSet<IHasPosition>> subsetItr = this.offsetIterator();
        if (subsetItr.hasNext()) {
            return subsetItr.next().first();
        }
        throw new NoSuchElementException();
    }

    @Override
    public IHasPosition last() {
        if (this.parent == null) {
            SortedSet lastSet = (SortedSet)this.offsetMap.get(this.offsetMap.lastKey());
            if (lastSet == null) {
                throw new NoSuchElementException();
            }
            return (IHasPosition)lastSet.last();
        }
        SortedSet<IHasPosition> last = null;
        Iterator<SortedSet<IHasPosition>> subsetItr = this.offsetIterator();
        while (subsetItr.hasNext()) {
            last = subsetItr.next();
        }
        if (last == null) {
            throw new NoSuchElementException();
        }
        return (IHasPosition)last.last();
    }

    protected SortedSet<IHasPosition> createOffsetSet(Collection<? extends IHasPosition> c) {
        TreeSet<IHasPosition> result = new TreeSet<IHasPosition>(this.comparator());
        if (c != null) {
            result.addAll(c);
        }
        return result;
    }

    protected SortedMap<Integer, SortedSet<IHasPosition>> createOffsetMap(Collection<? extends IHasPosition> c) {
        if (c == null || c.isEmpty()) {
            return new TreeMap<Integer, SortedSet<IHasPosition>>();
        }
        RegionSet result = this.createSubset(null, null, null, 0, 0x7FFFFFFE, false);
        result.addAll(c);
        return result.offsetMap;
    }

    protected RegionSet createSubset(RegionSet parent, IHasPosition fromElement, IHasPosition toElement, int fromOffset, int toOffset, boolean closed) {
        return new RegionSet(parent, fromElement, toElement, fromOffset, toOffset, closed);
    }

    @Override
    public IRegionSet subSet(IHasPosition fromElement, IHasPosition toElement) {
        ImmutablePosition to;
        ImmutablePosition from = fromElement == null ? null : new ImmutablePosition(fromElement);
        ImmutablePosition immutablePosition = to = toElement == null ? null : new ImmutablePosition(toElement);
        if (!this.isWithinBounds(from)) {
            this.throwException(from);
        }
        if (!this.isWithinBounds(to)) {
            this.throwException(to);
        }
        return this.createSubset(this.getSubsetParent(), from, to, this.fromOffset, this.toOffset, false);
    }

    @Override
    public IRegionSet headSet(IHasPosition toElement) {
        ImmutablePosition to = new ImmutablePosition(toElement);
        if (!this.isWithinBounds(to)) {
            this.throwException(toElement);
        }
        return this.createSubset(this.getSubsetParent(), this.fromPos, to, this.fromOffset, this.toOffset, false);
    }

    @Override
    public IRegionSet tailSet(IHasPosition fromElement) {
        ImmutablePosition from = new ImmutablePosition(fromElement);
        if (!this.isWithinBounds(from)) {
            this.throwException(from);
        }
        return this.createSubset(this.getSubsetParent(), from, this.toPos, this.fromOffset, this.toOffset, false);
    }

    @Override
    public IRegionSet headSet(int offset, int length) {
        ImmutablePosition to = new ImmutablePosition(offset, length);
        if (!this.isWithinBounds(to)) {
            this.throwException(to);
        }
        return this.createSubset(this.getSubsetParent(), this.fromPos, to, this.fromOffset, this.toOffset, false);
    }

    @Override
    public IRegionSet tailSet(int offset, int length) {
        ImmutablePosition from = new ImmutablePosition(offset, length);
        if (!this.isWithinBounds(from)) {
            this.throwException(from);
        }
        return this.createSubset(this.getSubsetParent(), from, this.toPos, this.fromOffset, this.toOffset, false);
    }

    @Override
    public IRegionSet closedSet(IHasPosition range) {
        if (!this.isWithinBounds(range) | !this.isWithinRange(range)) {
            this.throwException(range);
        }
        return this.createSubset(this.getSubsetParent(), this.fromPos, this.toPos, Math.max(this.fromOffset, range.getOffset()), Math.min(this.toOffset, range.getRightOffset()), false);
    }

    @Override
    public IRegionSet matchSet(IHasPosition position) {
        ImmutablePosition from = new ImmutablePosition(position);
        ImmutablePosition to = new ImmutablePosition(position.getOffset(), position.getLength() + 1);
        if (!this.isWithinBounds(from) | !this.isWithinBounds(to) | !this.isWithinRange(position)) {
            this.throwException(position);
        }
        return this.createSubset(this.getSubsetParent(), from, to, this.fromOffset, this.toOffset, false);
    }

    @Override
    public IRegionSet openSet(IHasPosition range) {
        if (!this.isWithinBounds(range) | !this.isWithinRange(range)) {
            this.throwException(range);
        }
        return this.createSubset(this.getSubsetParent(), this.fromPos, this.toPos, Math.max(this.fromOffset, range.getOffset()), Math.min(this.toOffset, range.getRightOffset()), true);
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    protected class HasPositionSetIterator
    implements Iterator<IHasPosition> {
        int total;
        int delivered = 0;
        protected Iterator<IHasPosition> currentItr = null;
        protected Iterator<SortedSet<IHasPosition>> mainItr;

        protected HasPositionSetIterator() {
            this.mainItr = RegionSet.this.offsetIterator();
            this.total = RegionSet.this.size();
        }

        @Override
        public boolean hasNext() {
            return this.delivered < this.total;
        }

        @Override
        public IHasPosition next() {
            if (this.currentItr == null) {
                this.loadNextIterator();
            } else if (!this.currentItr.hasNext()) {
                this.loadNextIterator();
            }
            if (this.currentItr == null) {
                throw new NoSuchElementException();
            }
            ++this.delivered;
            return this.currentItr.next();
        }

        protected void loadNextIterator() {
            if (this.mainItr.hasNext()) {
                this.currentItr = this.mainItr.next().iterator();
            }
        }

        @Override
        public void remove() {
            if (this.currentItr == null) {
                throw new IllegalStateException("next() not yet called");
            }
            this.currentItr.remove();
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    protected class OffsetIterator
    implements Iterator<SortedSet<IHasPosition>> {
        Iterator<Map.Entry<Integer, SortedSet<IHasPosition>>> sortedSetItr;
        int nextOffset = -1;
        SortedSet<IHasPosition> next = null;

        protected OffsetIterator() {
            if (RegionSet.this.parent == null) {
                this.sortedSetItr = RegionSet.this.offsetMap.entrySet().iterator();
            } else {
                int toInt = RegionSet.this.toPos != null ? Math.min(RegionSet.this.toPos.getOffset() + 1, RegionSet.this.toOffset + 1) : RegionSet.this.toOffset + 1;
                this.sortedSetItr = RegionSet.this.fromPos != null ? RegionSet.this.offsetMap.subMap(RegionSet.this.fromPos.getOffset(), toInt).entrySet().iterator() : RegionSet.this.offsetMap.headMap(toInt).entrySet().iterator();
            }
            this.loadNext();
        }

        /*
         * Unable to fully structure code
         * Could not resolve type clashes
         */
        protected void loadNext() {
            block6: {
                this.next = null;
                this.nextOffset = -1;
                if (RegionSet.this.parent != null) ** GOTO lbl30
                while (this.sortedSetItr.hasNext()) {
                    entry = this.sortedSetItr.next();
                    if (entry.getValue().isEmpty()) continue;
                    this.next = entry.getValue();
                    this.nextOffset = entry.getKey();
                    return;
                }
                break block6;
lbl-1000:
                // 1 sources

                {
                    entry = this.sortedSetItr.next();
                    if (entry.getValue().isEmpty()) continue;
                    if (RegionSet.this.toOffset == entry.getKey() && RegionSet.this.openRange) {
                        toPosActual /* !! */  = new ImmutablePosition(RegionSet.this.toOffset, 1);
                        if (RegionSet.this.toPos != null) {
                            toPosActual /* !! */  = PositionUtils.min(RegionSet.this.comparator(), toPosActual /* !! */ , RegionSet.this.toPos);
                        }
                        if (RegionSet.this.comparator().compare(toPosActual /* !! */ , entry.getValue().first()) <= 0) {
                            return;
                        }
                        this.next = entry.getValue().headSet(toPosActual /* !! */ );
                        this.nextOffset = entry.getKey();
                        return;
                    }
                    fromLength = RegionSet.this.fromOffset - entry.getKey() + (RegionSet.this.openRange != false && entry.getKey() < RegionSet.this.fromOffset ? 1 : 0);
                    fromPosActual /* !! */  = new ImmutablePosition(entry.getKey(), Math.max(0, fromLength));
                    if (RegionSet.this.fromPos != null) {
                        fromPosActual /* !! */  = PositionUtils.max(RegionSet.this.comparator(), fromPosActual /* !! */ , RegionSet.this.fromPos);
                    }
                    if (RegionSet.this.comparator().compare(entry.getValue().last(), fromPosActual /* !! */ ) < 0 || RegionSet.this.toPos != null && (RegionSet.this.comparator().compare(fromPosActual /* !! */ , RegionSet.this.toPos) >= 0 || RegionSet.this.comparator().compare(RegionSet.this.toPos, entry.getValue().first()) < 0)) continue;
                    this.next = RegionSet.this.toPos != null ? entry.getValue().subSet(fromPosActual /* !! */ , RegionSet.this.toPos) : entry.getValue().tailSet(fromPosActual /* !! */ );
                    this.nextOffset = entry.getKey();
                    return;
lbl30:
                    // 3 sources

                    ** while (this.sortedSetItr.hasNext())
                }
            }
        }

        @Override
        public boolean hasNext() {
            return this.next != null;
        }

        @Override
        public SortedSet<IHasPosition> next() {
            SortedSet<IHasPosition> result = this.next;
            this.loadNext();
            return result;
        }

        public int nextOffset() {
            return this.nextOffset;
        }

        @Override
        public void remove() {
            throw new IllegalArgumentException();
        }
    }
}

