/*
 * Decompiled with CFR 0.152.
 */
package edu.mit.story.core.meta;

import edu.mit.story.core.meta.IMetaData;
import edu.mit.story.core.meta.IMetaDataMap;
import edu.mit.story.core.meta.IMetaDataSet;
import edu.mit.story.core.meta.IMetaDesc;
import edu.mit.story.core.meta.IMetaRep;
import edu.mit.story.core.meta.MetaDataSet;
import java.util.Iterator;
import java.util.Map;
import java.util.NoSuchElementException;
import java.util.TreeMap;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class MetaDataMap
extends TreeMap<IMetaRep<? extends IMetaData>, IMetaDataSet<? extends IMetaData>>
implements IMetaDataMap {
    private static final long serialVersionUID = -7719795259836557288L;

    public MetaDataMap() {
    }

    public MetaDataMap(Iterable<? extends IMetaDesc<?>> c) {
        this.addAllDescs(c);
    }

    @Override
    public IMetaDataSet<?> put(IMetaRep<?> key, IMetaDataSet<?> value) {
        throw new UnsupportedOperationException();
    }

    @Override
    public void putAll(Map<? extends IMetaRep<?>, ? extends IMetaDataSet<?>> map) {
        throw new UnsupportedOperationException();
    }

    @Override
    public IMetaDataSet<?> get(Object key) {
        if (key instanceof IMetaRep) {
            return this.get((IMetaRep)key);
        }
        return null;
    }

    @Override
    public <D extends IMetaData> IMetaDataSet<D> get(IMetaRep<D> rep) {
        MetaDataSet<D> value = (MetaDataSet<D>)super.get(rep);
        if (value == null) {
            value = new MetaDataSet<D>(rep);
            super.put(rep, value);
        }
        return value;
    }

    @Override
    public <D extends IMetaData> boolean addDesc(IMetaDesc<D> d) {
        return this.get(d.getMetaRep()).add(d);
    }

    @Override
    public <D extends IMetaData> boolean removeDesc(IMetaDesc<D> d) {
        if (!this.containsKey(d.getMetaRep())) {
            return false;
        }
        return this.get(d.getMetaRep()).remove(d);
    }

    @Override
    public boolean addAllDescs(Iterable<? extends IMetaDesc<?>> c) {
        boolean changed = false;
        for (IMetaDesc<?> d : c) {
            changed |= this.addDesc(d);
        }
        return changed;
    }

    @Override
    public boolean removeAllDescs(Iterable<? extends IMetaDesc<?>> c) {
        boolean changed = false;
        for (IMetaDesc<?> d : c) {
            changed |= this.removeDesc(d);
        }
        return changed;
    }

    @Override
    public Iterator<IMetaDesc<?>> iterator() {
        return new MetaDataMapIterator();
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    protected class MetaDataMapIterator
    implements Iterator<IMetaDesc<?>> {
        private final Iterator<IMetaDataSet<?>> setItr;
        private Iterator<?> lastItr;
        private Iterator<?> currItr;
        private boolean hasNext;

        public MetaDataMapIterator() {
            this.setItr = MetaDataMap.this.values().iterator();
            this.lastItr = null;
            this.hasNext = false;
            this.loadNext();
        }

        @Override
        public boolean hasNext() {
            return this.hasNext;
        }

        @Override
        public IMetaDesc<?> next() {
            if (this.currItr == null) {
                throw new NoSuchElementException();
            }
            IMetaDesc next = (IMetaDesc)this.currItr.next();
            this.lastItr = this.currItr;
            this.loadNext();
            return next;
        }

        protected void loadNext() {
            if (this.currItr != null && this.currItr.hasNext()) {
                this.hasNext = true;
                return;
            }
            this.currItr = null;
            this.hasNext = false;
            while (this.setItr.hasNext()) {
                Iterator itr = this.setItr.next().iterator();
                if (!itr.hasNext()) continue;
                this.currItr = itr;
                this.hasNext = true;
                break;
            }
        }

        @Override
        public void remove() {
            if (this.lastItr == null) {
                throw new IllegalStateException();
            }
            this.lastItr.remove();
        }
    }
}

