/*
 * Decompiled with CFR 0.152.
 */
package edu.mit.story.core.element;

import edu.mit.story.core.desc.IDesc;
import edu.mit.story.core.desc.IDescMultiSet;
import edu.mit.story.core.desc.IDescSet;
import edu.mit.story.core.element.IStoryElement;
import edu.mit.story.core.element.IStoryElementProcessor;
import edu.mit.story.core.element.IStoryElementSet;
import edu.mit.story.core.model.IStoryModel;
import edu.mit.story.core.position.IPosition;
import edu.mit.story.core.position.IPositionSet;
import edu.mit.story.core.rep.IRep;
import edu.mit.story.core.rep.IRepSet;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class StoryElementProcessorAdapter<T>
implements IStoryElementProcessor<T> {
    @Override
    public T process(Object o) {
        if (!(o instanceof IStoryElement)) {
            return this.getDefaultResponse();
        }
        IStoryElement elem = (IStoryElement)o;
        switch (elem.getImplementationCode()) {
            case 1: {
                return this.processRepresentation((IRep)elem);
            }
            case 2: {
                return this.processRepresentationSet((IRepSet)elem);
            }
            case 3: {
                return this.processPosition((IPosition)elem);
            }
            case 4: {
                return this.processPositionSet((IPositionSet)elem);
            }
            case 5: {
                return this.processDescription((IDesc)((Object)elem));
            }
            case 6: {
                return this.processDescriptionSet((IDescSet)elem);
            }
            case 7: {
                return this.processDescriptionMap((IDescMultiSet)elem);
            }
            case 8: {
                return this.processDescriptionProvider((IStoryModel)elem);
            }
            case 9: {
                return this.processStoryElementSet((IStoryElementSet)elem);
            }
        }
        throw new IllegalArgumentException("Unknown IStoryElement type, code=" + elem.getImplementationCode() + ", name=" + elem.getImplementationName());
    }

    @Override
    public T getDefaultResponse() {
        return null;
    }

    @Override
    public T processRepresentation(IRep repSet) {
        return this.getDefaultResponse();
    }

    @Override
    public T processRepresentationSet(IRepSet repSet) {
        return this.getDefaultResponse();
    }

    @Override
    public T processPosition(IPosition pos) {
        return this.getDefaultResponse();
    }

    @Override
    public T processPositionSet(IPositionSet posSet) {
        return this.getDefaultResponse();
    }

    @Override
    public T processDescription(IDesc desc) {
        return this.getDefaultResponse();
    }

    @Override
    public T processDescriptionSet(IDescSet descSet) {
        return this.getDefaultResponse();
    }

    @Override
    public T processDescriptionMap(IDescMultiSet descMap) {
        return this.getDefaultResponse();
    }

    @Override
    public T processDescriptionProvider(IStoryModel provider) {
        return this.getDefaultResponse();
    }

    @Override
    public T processStoryElementSet(IStoryElementSet set) {
        return this.getDefaultResponse();
    }
}

