/*
 * Decompiled with CFR 0.152.
 */
package edu.mit.semantics.ui.helpers;

import edu.mit.parsing.ui.controllers.ISegmentController;
import edu.mit.parsing.ui.controllers.ISegmentSetController;
import edu.mit.parsing.ui.widgets.SegmentCaptureWidget;
import edu.mit.parsing.ui.widgets.SegmentSetCaptureWidget;
import edu.mit.semantics.core.rep.event.Aspect;
import edu.mit.semantics.core.rep.event.EventClass;
import edu.mit.semantics.core.rep.event.EventRep;
import edu.mit.semantics.core.rep.event.POS;
import edu.mit.semantics.core.rep.event.Tense;
import edu.mit.semantics.core.rep.event.model.IEventModel;
import edu.mit.semantics.ui.controllers.EventController;
import edu.mit.semantics.ui.controllers.IEventController;
import edu.mit.story.core.desc.IDesc;
import edu.mit.story.core.notify.INotifyingMessageProvider;
import edu.mit.story.core.notify.MessageProviderManager;
import edu.mit.story.core.validation.Message;
import edu.mit.story.ui.StoryUIPlugin;
import edu.mit.story.ui.actions.SelectionUtils;
import edu.mit.story.ui.helpers.HelperPage;
import edu.mit.story.ui.helpers.IEditorPage;
import edu.mit.story.ui.label.NameLabelProvider;
import edu.mit.story.ui.util.ColorManager;
import edu.mit.story.ui.widgets.ButtonAction;
import edu.mit.story.ui.widgets.MessageBar;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.dialogs.IMessageProvider;
import org.eclipse.jface.viewers.ArrayContentProvider;
import org.eclipse.jface.viewers.ComboViewer;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.layout.RowLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Spinner;
import org.eclipse.ui.IActionBars;

public class EventCreatorPage
extends HelperPage
implements ChangeListener,
IEditorPage {
    public static final String ID = "edu.mit.semantics.ui.helpers.EventCreatorPage";
    public static String buttonLabelCommit = "Commit";
    public static String buttonLabelSave = "Save";
    public static String buttonLabelClear = "Clear";
    public static String buttonLabelCancel = "Cancel";
    public static String actionLabelCommit = "Commit Event";
    public static String actionLabelSave = "Save Event";
    public static String actionLabelClear = "Clear Event";
    public static String actionLabelCancel = "Cancel Editing";
    public static IMessageProvider clearedMessage = new Message("Use this page to create a new event annotation", 1);
    public static IMessageProvider createMessage = new Message("Press the 'commit' button to add this event to the story model", 1);
    public static IMessageProvider saveMessage = new Message("Press the 'save' button to change this event in the story model", 1);
    protected IEventController controller;
    protected MessageProviderManager messageManager;
    protected MessageBar messageBar;
    protected SegmentSetCaptureWidget<ISegmentSetController> eventWidget;
    protected SegmentSetCaptureWidget<ISegmentSetController> headWidget;
    protected SegmentCaptureWidget<ISegmentController> polWidget;
    protected SegmentCaptureWidget<ISegmentController> cardWidget;
    protected SegmentCaptureWidget<ISegmentController> modeWidget;
    protected ComboViewer classCombo;
    protected ComboViewer posCombo;
    protected ComboViewer tenseCombo;
    protected ComboViewer aspectCombo;
    protected ComboViewer polarityCombo;
    protected Spinner cardSpinner;
    protected Button commitButton;
    protected Button clearButton;
    protected ButtonAction commitAction;
    protected ButtonAction clearAction;

    public IEventController getController() {
        return this.controller;
    }

    public void createControl(Composite parent) {
        this.controller = new EventController(this.getStoryEditor());
        Composite control = new Composite(parent, 0);
        this.setControl((Control)control);
        GridLayout layout = new GridLayout(1, false);
        layout.marginHeight = 0;
        layout.marginWidth = 0;
        layout.horizontalSpacing = 0;
        layout.verticalSpacing = 0;
        control.setLayout((Layout)layout);
        control.setBackground(StoryUIPlugin.getDefault().getColorManager().get((Object)"WHITE"));
        control.setForeground(StoryUIPlugin.getDefault().getColorManager().get((Object)"BLACK"));
        this.messageBar = new MessageBar(control, 0);
        this.messageBar.setLayoutData((Object)new GridData(4, 4, true, false));
        ColorManager.inheritColors((Control)this.messageBar);
        Label rule = new Label(control, 258);
        rule.setLayoutData((Object)new GridData(4, 4, true, false));
        Composite inputParent = new Composite(control, 0);
        inputParent.setLayoutData((Object)new GridData(4, 0, true, false));
        inputParent.setLayout((Layout)new GridLayout(3, false));
        ColorManager.inheritColors((Control)inputParent);
        Label label = new Label(inputParent, 0);
        label.setText("Event");
        ColorManager.inheritColors((Control)label);
        this.classCombo = new ComboViewer(inputParent);
        ColorManager.inheritColors((Control)this.classCombo.getControl());
        this.classCombo.setContentProvider((IContentProvider)new ArrayContentProvider());
        this.classCombo.setLabelProvider((IBaseLabelProvider)NameLabelProvider.getInstance());
        this.classCombo.setInput((Object)EventClass.values());
        this.classCombo.getCombo().setVisibleItemCount(EventClass.values().length);
        this.classCombo.addSelectionChangedListener(new ISelectionChangedListener(){

            public void selectionChanged(SelectionChangedEvent event) {
                EventClass sel = (EventClass)SelectionUtils.extractSingle((ISelection)event.getSelection(), EventClass.class);
                EventCreatorPage.this.controller.setEventClass(sel);
            }
        });
        this.eventWidget = new SegmentSetCaptureWidget(inputParent, 0, this.controller.getEventController());
        this.eventWidget.setLayoutData((Object)new GridData(4, 0, true, false));
        this.eventWidget.getAddAction().setText("Add to Event");
        this.eventWidget.getAddAction().setToolTipText("Add to Event");
        this.eventWidget.getSubtractAction().setText("Subtract from Event");
        this.eventWidget.getSubtractAction().setToolTipText("Subtract from Event");
        this.eventWidget.getClearAction().setText("Clear Event");
        this.eventWidget.getClearAction().setToolTipText("Clear Event");
        label = new Label(inputParent, 0);
        label.setText("Head");
        ColorManager.inheritColors((Control)label);
        label = new Label(inputParent, 0);
        ColorManager.inheritColors((Control)label);
        this.headWidget = new SegmentSetCaptureWidget(inputParent, 0, this.controller.getHeadController());
        this.headWidget.setLayoutData((Object)new GridData(4, 0, true, false));
        this.headWidget.getAddAction().setText("Add to Head");
        this.headWidget.getAddAction().setToolTipText("Add to Head");
        this.headWidget.getSubtractAction().setText("Subtract from Head");
        this.headWidget.getSubtractAction().setToolTipText("Subtract from Head");
        this.headWidget.getClearAction().setText("Clear Head");
        this.headWidget.getClearAction().setToolTipText("Clear Head");
        label = new Label(inputParent, 0);
        label.setText("Features");
        ColorManager.inheritColors((Control)label);
        label = new Label(inputParent, 0);
        ColorManager.inheritColors((Control)label);
        Composite featureParent = new Composite(inputParent, 0);
        featureParent.setLayoutData((Object)new GridData(4, 0, true, false));
        RowLayout rowLayout = new RowLayout(256);
        rowLayout.marginHeight = 0;
        rowLayout.marginWidth = 0;
        featureParent.setLayout((Layout)rowLayout);
        ColorManager.inheritColors((Control)featureParent);
        label = new Label(inputParent, 0);
        label.setText("Polarity");
        ColorManager.inheritColors((Control)label);
        this.polarityCombo = new ComboViewer(inputParent);
        this.polarityCombo.getControl().setLayoutData((Object)new GridData(4, 0, false, false));
        ColorManager.inheritColors((Control)this.polarityCombo.getControl());
        this.polarityCombo.setContentProvider((IContentProvider)new ArrayContentProvider());
        this.polarityCombo.setInput((Object)new Boolean[]{Boolean.TRUE, Boolean.FALSE});
        this.polarityCombo.getCombo().setVisibleItemCount(2);
        this.polarityCombo.addSelectionChangedListener(new ISelectionChangedListener(){

            public void selectionChanged(SelectionChangedEvent event) {
                Boolean sel = (Boolean)SelectionUtils.extractSingle((ISelection)event.getSelection(), Boolean.class);
                EventCreatorPage.this.controller.setPolarity(sel);
            }
        });
        this.polWidget = new SegmentCaptureWidget(inputParent, 65536, this.controller.getPolarityController());
        this.polWidget.setLayoutData((Object)new GridData(4, 4, true, false));
        this.polWidget.getCaptureAction().setText("Capture Polarity");
        this.polWidget.getCaptureAction().setToolTipText("Capture Polarity");
        this.polWidget.getClearAction().setText("Clear Polarity");
        this.polWidget.getClearAction().setToolTipText("Clear Polarity");
        label = new Label(inputParent, 0);
        label.setText("Cardinality");
        ColorManager.inheritColors((Control)label);
        this.cardSpinner = new Spinner(inputParent, 2048);
        this.cardSpinner.setLayoutData((Object)new GridData(4, 0, false, false));
        ColorManager.inheritColors((Control)this.cardSpinner);
        this.cardSpinner.setMinimum(0);
        this.cardSpinner.setMaximum(Integer.MAX_VALUE);
        this.cardSpinner.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                EventCreatorPage.this.controller.setCardinality(EventCreatorPage.this.cardSpinner.getSelection());
            }
        });
        this.cardWidget = new SegmentCaptureWidget(inputParent, 65536, this.controller.getCardinalityController());
        this.cardWidget.setLayoutData((Object)new GridData(4, 4, true, false));
        this.cardWidget.getCaptureAction().setText("Capture Cardinality");
        this.cardWidget.getCaptureAction().setToolTipText("Capture Cardinality");
        this.cardWidget.getClearAction().setText("Clear Cardinality");
        this.cardWidget.getClearAction().setToolTipText("Clear Cardinality");
        label = new Label(inputParent, 0);
        label.setText("Modality");
        ColorManager.inheritColors((Control)label);
        label = new Label(inputParent, 0);
        ColorManager.inheritColors((Control)label);
        this.modeWidget = new SegmentCaptureWidget(inputParent, 65536, this.controller.getModalityController());
        this.modeWidget.setLayoutData((Object)new GridData(4, 4, true, false));
        this.modeWidget.getCaptureAction().setText("Capture Modality");
        this.modeWidget.getCaptureAction().setToolTipText("Capture Modality");
        this.modeWidget.getClearAction().setText("Clear Modality");
        this.modeWidget.getClearAction().setToolTipText("Clear Modality");
        label = new Label(inputParent, 0);
        ColorManager.inheritColors((Control)label);
        label = new Label(inputParent, 0);
        ColorManager.inheritColors((Control)label);
        Composite buttonParent = new Composite(inputParent, 0);
        buttonParent.setLayoutData((Object)new GridData(4, 0x1000000, true, false));
        buttonParent.setLayout((Layout)new GridLayout(3, false));
        ColorManager.inheritColors((Control)buttonParent);
        label = new Label(buttonParent, 0);
        label.setLayoutData((Object)new GridData(4, 0x1000000, true, false));
        ColorManager.inheritColors((Control)label);
        this.commitButton = new Button(buttonParent, 0);
        this.commitButton.setText("Commit");
        this.commitAction = new ButtonAction(this.commitButton){

            public void run() {
                EventCreatorPage.this.controller.commit();
            }
        };
        this.clearButton = new Button(buttonParent, 0);
        this.clearButton.setText("Clear");
        this.clearAction = new ButtonAction(this.clearButton){

            public void run() {
                EventCreatorPage.this.controller.clear();
            }
        };
        Composite featurePair = new Composite(featureParent, 0);
        featurePair.setLayout((Layout)new GridLayout(2, false));
        ColorManager.inheritColors((Control)featurePair);
        this.posCombo = new ComboViewer(featurePair);
        ColorManager.inheritColors((Control)this.posCombo.getControl());
        this.posCombo.setContentProvider((IContentProvider)new ArrayContentProvider());
        this.posCombo.setLabelProvider((IBaseLabelProvider)NameLabelProvider.getInstance());
        this.posCombo.setInput((Object)POS.values());
        this.posCombo.getCombo().setVisibleItemCount(POS.values().length);
        this.posCombo.addSelectionChangedListener(new ISelectionChangedListener(){

            public void selectionChanged(SelectionChangedEvent event) {
                POS sel = (POS)SelectionUtils.extractSingle((ISelection)event.getSelection(), POS.class);
                EventCreatorPage.this.controller.setPOS(sel);
            }
        });
        label = new Label(featurePair, 0);
        ColorManager.inheritColors((Control)label);
        label.setText("Part of Speech");
        featurePair = new Composite(featureParent, 0);
        featurePair.setLayout((Layout)new GridLayout(2, false));
        ColorManager.inheritColors((Control)featurePair);
        this.tenseCombo = new ComboViewer(featurePair);
        ColorManager.inheritColors((Control)this.tenseCombo.getControl());
        this.tenseCombo.setContentProvider((IContentProvider)new ArrayContentProvider());
        this.tenseCombo.setLabelProvider((IBaseLabelProvider)NameLabelProvider.getInstance());
        this.tenseCombo.setInput((Object)Tense.values());
        this.tenseCombo.getCombo().setVisibleItemCount(Tense.values().length);
        this.tenseCombo.addSelectionChangedListener(new ISelectionChangedListener(){

            public void selectionChanged(SelectionChangedEvent event) {
                Tense sel = (Tense)SelectionUtils.extractSingle((ISelection)event.getSelection(), Tense.class);
                EventCreatorPage.this.controller.setTense(sel);
            }
        });
        label = new Label(featurePair, 0);
        ColorManager.inheritColors((Control)label);
        label.setText("Tense");
        featurePair = new Composite(featureParent, 0);
        featurePair.setLayout((Layout)new GridLayout(2, false));
        ColorManager.inheritColors((Control)featurePair);
        this.aspectCombo = new ComboViewer(featurePair);
        ColorManager.inheritColors((Control)this.aspectCombo.getControl());
        this.aspectCombo.setContentProvider((IContentProvider)new ArrayContentProvider());
        this.aspectCombo.setLabelProvider((IBaseLabelProvider)NameLabelProvider.getInstance());
        this.aspectCombo.setInput((Object)Aspect.values());
        this.aspectCombo.getCombo().setVisibleItemCount(Aspect.values().length);
        this.aspectCombo.addSelectionChangedListener(new ISelectionChangedListener(){

            public void selectionChanged(SelectionChangedEvent event) {
                Aspect sel = (Aspect)SelectionUtils.extractSingle((ISelection)event.getSelection(), Aspect.class);
                EventCreatorPage.this.controller.setAspect(sel);
            }
        });
        label = new Label(featurePair, 0);
        label.setText("Aspect");
        ColorManager.inheritColors((Control)label);
        this.messageManager = new MessageProviderManager(createMessage, (ChangeListener)this);
        this.messageManager.setAllClearedMesage(clearedMessage);
        this.messageManager.add((INotifyingMessageProvider)this.controller.getModel(), true);
        this.messageManager.addChangeListener((ChangeListener)this);
        this.updateFromModel();
    }

    protected void updateFromModel() {
        IMessageProvider defaultMsg;
        IEventModel eventModel = this.controller.getModel();
        boolean enableCommit = !eventModel.isCleared() && eventModel.getMessageType() != 3;
        boolean enableClear = !eventModel.isCleared();
        StructuredSelection classSel = new StructuredSelection((Object)eventModel.getEventClass());
        StructuredSelection posSel = new StructuredSelection((Object)eventModel.getPOS());
        StructuredSelection tenseSel = new StructuredSelection((Object)eventModel.getTense());
        StructuredSelection aspectSel = new StructuredSelection((Object)eventModel.getAspect());
        StructuredSelection polaritySel = new StructuredSelection((Object)eventModel.getPolarity());
        int card = eventModel.getCardinality();
        boolean isLoaded = eventModel.getLoaded() != null;
        String commitActionLabel = isLoaded ? actionLabelSave : actionLabelCommit;
        String clearActionLabel = isLoaded ? actionLabelCancel : actionLabelClear;
        String commitButtonLabel = isLoaded ? buttonLabelSave : buttonLabelCommit;
        String clearButtonLabel = isLoaded ? buttonLabelCancel : buttonLabelClear;
        IMessageProvider iMessageProvider = defaultMsg = isLoaded ? saveMessage : createMessage;
        if (!this.classCombo.getSelection().equals(classSel)) {
            this.classCombo.setSelection((ISelection)classSel);
        }
        if (!this.posCombo.getSelection().equals(posSel)) {
            this.posCombo.setSelection((ISelection)posSel);
        }
        if (!this.tenseCombo.getSelection().equals(tenseSel)) {
            this.tenseCombo.setSelection((ISelection)tenseSel);
        }
        if (!this.aspectCombo.getSelection().equals(aspectSel)) {
            this.aspectCombo.setSelection((ISelection)aspectSel);
        }
        if (!this.polarityCombo.getSelection().equals(polaritySel)) {
            this.polarityCombo.setSelection((ISelection)polaritySel);
        }
        if (this.cardSpinner.getSelection() != card) {
            this.cardSpinner.setSelection(card);
        }
        if (enableCommit != this.commitAction.isEnabled()) {
            this.commitAction.setEnabled(enableCommit);
        }
        if (enableClear != this.clearAction.isEnabled()) {
            this.clearAction.setEnabled(enableClear);
        }
        boolean labelChanged = false;
        if (!commitActionLabel.equals(this.commitAction.getText())) {
            this.commitAction.setText(commitActionLabel);
            this.commitAction.setToolTipText(commitActionLabel);
        }
        if (!clearActionLabel.equals(this.clearAction.getText())) {
            this.clearAction.setText(clearActionLabel);
            this.clearAction.setToolTipText(clearActionLabel);
        }
        if (!commitButtonLabel.equals(this.commitButton.getText())) {
            labelChanged = true;
            this.commitButton.setText(commitButtonLabel);
        }
        if (!clearButtonLabel.equals(this.clearButton.getText())) {
            labelChanged = true;
            this.clearButton.setText(clearButtonLabel);
        }
        if (!this.messageManager.getDefaultMessage().equals(defaultMsg)) {
            this.messageManager.setDefaultMesage(defaultMsg);
        }
        this.messageBar.setMessage(this.messageManager.getMessage(), this.messageManager.getMessageType());
        if (labelChanged) {
            ((Composite)this.getControl()).layout(true, true);
        }
    }

    public void setActionBars(IActionBars actionBars) {
        this.eventWidget.getAddAction().setActionDefinitionId("edu.mit.story.ui.commands.add.1");
        this.headWidget.getAddAction().setActionDefinitionId("edu.mit.story.ui.commands.add.2");
        this.polWidget.getCaptureAction().setActionDefinitionId("edu.mit.story.ui.commands.add.3");
        this.cardWidget.getCaptureAction().setActionDefinitionId("edu.mit.story.ui.commands.add.4");
        this.modeWidget.getCaptureAction().setActionDefinitionId("edu.mit.story.ui.commands.add.5");
        actionBars.setGlobalActionHandler(this.eventWidget.getAddAction().getActionDefinitionId(), this.eventWidget.getAddAction());
        actionBars.setGlobalActionHandler(this.headWidget.getAddAction().getActionDefinitionId(), this.headWidget.getAddAction());
        actionBars.setGlobalActionHandler(this.polWidget.getCaptureAction().getActionDefinitionId(), this.polWidget.getCaptureAction());
        actionBars.setGlobalActionHandler(this.cardWidget.getCaptureAction().getActionDefinitionId(), this.cardWidget.getCaptureAction());
        actionBars.setGlobalActionHandler(this.modeWidget.getCaptureAction().getActionDefinitionId(), this.modeWidget.getCaptureAction());
        this.eventWidget.getSubtractAction().setActionDefinitionId("edu.mit.story.ui.commands.subtract.1");
        this.headWidget.getSubtractAction().setActionDefinitionId("edu.mit.story.ui.commands.subtract.2");
        actionBars.setGlobalActionHandler(this.eventWidget.getSubtractAction().getActionDefinitionId(), this.eventWidget.getSubtractAction());
        actionBars.setGlobalActionHandler(this.headWidget.getSubtractAction().getActionDefinitionId(), this.headWidget.getSubtractAction());
        this.eventWidget.getClearAction().setActionDefinitionId("edu.mit.story.ui.commands.clear.1");
        this.headWidget.getClearAction().setActionDefinitionId("edu.mit.story.ui.commands.clear.2");
        this.polWidget.getClearAction().setActionDefinitionId("edu.mit.story.ui.commands.clear.3");
        this.cardWidget.getClearAction().setActionDefinitionId("edu.mit.story.ui.commands.clear.4");
        this.modeWidget.getClearAction().setActionDefinitionId("edu.mit.story.ui.commands.clear.5");
        this.clearAction.setActionDefinitionId("edu.mit.story.ui.commands.clear.0");
        actionBars.setGlobalActionHandler(this.eventWidget.getClearAction().getActionDefinitionId(), this.eventWidget.getClearAction());
        actionBars.setGlobalActionHandler(this.headWidget.getClearAction().getActionDefinitionId(), this.headWidget.getClearAction());
        actionBars.setGlobalActionHandler(this.polWidget.getClearAction().getActionDefinitionId(), this.polWidget.getClearAction());
        actionBars.setGlobalActionHandler(this.cardWidget.getClearAction().getActionDefinitionId(), this.cardWidget.getClearAction());
        actionBars.setGlobalActionHandler(this.modeWidget.getClearAction().getActionDefinitionId(), this.modeWidget.getClearAction());
        actionBars.setGlobalActionHandler(this.clearAction.getActionDefinitionId(), (IAction)this.clearAction);
        this.commitAction.setActionDefinitionId("edu.mit.story.ui.commands.commit.0");
        actionBars.setGlobalActionHandler(this.commitAction.getActionDefinitionId(), (IAction)this.commitAction);
    }

    public void stateChanged(ChangeEvent event) {
        this.updateFromModel();
    }

    public void dispose() {
        super.dispose();
        if (this.controller != null) {
            this.controller.dispose();
        }
        this.controller = null;
    }

    public void edit(IDesc desc) {
        if (desc == null) {
            throw new NullPointerException();
        }
        if (desc.getRep() != EventRep.getInstance()) {
            throw new IllegalArgumentException();
        }
        this.getController().load(desc);
    }
}

