/*
 * Decompiled with CFR 0.152.
 */
package edu.mit.semantics.ui.helpers;

import edu.mit.semantics.core.rep.context.ContextRelationRep;
import edu.mit.semantics.ui.content.ContextRelationContentProvider;
import edu.mit.semantics.ui.helpers.ContextRelationCreatorPage;
import edu.mit.semantics.ui.label.ContextRelationLabelProvider;
import edu.mit.story.core.model.change.IModelListener;
import edu.mit.story.core.model.change.StoryChangeEvent;
import edu.mit.story.ui.actions.ActionUtils;
import edu.mit.story.ui.actions.editor.StoryEditorRedoAction;
import edu.mit.story.ui.actions.editor.StoryEditorUndoAction;
import edu.mit.story.ui.actions.generic.CollapseAllAction;
import edu.mit.story.ui.actions.generic.ExpandAllAction;
import edu.mit.story.ui.editor.IStoryEditor;
import edu.mit.story.ui.helpers.HelperPage;
import edu.mit.story.ui.helpers.IDetailsPage;
import edu.mit.story.ui.items.CommandHooks;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.core.runtime.Platform;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.action.IContributionItem;
import org.eclipse.jface.action.IMenuListener;
import org.eclipse.jface.action.IMenuManager;
import org.eclipse.jface.action.MenuManager;
import org.eclipse.jface.viewers.AbstractTreeViewer;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.IPostSelectionProvider;
import org.eclipse.jface.viewers.ISelectionProvider;
import org.eclipse.jface.viewers.TreeViewer;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.ui.IActionBars;
import org.eclipse.ui.actions.ActionFactory;
import org.eclipse.ui.menus.CommandContributionItem;
import org.eclipse.ui.services.IServiceLocator;

public class ContextRelationDetailsPage
extends HelperPage
implements IDetailsPage,
IAdaptable {
    public static final String ID = ContextRelationCreatorPage.class.getName();
    private TreeViewer treeViewer;
    private IAction deleteAction;
    private IAction editAction;
    private IAction undoAction;
    private IAction redoAction;
    private IAction expandAction;
    private IAction collapseAction;
    private final IModelListener modelListener = new IModelListener(){

        public void modelChanged(StoryChangeEvent e) {
            if (ContextRelationDetailsPage.this.treeViewer == null) {
                return;
            }
            if (ContextRelationDetailsPage.this.treeViewer.getControl().isDisposed()) {
                return;
            }
            if (!e.affects(ContextRelationRep.getInstance())) {
                return;
            }
            ContextRelationDetailsPage.this.treeViewer.refresh();
        }
    };

    public void createControl(Composite parent) {
        this.treeViewer = new TreeViewer(parent, 772);
        this.treeViewer.setAutoExpandLevel(-1);
        this.treeViewer.setContentProvider((IContentProvider)new ContextRelationContentProvider(this.getStoryEditor()));
        this.treeViewer.setLabelProvider((IBaseLabelProvider)new ContextRelationLabelProvider(this.getStoryEditor()));
        this.treeViewer.setInput((Object)this.getStoryEditor());
        this.setControl((Control)this.treeViewer.getTree());
        CommandContributionItem deleteAction = CommandHooks.createDelete((IServiceLocator)this.getSite().getWorkbenchWindow());
        CommandContributionItem editAction = CommandHooks.createEdit((IServiceLocator)this.getSite().getWorkbenchWindow());
        this.undoAction = new StoryEditorUndoAction(this.getStoryEditor());
        this.redoAction = new StoryEditorRedoAction(this.getStoryEditor());
        this.expandAction = new ExpandAllAction((AbstractTreeViewer)this.treeViewer);
        this.collapseAction = new CollapseAllAction((AbstractTreeViewer)this.treeViewer, 2);
        MenuManager menu = new MenuManager();
        menu.setRemoveAllWhenShown(true);
        menu.addMenuListener(new IMenuListener(){

            public void menuAboutToShow(IMenuManager manager) {
                ActionUtils.createPopupGroups((IMenuManager)manager);
                manager.appendToGroup("group.edit", (IContributionItem)editAction);
                manager.appendToGroup("group.edit", (IContributionItem)deleteAction);
            }
        });
        this.getControl().setMenu(menu.createContextMenu(this.getControl()));
        this.getSite().registerContextMenu(String.valueOf(ID) + ".popupMenu", menu, (ISelectionProvider)this.treeViewer);
    }

    public void setActionBars(IActionBars actionBars) {
        actionBars.getToolBarManager().insertBefore("linking", this.collapseAction);
        actionBars.getToolBarManager().insertBefore(this.collapseAction.getId(), this.expandAction);
        actionBars.setGlobalActionHandler(ActionFactory.DELETE.getId(), this.deleteAction);
        actionBars.setGlobalActionHandler(ActionFactory.UNDO.getId(), this.undoAction);
        actionBars.setGlobalActionHandler(ActionFactory.REDO.getId(), this.redoAction);
        actionBars.setGlobalActionHandler("edu.mit.story.ui.command.edit", this.editAction);
    }

    public void setStoryEditor(IStoryEditor newEditor) {
        super.setStoryEditor(newEditor);
        this.getStoryEditor().getStoryModel().addModelListener(this.modelListener);
    }

    public void dispose() {
        this.getStoryEditor().getStoryModel().removeModelListener(this.modelListener);
        super.dispose();
    }

    public Object getAdapter(Class adapter) {
        if (adapter == ISelectionProvider.class) {
            return this.treeViewer;
        }
        if (adapter == IPostSelectionProvider.class) {
            return this.treeViewer;
        }
        return Platform.getAdapterManager().getAdapter((Object)this, adapter);
    }
}

