/*
 * Decompiled with CFR 0.152.
 */
package edu.mit.semantics.ui.controllers;

import edu.mit.semantics.core.rep.function.FunctionRep;
import edu.mit.semantics.core.rep.function.IFunction;
import edu.mit.semantics.core.rep.function.IFunctionInstance;
import edu.mit.semantics.core.rep.function.model.FunctionInstanceModel;
import edu.mit.semantics.core.rep.function.model.FunctionModel;
import edu.mit.semantics.core.rep.function.model.IFunctionInstanceModel;
import edu.mit.semantics.core.rep.function.model.IFunctionModel;
import edu.mit.semantics.ui.controllers.FunctionInstanceController;
import edu.mit.semantics.ui.controllers.IFunctionController;
import edu.mit.semantics.ui.controllers.IFunctionInstanceController;
import edu.mit.story.core.desc.IData;
import edu.mit.story.core.desc.IDesc;
import edu.mit.story.core.meta.timing.ITiming;
import edu.mit.story.core.meta.timing.Timing;
import edu.mit.story.core.model.IMutableStoryModel;
import edu.mit.story.core.model.IStoryModel;
import edu.mit.story.core.model.change.ChangeUtils;
import edu.mit.story.core.position.IHasPosition;
import edu.mit.story.core.rep.IRep;
import edu.mit.story.ui.editor.IStoryEditor;

public class FunctionController
implements IFunctionController {
    private final IStoryEditor editor;
    private final IFunctionModel functionModel;
    private final IFunctionInstanceController instanceController;

    public FunctionController(String annoID, IStoryEditor editor) {
        this.functionModel = new FunctionModel((IStoryModel)editor.getStoryModel());
        this.instanceController = new FunctionInstanceController(annoID, editor);
        this.editor = editor;
    }

    public IFunctionModel getModel() {
        return this.functionModel;
    }

    public IFunctionInstanceController getInstanceController() {
        return this.instanceController;
    }

    public IStoryEditor getStoryEditor() {
        return this.editor;
    }

    public void setSymbol(String symbol) {
        this.getModel().setSymbol(symbol);
    }

    public void setInverted(boolean value) {
        this.getModel().setInverted(value);
    }

    public void setSubType(String subtype) {
        this.getModel().setSubtype(subtype);
    }

    public void createInstance() {
        IFunctionInstanceModel instance;
        IFunctionInstanceModel instanceModel = this.instanceController.getModel();
        IFunctionInstance editTarget = instanceModel.getLoaded();
        if (editTarget == null) {
            instance = new FunctionInstanceModel(this.getModel().getStoryModel());
            this.functionModel.getInstances().add((Object)instance);
        } else {
            instance = (IFunctionInstanceModel)editTarget;
        }
        instance.load(instanceModel.create());
        this.instanceController.clear();
    }

    public void dispose() {
    }

    public void commit() {
        IFunctionModel model = this.getModel();
        if (model.getMessageType() == 3) {
            return;
        }
        Timing timing = new Timing(model.getStart(), "user");
        IFunction data = model.create();
        IHasPosition p = data.calculatePosition();
        ChangeUtils.edit((Object)this, (IMutableStoryModel)this.getStoryEditor().getStoryModel(), (IRep)FunctionRep.getInstance(), (IHasPosition)p, (IData)data, (ITiming)timing, (IDesc)model.getLoaded());
        this.clear();
    }

    public void edit(IDesc desc) {
        this.getModel().load(desc);
    }

    public void clear() {
        this.getModel().clear();
        this.getInstanceController().clear();
    }
}

