/*
 * Decompiled with CFR 0.152.
 */
package edu.mit.jwi.item;

import edu.mit.jwi.item.IIndexWordID;
import edu.mit.jwi.item.POS;
import java.util.regex.Pattern;

public class IndexWordID
implements IIndexWordID {
    public static final Pattern whitespace = Pattern.compile("\\s+");
    public static final String underscore = "_";
    final String fLemma;
    final POS fPOS;

    public IndexWordID(String lemma, POS pos) {
        if (pos == null) {
            throw new NullPointerException();
        }
        this.fLemma = whitespace.matcher(lemma.toLowerCase()).replaceAll(underscore);
        this.fPOS = pos;
    }

    public String getLemma() {
        return this.fLemma;
    }

    public POS getPOS() {
        return this.fPOS;
    }

    public int hashCode() {
        int PRIME = 31;
        int result = 1;
        result = 31 * result + this.fLemma.hashCode();
        result = 31 * result + this.fPOS.hashCode();
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof IIndexWordID)) {
            return false;
        }
        IIndexWordID other = (IIndexWordID)obj;
        if (!this.fLemma.equals(other.getLemma())) {
            return false;
        }
        return this.fPOS.equals((Object)other.getPOS());
    }

    public String toString() {
        return "XID-" + this.fLemma + "-" + this.fPOS.getTag();
    }

    public static IndexWordID parseIndexWordID(String value) {
        if (value == null) {
            return null;
        }
        if (!value.startsWith("XID-")) {
            return null;
        }
        int begin = 4;
        int end = value.lastIndexOf(45);
        if (end < begin) {
            return null;
        }
        String lemma = value.substring(begin, end);
        if (lemma.length() == 0) {
            return null;
        }
        begin = end + 1;
        if (begin >= value.length()) {
            return null;
        }
        char tag = Character.toLowerCase(value.charAt(begin));
        POS pos = null;
        try {
            pos = POS.getPartOfSpeech(tag);
        }
        catch (RuntimeException e) {
            return null;
        }
        if (pos == null) {
            return null;
        }
        return new IndexWordID(lemma, pos);
    }
}

