/*
 * Decompiled with CFR 0.152.
 */
package edu.mit.discourse.ui.views;

import edu.mit.discourse.core.rep.referent.IReference;
import edu.mit.discourse.core.rep.referent.IReferent;
import edu.mit.discourse.core.rep.referent.ReferentRep;
import edu.mit.discourse.core.rep.referent.change.RemoveReferenceChange;
import edu.mit.discourse.ui.DiscourseUIMessages;
import edu.mit.discourse.ui.actions.RenameReferent;
import edu.mit.discourse.ui.actions.delegates.AddReferencesByPattern;
import edu.mit.discourse.ui.content.ReferentContentProvider;
import edu.mit.discourse.ui.label.ReferentLabelProvider;
import edu.mit.discourse.ui.views.ReferenceHighlighter;
import edu.mit.story.core.desc.IDesc;
import edu.mit.story.core.meta.timing.ITiming;
import edu.mit.story.core.meta.timing.Timing;
import edu.mit.story.core.model.IMutableStoryModel;
import edu.mit.story.core.model.IStoryData;
import edu.mit.story.core.model.IStoryModel;
import edu.mit.story.core.model.RefreshListener;
import edu.mit.story.core.model.change.Flag;
import edu.mit.story.core.model.change.IFlag;
import edu.mit.story.core.model.change.IModelChange;
import edu.mit.story.core.model.change.IModelListener;
import edu.mit.story.core.rep.IHasRep;
import edu.mit.story.core.util.IHasRefresh;
import edu.mit.story.ui.actions.ActionUtils;
import edu.mit.story.ui.actions.DescActionUtils;
import edu.mit.story.ui.actions.SelectionUtils;
import edu.mit.story.ui.actions.generic.DeleteAction;
import edu.mit.story.ui.actions.generic.EditAction;
import edu.mit.story.ui.actions.generic.RefreshAction;
import edu.mit.story.ui.actions.generic.ResourceAction2;
import edu.mit.story.ui.actions.groups.StoryEditorUndoRedoActionGroup;
import edu.mit.story.ui.editor.IStoryEditor;
import java.util.HashSet;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.core.runtime.ISafeRunnable;
import org.eclipse.core.runtime.ListenerList;
import org.eclipse.core.runtime.SafeRunner;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.action.IMenuManager;
import org.eclipse.jface.action.IToolBarManager;
import org.eclipse.jface.action.MenuManager;
import org.eclipse.jface.util.SafeRunnable;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.ISelectionProvider;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.jface.viewers.TreeViewer;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Menu;
import org.eclipse.swt.widgets.Tree;
import org.eclipse.swt.widgets.TreeItem;
import org.eclipse.ui.IActionBars;
import org.eclipse.ui.ISelectionListener;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.IWorkbenchPart;
import org.eclipse.ui.actions.ActionFactory;
import org.eclipse.ui.actions.ActionGroup;
import org.eclipse.ui.part.IPage;
import org.eclipse.ui.part.IPageBookViewPage;
import org.eclipse.ui.part.MessagePage;
import org.eclipse.ui.part.Page;
import org.eclipse.ui.part.PageBook;
import org.eclipse.ui.part.PageBookView;

public class ReferentListView
extends PageBookView
implements IHasRefresh {
    IAction refreshAction;
    IAction highlightAction;

    public void createPartControl(Composite parent) {
        this.createActions();
        super.createPartControl(parent);
    }

    protected void createActions() {
        this.refreshAction = new RefreshAction((IHasRefresh)this);
        this.highlightAction = new HighlightAction();
        IActionBars actionBars = this.getViewSite().getActionBars();
        IToolBarManager toolbar = actionBars.getToolBarManager();
        toolbar.add(this.highlightAction);
        toolbar.add(this.refreshAction);
        actionBars.setGlobalActionHandler(ActionFactory.REFRESH.getId(), this.refreshAction);
        actionBars.updateActionBars();
    }

    protected IPage createDefaultPage(PageBook book) {
        MessagePage page = new MessagePage();
        this.initPage((IPageBookViewPage)page);
        page.createControl((Composite)book);
        page.setMessage(DiscourseUIMessages.MSG_NoReferentEnabledModelAvailable);
        return page;
    }

    protected PageBookView.PageRec doCreatePage(IWorkbenchPart part) {
        Object page;
        if (!this.isImportant(part)) {
            return null;
        }
        IStoryEditor editor = (IStoryEditor)part;
        if (editor.getStoryModel().supports(ReferentRep.getInstance())) {
            page = new ReferentListViewPage((IStoryEditor)part, this);
        } else {
            page = new MessagePage();
            page.setMessage(DiscourseUIMessages.MSG_NoReferentEnabledModelAvailable);
        }
        this.initPage((IPageBookViewPage)page);
        page.createControl((Composite)this.getPageBook());
        return new PageBookView.PageRec(part, (IPage)page);
    }

    protected void doDestroyPage(IWorkbenchPart part, PageBookView.PageRec pageRecord) {
        pageRecord.page.dispose();
        pageRecord.dispose();
    }

    protected IWorkbenchPart getBootstrapPart() {
        IWorkbenchPage page = this.getSite().getPage();
        if (page != null) {
            return page.getActiveEditor();
        }
        return null;
    }

    protected boolean isImportant(IWorkbenchPart part) {
        return part instanceof IStoryEditor;
    }

    protected void showPageRec(PageBookView.PageRec pageRec) {
        super.showPageRec(pageRec);
        if (pageRec.page instanceof ReferentListViewPage) {
            ReferentListViewPage rPage = (ReferentListViewPage)pageRec.page;
            this.highlightAction.setEnabled(true);
            this.highlightAction.setChecked(rPage.isHighlighting());
        } else {
            this.highlightAction.setEnabled(false);
            this.highlightAction.setChecked(false);
        }
    }

    public void refresh() {
        IPage page = this.getCurrentPage();
        if (page instanceof IHasRefresh) {
            ((IHasRefresh)page).refresh();
        }
    }

    protected class HighlightAction
    extends ResourceAction2 {
        public HighlightAction() {
            super(DiscourseUIMessages.getBundle(), DiscourseUIMessages.ACTION_ReferenceHighlight_prefix, 2);
        }

        public void run() {
            IPage page = ReferentListView.this.getCurrentPage();
            if (page instanceof ReferentListViewPage) {
                ReferentListViewPage rPage = (ReferentListViewPage)page;
                rPage.setHighlighting(this.isChecked());
            }
        }
    }

    public static class ReferentListViewPage
    extends Page
    implements IHasRefresh,
    IAdaptable,
    ISelectionListener,
    ISelectionChangedListener,
    ISelectionProvider {
        Button createButton;
        IStoryEditor editor;
        ReferentListView view;
        TreeViewer treeViewer;
        IModelListener refreshListener;
        ReferenceHighlighter refHighlighter;
        ListenerList selectionChangedListeners;
        ActionGroup undoRedoActions;
        IAction editAction;
        IAction deleteAction;
        IAction renameAction;
        IAction patternAddAction;

        public ReferentListViewPage(IStoryEditor editor, ReferentListView view) {
            this.view = view;
            this.editor = editor;
            this.selectionChangedListeners = new ListenerList();
            this.refreshListener = new RefreshListener((IHasRefresh)this, ReferentRep.getInstance(), (IFlag)Flag.DESCS);
            editor.getStoryModel().addModelListener(this.refreshListener);
            this.refHighlighter = ReferenceHighlighter.getHighlighter(editor);
        }

        public Control getControl() {
            return this.treeViewer.getTree();
        }

        public void createControl(Composite parent) {
            this.treeViewer = new TreeViewer(parent, 772);
            this.treeViewer.addSelectionChangedListener((ISelectionChangedListener)this);
            this.treeViewer.setAutoExpandLevel(-1);
            this.treeViewer.setContentProvider((IContentProvider)new ReferentContentProvider(this.editor));
            this.treeViewer.setLabelProvider((IBaseLabelProvider)new ReferentLabelProvider(this.editor));
            this.treeViewer.setInput((Object)this.editor);
            this.getSite().getPage().addPostSelectionListener((ISelectionListener)this);
            this.getSite().setSelectionProvider((ISelectionProvider)this);
            this.createActions();
        }

        protected void createTreeViewer(Composite parent) {
            this.treeViewer = new TreeViewer(parent, 772);
            this.treeViewer.addSelectionChangedListener((ISelectionChangedListener)this);
            this.treeViewer.setAutoExpandLevel(-1);
            this.treeViewer.setContentProvider((IContentProvider)new ReferentContentProvider(this.editor));
            this.treeViewer.setLabelProvider((IBaseLabelProvider)new ReferentLabelProvider(this.editor));
            this.treeViewer.setInput((Object)this.editor);
        }

        public TreeViewer getTreeViewer() {
            return this.treeViewer;
        }

        public void setFocus() {
            this.getControl().setFocus();
        }

        protected void createActions() {
            this.editAction = new EditReferentAction();
            this.deleteAction = new ReferentListDeleteAction();
            this.renameAction = new RenameReferent(this.editor, (ISelectionProvider)this.getTreeViewer());
            this.undoRedoActions = new StoryEditorUndoRedoActionGroup(this.editor);
            this.patternAddAction = new ReferentListAddByPatternAction();
            MenuManager manager = new MenuManager();
            ActionUtils.createPopupGroups((IMenuManager)manager);
            this.undoRedoActions.fillContextMenu((IMenuManager)manager);
            manager.appendToGroup("group.edit", this.renameAction);
            manager.appendToGroup("group.edit", this.editAction);
            manager.appendToGroup("group.edit", this.deleteAction);
            manager.appendToGroup("group.edit", this.patternAddAction);
            Menu menu = manager.createContextMenu(this.getControl());
            this.getTreeViewer().getTree().setMenu(menu);
            String menuID = "edu.mit.discourse.popup.referentsView";
            this.view.getSite().registerContextMenu(menuID, manager, (ISelectionProvider)this.getTreeViewer());
            IActionBars actionBars = this.getSite().getActionBars();
            actionBars.setGlobalActionHandler(ActionFactory.RENAME.getId(), this.renameAction);
            actionBars.setGlobalActionHandler(ActionFactory.DELETE.getId(), this.deleteAction);
            this.undoRedoActions.fillActionBars(actionBars);
            this.undoRedoActions.updateActionBars();
        }

        public boolean setHighlighting(boolean value) {
            return this.refHighlighter.setEnabled(value);
        }

        public boolean isHighlighting() {
            return this.refHighlighter.isEnabled();
        }

        public void refresh() {
            IReferent entity;
            IStoryData data = this.editor.getStoryModel().getData();
            IDesc desc = this.getImpliedSelectedReferent();
            long entityID = desc == null ? -1L : desc.getID();
            IReference ref = this.getDirectlySelectedReference();
            int refID = ref == null ? -1 : ref.getID();
            Object[] expandedArray = this.getTreeViewer().getExpandedElements();
            HashSet<Object> expandedSet = new HashSet<Object>(2 * expandedArray.length);
            Object[] objectArray = expandedArray;
            int n = expandedArray.length;
            int n2 = 0;
            while (n2 < n) {
                IDesc d;
                Object expanded = objectArray[n2];
                expandedSet.add(expanded);
                if (expanded instanceof IDesc && (d = data.getDescription(((IDesc)expanded).getID())) != null) {
                    expandedSet.add(d);
                }
                ++n2;
            }
            this.getTreeViewer().getTree().setRedraw(false);
            this.getTreeViewer().refresh();
            this.getTreeViewer().setExpandedElements(expandedSet.toArray());
            this.getTreeViewer().getTree().setRedraw(true);
            if (refID > 0 && (desc = this.editor.getStoryModel().getData().getDescriptions(ReferentRep.getInstance()).getDescription(entityID)) != null && (ref = (entity = (IReferent)desc.getData()).getReference(refID)) != null) {
                this.getTreeViewer().setSelection((ISelection)new StructuredSelection((Object)ref));
                return;
            }
            if (entityID > 0L && (desc = this.editor.getStoryModel().getData().getDescription(entityID)) != null) {
                this.getTreeViewer().setSelection((ISelection)new StructuredSelection((Object)desc));
                return;
            }
            this.setSelection(null);
        }

        public void selectionChanged(IWorkbenchPart part, ISelection selection) {
            if (part == this.view) {
                return;
            }
            IDesc desc = (IDesc)SelectionUtils.extractSingle((ISelection)selection, IDesc.class);
            if (desc == null) {
                return;
            }
            if (ReferentRep.getInstance().isType((IHasRep)desc)) {
                this.getTreeViewer().setSelection(selection);
            }
        }

        public void dispose() {
            this.editor.getStoryModel().removeModelListener(this.refreshListener);
            this.getSite().getPage().removePostSelectionListener((ISelectionListener)this);
            super.dispose();
        }

        protected IDesc getImpliedSelectedReferent() {
            IReference ref = this.getDirectlySelectedReference();
            if (ref == null) {
                return null;
            }
            Tree tree = this.getTreeViewer().getTree();
            TreeItem[] items = tree.getSelection();
            TreeItem childItem = null;
            TreeItem[] treeItemArray = items;
            int n = items.length;
            int n2 = 0;
            while (n2 < n) {
                TreeItem item = treeItemArray[n2];
                if (item.getData() == ref) {
                    childItem = item;
                    break;
                }
                ++n2;
            }
            if (childItem == null) {
                return null;
            }
            TreeItem parentItem = childItem.getParentItem();
            if (parentItem == null) {
                return null;
            }
            Object selected = parentItem.getData();
            if (selected instanceof IDesc) {
                IDesc desc = (IDesc)selected;
                return ReferentRep.getInstance().isType((IHasRep)desc) ? desc : null;
            }
            return null;
        }

        protected IDesc getDirectlySelectedReferent() {
            IDesc result = (IDesc)SelectionUtils.extractSingle((ISelection)this.getTreeViewer().getSelection(), IDesc.class);
            return ReferentRep.getInstance().isType((IHasRep)result) ? result : null;
        }

        protected IReference getDirectlySelectedReference() {
            return (IReference)SelectionUtils.extractSingle((ISelection)this.getTreeViewer().getSelection(), IReference.class);
        }

        public ISelection getSelection() {
            IStoryModel p = (IStoryModel)SelectionUtils.extractSingle((ISelection)this.treeViewer.getSelection(), IStoryModel.class);
            return p == null ? this.treeViewer.getSelection() : null;
        }

        public void setSelection(ISelection selection) {
            if (selection != null) {
                this.getTreeViewer().setSelection(selection);
            }
        }

        public void addSelectionChangedListener(ISelectionChangedListener listener) {
            this.selectionChangedListeners.add((Object)listener);
        }

        public void removeSelectionChangedListener(ISelectionChangedListener listener) {
            this.selectionChangedListeners.remove((Object)listener);
        }

        public void selectionChanged(SelectionChangedEvent event) {
            IDesc desc = this.getImpliedSelectedReferent();
            this.refHighlighter.setHighlightedReferent(desc);
            this.fireSelectionChanged(this.getSelection());
        }

        protected void fireSelectionChanged(ISelection selection) {
            if (selection == null) {
                return;
            }
            final SelectionChangedEvent event = new SelectionChangedEvent((ISelectionProvider)this, selection);
            Object[] listeners = this.selectionChangedListeners.getListeners();
            int i = 0;
            while (i < listeners.length) {
                final ISelectionChangedListener l = (ISelectionChangedListener)listeners[i];
                SafeRunner.run((ISafeRunnable)new SafeRunnable(){

                    public void run() {
                        l.selectionChanged(event);
                    }
                });
                ++i;
            }
        }

        public Object getAdapter(Class adapter) {
            return this.editor.getAdapter(adapter);
        }

        protected class EditReferentAction
        extends EditAction {
            protected EditReferentAction() {
            }

            protected void doEdit() {
            }
        }

        protected class ReferentListAddByPatternAction
        extends ResourceAction2
        implements ISelectionChangedListener {
            public ReferentListAddByPatternAction() {
                super(DiscourseUIMessages.getBundle(), DiscourseUIMessages.ACTION_AddReferencesByPattern_prefix);
                ReferentListViewPage.this.getTreeViewer().addSelectionChangedListener((ISelectionChangedListener)this);
            }

            public void run() {
                AddReferencesByPattern.addByPattern(ReferentListViewPage.this.editor, ReferentListViewPage.this.getImpliedSelectedReferent(), (Object)this);
            }

            public void selectionChanged(SelectionChangedEvent event) {
                this.setEnabled(ReferentListViewPage.this.getImpliedSelectedReferent() != null);
            }
        }

        protected class ReferentListDeleteAction
        extends DeleteAction
        implements ISelectionChangedListener {
            public ReferentListDeleteAction() {
                ReferentListViewPage.this.getTreeViewer().addSelectionChangedListener((ISelectionChangedListener)this);
            }

            protected void doDelete() {
                IDesc referent = ReferentListViewPage.this.getDirectlySelectedReferent();
                if (referent != null) {
                    DescActionUtils.doDelete((Object)((Object)this), (IDesc)referent, (IMutableStoryModel)ReferentListViewPage.this.editor.getStoryModel());
                    return;
                }
                IReference ref = ReferentListViewPage.this.getDirectlySelectedReference();
                referent = ReferentListViewPage.this.getImpliedSelectedReferent();
                Timing timing = new Timing("user", true);
                ReferentListViewPage.this.editor.getStoryModel().applyChange((Object)this, (IModelChange)new RemoveReferenceChange(ref, referent, (ITiming)timing), false);
            }

            public void selectionChanged(SelectionChangedEvent event) {
                boolean enable = false;
                IDesc referent = ReferentListViewPage.this.getDirectlySelectedReferent();
                enable = referent != null ? DescActionUtils.canDelete((IDesc)referent, (IMutableStoryModel)ReferentListViewPage.this.editor.getStoryModel()) : ReferentListViewPage.this.getDirectlySelectedReference() != null;
                this.setEnabled(enable);
            }
        }
    }
}

