/*
 * Decompiled with CFR 0.152.
 */
package edu.mit.parsing.ui.handlers;

import edu.mit.parsing.core.rep.stem.AssignStemChange;
import edu.mit.parsing.core.rep.stem.IStemData;
import edu.mit.parsing.core.rep.stem.StemData;
import edu.mit.parsing.core.util.IBaseWordInfo;
import edu.mit.parsing.core.util.ParsingUtils;
import edu.mit.parsing.core.util.WordInfo;
import edu.mit.parsing.ui.dialogs.StemSpecificationDialog;
import edu.mit.parsing.ui.dialogs.WordSelectionDialog;
import edu.mit.story.core.desc.IDesc;
import edu.mit.story.core.desc.IDescSet;
import edu.mit.story.core.meta.timing.ITiming;
import edu.mit.story.core.meta.timing.Timing;
import edu.mit.story.core.model.IStoryModel;
import edu.mit.story.core.model.change.IModelChange;
import edu.mit.story.ui.editor.IStoryEditor;
import java.util.Date;
import org.eclipse.core.commands.AbstractHandler;
import org.eclipse.core.commands.ExecutionEvent;
import org.eclipse.core.commands.ExecutionException;
import org.eclipse.core.expressions.EvaluationContext;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.handlers.HandlerUtil;

public class AssignStemHandler
extends AbstractHandler {
    public void setEnabled(Object context) {
        EvaluationContext evalContext;
        Object var;
        if (context instanceof EvaluationContext && (var = (evalContext = (EvaluationContext)context).getVariable("activeEditor")) instanceof IStoryEditor) {
            IStoryEditor editor = (IStoryEditor)var;
            IDescSet tokens = ParsingUtils.getSelectedTokens((IStoryEditor)editor);
            this.setBaseEnabled(!tokens.isEmpty());
            return;
        }
        this.setBaseEnabled(false);
    }

    public Object execute(ExecutionEvent event) throws ExecutionException {
        Date start = new Date();
        IStoryEditor editor = (IStoryEditor)HandlerUtil.getActiveEditor((ExecutionEvent)event);
        IDescSet tokens = ParsingUtils.getSelectedTokens((IStoryEditor)editor);
        if (tokens.isEmpty()) {
            PlatformUI.getWorkbench().getDisplay().beep();
            return null;
        }
        IDesc word = WordSelectionDialog.open(editor);
        if (word == null) {
            return null;
        }
        WordInfo info = WordInfo.extract((IDesc)word, (IStoryModel)editor.getStoryModel());
        StemSpecificationDialog dialog = StemSpecificationDialog.create(editor.getSite().getShell(), (IBaseWordInfo)info, true);
        dialog.open();
        if (dialog.getReturnCode() == 1) {
            return null;
        }
        StemData newStem = null;
        if (dialog.getReturnCode() == 0) {
            newStem = new StemData(dialog.getValue());
        }
        Timing timing = new Timing(start, ((Object)((Object)this)).getClass().getCanonicalName());
        editor.getStoryModel().applyChange((Object)this, (IModelChange)new AssignStemChange((IStemData)newStem, word.getID(), (ITiming)timing), false);
        return null;
    }
}

