/*
 * Decompiled with CFR 0.152.
 */
package edu.mit.semantics.core.rep.timelink.rules;

import edu.mit.semantics.core.rep.event.EventRep;
import edu.mit.semantics.core.rep.timelink.ITimeLink;
import edu.mit.semantics.core.rep.timelink.TimeLinkRep;
import edu.mit.semantics.core.rep.timelink.problems.NoLinkProblem;
import edu.mit.semantics.core.rep.timex3.Timex3Rep;
import edu.mit.story.core.build.AbstractBuildRule;
import edu.mit.story.core.build.IStoryProblem;
import edu.mit.story.core.desc.IDesc;
import edu.mit.story.core.desc.IDescSet;
import edu.mit.story.core.meta.check.CheckMetaRep;
import edu.mit.story.core.model.IStoryModel;
import edu.mit.story.core.position.HasPositionSet;
import edu.mit.story.core.position.IHasPositionSet;
import java.util.HashSet;
import java.util.Iterator;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class TimeLinksRule
extends AbstractBuildRule {
    public static final String ID = TimeLinksRule.class.getCanonicalName();

    public TimeLinksRule() {
        super(TimeLinkRep.getInstance());
    }

    public IHasPositionSet<IStoryProblem> build(IStoryModel model) {
        IDescSet events = model.getData().getDescriptions(EventRep.getInstance());
        IDescSet times = model.getData().getDescriptions(Timex3Rep.getInstance());
        HashSet nolink = new HashSet(events.size() + times.size());
        nolink.addAll(events);
        nolink.addAll(times);
        for (IDesc linkDesc : model.getData().getDescriptions(TimeLinkRep.getInstance())) {
            ITimeLink link = (ITimeLink)linkDesc.getData();
            nolink.remove(link.getSource());
            nolink.remove(link.getRelated());
        }
        Iterator i = nolink.iterator();
        while (i.hasNext()) {
            if (!CheckMetaRep.isChecked((IDesc)((IDesc)i.next()), (String)"edu.mit.semantics.timelink.problem.noTimeLink")) continue;
            i.remove();
        }
        if (nolink.isEmpty()) {
            return null;
        }
        HasPositionSet result = new HasPositionSet();
        for (IDesc desc : nolink) {
            result.add((Object)new NoLinkProblem(desc, this.getID()));
        }
        return result;
    }
}

