/*
 * Decompiled with CFR 0.152.
 */
package edu.mit.semantics.core.rep.timelink.rules;

import edu.mit.semantics.core.rep.event.EventRep;
import edu.mit.semantics.core.rep.event.IEvent;
import edu.mit.semantics.core.rep.timelink.ITimeLink;
import edu.mit.semantics.core.rep.timelink.LinkType;
import edu.mit.semantics.core.rep.timelink.LinkTypeSubordinate;
import edu.mit.semantics.core.rep.timelink.TimeLinkRep;
import edu.mit.semantics.core.rep.timelink.problems.NoSubordinatingLinkProblem;
import edu.mit.story.core.build.AbstractBuildRule;
import edu.mit.story.core.build.IStoryProblem;
import edu.mit.story.core.desc.IDesc;
import edu.mit.story.core.desc.IDescSet;
import edu.mit.story.core.model.IStoryModel;
import edu.mit.story.core.position.HasPositionSet;
import edu.mit.story.core.position.IHasPositionSet;
import java.util.HashSet;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SubordinatingLinksRule
extends AbstractBuildRule {
    public static final String ID = SubordinatingLinksRule.class.getCanonicalName();

    public SubordinatingLinksRule() {
        super(TimeLinkRep.getInstance());
    }

    public IHasPositionSet<IStoryProblem> build(IStoryModel model) {
        IDescSet events = model.getData().getDescriptions(EventRep.getInstance());
        HashSet<IDesc> perception = new HashSet<IDesc>(events.size());
        HashSet<IDesc> intensional = new HashSet<IDesc>(events.size());
        HashSet<IDesc> reporting = new HashSet<IDesc>(events.size());
        for (IDesc eventDesc : events) {
            IEvent event = (IEvent)eventDesc.getData();
            switch (event.getEventClass()) {
                case PERCEPTION: {
                    perception.add(eventDesc);
                    break;
                }
                case I_ACTION: 
                case I_STATE: {
                    intensional.add(eventDesc);
                }
                case REPORTING: {
                    reporting.add(eventDesc);
                }
            }
        }
        for (IDesc linkDesc : model.getData().getDescriptions(TimeLinkRep.getInstance())) {
            ITimeLink link = (ITimeLink)linkDesc.getData();
            if (link.getRelationType().getType() != LinkType.SUBORDINATING) continue;
            LinkTypeSubordinate relation = (LinkTypeSubordinate)link.getRelationType();
            reporting.remove(link.getSource());
            switch (relation) {
                case EVIDENTIAL: 
                case NEG_EVIDENTIAL: {
                    perception.remove(link.getSource());
                    break;
                }
                case MODAL: 
                case FACTIVE: 
                case COUNTER_FACTIVE: {
                    intensional.remove(link.getSource());
                }
            }
        }
        if (reporting.isEmpty() && perception.isEmpty() && intensional.isEmpty()) {
            return null;
        }
        HasPositionSet result = new HasPositionSet();
        for (IDesc desc : reporting) {
            result.add((Object)new NoSubordinatingLinkProblem(desc, this.getID()));
        }
        for (IDesc desc : perception) {
            result.add((Object)new NoSubordinatingLinkProblem(desc, this.getID()));
        }
        for (IDesc desc : intensional) {
            result.add((Object)new NoSubordinatingLinkProblem(desc, this.getID()));
        }
        return result;
    }
}

