/*
 * Decompiled with CFR 0.152.
 */
package edu.mit.semantics.core.rep.function;

import edu.mit.semantics.core.rep.function.IFunctionTag;
import edu.mit.story.core.util.StringUtils;

public class FunctionTag
implements IFunctionTag {
    private final String symbol;
    private final String subtype;
    private final boolean isInverted;
    private final boolean isGeneric;

    public FunctionTag(String str) {
        this(str, false);
    }

    public FunctionTag(String str, boolean isInverted) {
        this(str, isInverted, "");
    }

    public FunctionTag(String symbol, String subtype) {
        this(symbol, false, subtype);
    }

    public FunctionTag(String symbol, boolean isInverted, String subtype) {
        if (symbol == null) {
            throw new NullPointerException();
        }
        if (subtype == null) {
            subtype = "";
        }
        symbol = symbol.trim();
        subtype = subtype.trim();
        if (StringUtils.containsWhitespace((CharSequence)symbol)) {
            throw new IllegalArgumentException();
        }
        if (StringUtils.containsWhitespace((CharSequence)subtype)) {
            throw new IllegalArgumentException();
        }
        this.symbol = symbol;
        this.subtype = subtype;
        this.isInverted = isInverted;
        this.isGeneric = subtype.length() == 0;
    }

    public String getSymbol() {
        return this.symbol;
    }

    public boolean isInverted() {
        return this.isInverted;
    }

    public String getSubtype() {
        return this.subtype;
    }

    public boolean isGeneric() {
        return this.isGeneric;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        FunctionTag other = (FunctionTag)obj;
        if (this.isInverted != other.isInverted) {
            return false;
        }
        if (!this.subtype.equals(other.subtype)) {
            return false;
        }
        return this.symbol.equals(other.symbol);
    }

    public int hashCode() {
        int result = 1;
        result = 31 * result + (this.isInverted ? 1231 : 1237);
        result = 31 * result + this.subtype.hashCode();
        result = 31 * result + this.symbol.hashCode();
        return result;
    }

    public String toString() {
        return FunctionTag.serialize(this);
    }

    public static String serialize(IFunctionTag tag) {
        int len = tag.getSymbol().length();
        if (tag.isInverted()) {
            ++len;
        }
        StringBuilder sb = new StringBuilder(len += tag.getSubtype().length());
        sb.append(tag.getSymbol());
        if (tag.isInverted()) {
            sb.append('_');
        }
        sb.append(tag.getSubtype());
        return sb.toString();
    }

    public static FunctionTag reconstitute(String str) {
        int i = 0;
        while (i < str.length()) {
            if (!Character.isLetter(str.charAt(i))) break;
            ++i;
        }
        if (i == str.length()) {
            return new FunctionTag(str);
        }
        boolean isInverted = str.charAt(i) == '_';
        int subtypeStart = isInverted ? i + 1 : i;
        String symbol = str.substring(0, i);
        String subtype = str.substring(subtypeStart, str.length());
        return new FunctionTag(symbol, isInverted, subtype);
    }
}

