/*
 * Decompiled with CFR 0.152.
 */
package edu.mit.parsing.core.rep.tag.tagset.models;

import edu.mit.parsing.core.rep.tag.tagset.ITag;
import edu.mit.parsing.core.rep.tag.tagset.ITagset;
import edu.mit.parsing.core.rep.tag.tagset.Tag;
import edu.mit.parsing.core.rep.tag.tagset.models.ITagModel;
import edu.mit.story.core.datamodel.AbstractViewModel;
import edu.mit.story.core.validation.Message;
import org.eclipse.jface.dialogs.IMessageProvider;
import org.w3c.dom.Element;

public class TagModel
extends AbstractViewModel
implements ITagModel {
    private ITagset tagset;
    private String id;
    private String name;
    private String description;
    private Element element;

    public ITag create(ITagset tagset) {
        return new Tag(this.getID(), this.getName(), this.getDescription(), tagset);
    }

    public ITagset getTagSet() {
        return this.tagset;
    }

    public void setTagSet(ITagset tagset) {
        this.tagset = tagset;
    }

    public String getID() {
        return this.id;
    }

    public String getName() {
        return this.name;
    }

    public String getDescription() {
        return this.description;
    }

    public void setID(String id) {
        if (id != null) {
            id = id.trim();
        }
        this.id = id;
    }

    public void setName(String name) {
        this.name = name;
    }

    public void setDescription(String description) {
        if (description == null) {
            description = "";
        }
        this.description = description;
    }

    protected void internalClear() {
        this.tagset = null;
        this.id = null;
        this.name = null;
        this.description = "";
    }

    protected IMessageProvider calculateMessage() {
        if (this.id == null || this.id.trim().length() == 0) {
            return new Message("The id must be set to a non-null, non-empty value", 3);
        }
        if (this.name == null || this.name.trim().length() == 0) {
            return new Message("The name must be set to a non-null, non-empty value", 3);
        }
        return null;
    }

    public boolean isCleared() {
        if (this.tagset != null) {
            return false;
        }
        if (this.id != null) {
            return false;
        }
        if (this.name != null) {
            return false;
        }
        return this.description.trim().length() != 0;
    }

    public Element getElement() {
        return this.element;
    }

    public void load(Element e) {
        this.clear();
        this.element = e;
        this.setID(e.getAttribute("id"));
        this.setName(e.getAttribute("name"));
        this.setDescription(e.getAttribute("desc"));
    }

    public void setElement(Element e) {
        this.element = e;
    }
}

