/*
 * Decompiled with CFR 0.152.
 */
package edu.mit.parsing.core.rep.stem;

import edu.mit.parsing.core.rep.colloc.CollocRep;
import edu.mit.parsing.core.rep.pos.GenericTag;
import edu.mit.parsing.core.rep.pos.IPosTag;
import edu.mit.parsing.core.rep.pos.ITag;
import edu.mit.parsing.core.rep.pos.POSRep;
import edu.mit.parsing.core.rep.stem.IStem;
import edu.mit.parsing.core.rep.stem.StemData;
import edu.mit.parsing.core.rep.token.TokenRep;
import edu.mit.story.core.align.IAlignedStoryModel;
import edu.mit.story.core.desc.Desc;
import edu.mit.story.core.desc.DescSet;
import edu.mit.story.core.desc.IData;
import edu.mit.story.core.desc.IDesc;
import edu.mit.story.core.desc.IDescSet;
import edu.mit.story.core.desc.IStructuredData;
import edu.mit.story.core.meta.merge.MergeMetaRep;
import edu.mit.story.core.model.IStoryModel;
import edu.mit.story.core.position.IHasPosition;
import edu.mit.story.core.rep.IHasRep;
import java.util.Collection;
import java.util.Iterator;
import java.util.SortedSet;

public class Stem
extends StemData
implements IStem {
    private final IDesc token;
    private final IDesc pos;

    public Stem(IDesc target, String stem) {
        super(stem);
        if (TokenRep.getInstance().isType((IHasRep)target) || CollocRep.getInstance().isType((IHasRep)target)) {
            this.token = target;
            this.pos = null;
        } else if (POSRep.getInstance().isType((IHasRep)target)) {
            IPosTag tag = (IPosTag)target.getData();
            this.token = tag.getWord();
            this.pos = target;
        } else {
            throw new IllegalArgumentException();
        }
    }

    public IDesc getWord() {
        return this.token;
    }

    public IDesc getPOS() {
        return this.pos;
    }

    public ITag getTag() {
        if (this.pos == null) {
            return GenericTag.UNKNOWN;
        }
        IPosTag tag = (IPosTag)this.pos.getData();
        return tag.getTag();
    }

    public boolean isAuxiliary() {
        if (this.pos == null) {
            return false;
        }
        IPosTag tag = (IPosTag)this.pos.getData();
        return tag.isAuxiliary();
    }

    public IHasPosition calculatePosition() {
        return this.token;
    }

    public IHasPosition getDisplayPosition() {
        return this.token;
    }

    public IStructuredData recalculate(IDesc container, IStoryModel model) {
        IDesc newToken = model.getData().getDescriptions(this.token.getRep()).getDescription(this.token.getID());
        if (newToken == null) {
            return null;
        }
        IDesc newPOS = null;
        if (this.pos != null) {
            newPOS = model.getData().getDescriptions(this.pos.getRep()).getDescription(this.pos.getID());
        }
        if (newPOS == null) {
            IDescSet posTags = model.getData().getDescriptions(POSRep.getInstance());
            newPOS = Stem.findMatchingPOS(container, newToken, posTags);
        }
        if (newToken == this.token && newPOS == this.pos) {
            return this;
        }
        if (newPOS != null) {
            return new Stem(newPOS, this.getStem());
        }
        return new Stem(newToken, this.getStem());
    }

    public static IDesc findMatchingPOS(IDesc container, IDesc word, IDescSet allTags) {
        IDescSet matchSet = allTags.matchSet((IHasPosition)word);
        SortedSet mergeProfile = MergeMetaRep.extractMergeProfile((IDesc)container);
        DescSet sameWord = new DescSet(POSRep.getInstance(), (Collection)matchSet);
        DescSet matching = new DescSet(POSRep.getInstance());
        Iterator i = sameWord.iterator();
        while (i.hasNext()) {
            IDesc posDesc = (IDesc)i.next();
            IPosTag posTag = (IPosTag)posDesc.getData();
            if (posTag.getWord() != word) {
                i.remove();
                continue;
            }
            if (!MergeMetaRep.matches((IDesc)posDesc, (Collection)mergeProfile)) continue;
            matching.add((Object)posDesc);
        }
        if (matching.isEmpty()) {
            matching.addAll((Collection)sameWord);
        }
        return matching.size() == 1 ? (IDesc)matching.first() : null;
    }

    public boolean equals(IData tgtData, IAlignedStoryModel model) {
        if (this == tgtData) {
            return true;
        }
        if (!IStem.class.isAssignableFrom(tgtData.getClass())) {
            return false;
        }
        IStem tgtStem = (IStem)tgtData;
        if (!this.getStem().equals(tgtStem.getStem())) {
            return false;
        }
        if (!this.token.equals(tgtStem.getWord(), model)) {
            return false;
        }
        return Desc.equals((IDesc)this.pos, (IDesc)tgtStem.getPOS(), (IAlignedStoryModel)model);
    }
}

