/*
 * Decompiled with CFR 0.152.
 */
package edu.mit.parsing.core.rep.colloc.problems;

import com.google.common.base.Function;
import com.google.common.base.Joiner;
import com.google.common.collect.Collections2;
import edu.mit.parsing.core.rep.colloc.CollocRep;
import edu.mit.parsing.core.rep.colloc.IColloc;
import edu.mit.parsing.core.rep.token.IToken;
import edu.mit.parsing.core.rep.token.TokenRep;
import edu.mit.story.core.build.StoryProblem;
import edu.mit.story.core.desc.IDesc;
import edu.mit.story.core.desc.IDescSet;
import edu.mit.story.core.position.IHasPosition;
import java.util.Collection;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class OverlappingMWEProblem
extends StoryProblem {
    public static final String ID = "edu.mit.parsing.core.problem.overlappingMWE";
    private static final Function<IDesc, String> mweStringFunction = new Function<IDesc, String>(){

        public String apply(IDesc input) {
            IColloc c = (IColloc)input.getData();
            return c.getSurface();
        }
    };

    public OverlappingMWEProblem(IDesc td, Collection<IDesc> mwes, String buildRuleID) {
        super(CollocRep.getInstance(), buildRuleID);
        this.setID(ID);
        this.setName("Overlapping Multi-word Expression");
        this.setDescs(mwes);
        this.getDescs().add((Object)td);
        this.setSeverity(2);
        IDescSet mweDs = this.getDescs().getDescriptions(CollocRep.getInstance());
        if (mweDs.size() < 1) {
            throw new IllegalArgumentException();
        }
        IDescSet tokenDs = this.getDescs().getDescriptions(TokenRep.getInstance());
        if (tokenDs.size() != 1) {
            throw new IllegalArgumentException();
        }
        IDesc tokenD = (IDesc)tokenDs.first();
        this.setPosition((IHasPosition)tokenD);
        IToken token = (IToken)tokenD.getData();
        String mweStr = Joiner.on((String)", ").join((Iterable)Collections2.transform((Collection)mweDs, mweStringFunction));
        StringBuilder sb = new StringBuilder();
        sb.append("The token '");
        sb.append(token.getSurface());
        sb.append("' is shared between ");
        sb.append(Integer.toString(mweDs.size()));
        sb.append(" multi-word expressions (");
        sb.append(mweStr);
        sb.append(")");
        this.setDescription(sb.toString());
    }
}

