/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ui.navigator;

import java.util.LinkedHashSet;
import org.eclipse.jface.util.LocalSelectionTransfer;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.ISelectionProvider;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.swt.dnd.DragSource;
import org.eclipse.swt.dnd.DragSourceAdapter;
import org.eclipse.swt.dnd.DragSourceEvent;
import org.eclipse.swt.dnd.Transfer;
import org.eclipse.swt.widgets.Control;
import org.eclipse.ui.internal.navigator.NavigatorPlugin;
import org.eclipse.ui.internal.navigator.dnd.NavigatorPluginDropAction;
import org.eclipse.ui.navigator.CommonDragAdapterAssistant;
import org.eclipse.ui.navigator.INavigatorContentService;
import org.eclipse.ui.navigator.INavigatorDnDService;
import org.eclipse.ui.part.PluginTransfer;

public final class CommonDragAdapter
extends DragSourceAdapter {
    private static final boolean DEBUG = false;
    private final INavigatorContentService contentService;
    private final ISelectionProvider provider;

    public CommonDragAdapter(INavigatorContentService aContentService, ISelectionProvider aProvider) {
        this.contentService = aContentService;
        this.provider = aProvider;
    }

    public Transfer[] getSupportedDragTransfers() {
        CommonDragAdapterAssistant[] assistants = this.contentService.getDnDService().getCommonDragAssistants();
        LinkedHashSet<Object> supportedTypes = new LinkedHashSet<Object>();
        supportedTypes.add(PluginTransfer.getInstance());
        supportedTypes.add(LocalSelectionTransfer.getTransfer());
        Transfer[] transferTypes = null;
        int i = 0;
        while (i < assistants.length) {
            transferTypes = assistants[i].getSupportedTransferTypes();
            int j = 0;
            while (j < transferTypes.length) {
                if (transferTypes[j] != null) {
                    supportedTypes.add(transferTypes[j]);
                }
                ++j;
            }
            ++i;
        }
        Transfer[] transfers = supportedTypes.toArray(new Transfer[supportedTypes.size()]);
        return transfers;
    }

    public void dragStart(DragSourceEvent event) {
        try {
            DragSource dragSource = (DragSource)event.widget;
            Control control = dragSource.getControl();
            if (control == control.getDisplay().getFocusControl()) {
                ISelection selection = this.provider.getSelection();
                if (!selection.isEmpty()) {
                    LocalSelectionTransfer.getTransfer().setSelection(selection);
                    event.doit = true;
                } else {
                    event.doit = false;
                }
            } else {
                event.doit = false;
            }
        }
        catch (RuntimeException e) {
            NavigatorPlugin.logError(0, e.getMessage(), e);
        }
    }

    public void dragSetData(DragSourceEvent event) {
        ISelection selection = LocalSelectionTransfer.getTransfer().getSelection();
        if (LocalSelectionTransfer.getTransfer().isSupportedType(event.dataType)) {
            event.data = selection;
        } else if (PluginTransfer.getInstance().isSupportedType(event.dataType)) {
            event.data = NavigatorPluginDropAction.createTransferData(this.contentService);
        } else if (selection instanceof IStructuredSelection) {
            INavigatorDnDService dndService = this.contentService.getDnDService();
            CommonDragAdapterAssistant[] assistants = dndService.getCommonDragAssistants();
            int i = 0;
            while (i < assistants.length) {
                Transfer[] supportedTransferTypes = assistants[i].getSupportedTransferTypes();
                int j = 0;
                while (j < supportedTransferTypes.length) {
                    if (supportedTransferTypes[j].isSupportedType(event.dataType)) {
                        try {
                            if (assistants[i].setDragData(event, (IStructuredSelection)selection)) {
                                return;
                            }
                        }
                        catch (RuntimeException re) {
                            NavigatorPlugin.logError(0, re.getMessage(), re);
                        }
                    }
                    ++j;
                }
                ++i;
            }
            event.doit = false;
        } else {
            event.doit = false;
        }
    }

    public void dragFinished(DragSourceEvent event) {
        LocalSelectionTransfer.getTransfer().setSelection(null);
    }
}

