/*
 * Decompiled with CFR 0.152.
 */
package edu.stanford.nlp.util;

import edu.stanford.nlp.util.ArrayMap;
import java.io.Serializable;
import java.util.HashMap;
import java.util.IdentityHashMap;
import java.util.Map;
import java.util.TreeMap;
import java.util.WeakHashMap;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class MapFactory
implements Serializable {
    private static final long serialVersionUID = 4529666940763477360L;
    public static final MapFactory HASH_MAP_FACTORY = new HashMapFactory();
    public static final MapFactory IDENTITY_HASH_MAP_FACTORY = new IdentityHashMapFactory();
    public static final MapFactory WEAK_HASH_MAP_FACTORY = new WeakHashMapFactory();
    public static final MapFactory TREE_MAP_FACTORY = new TreeMapFactory();
    public static final MapFactory ARRAY_MAP_FACTORY = new ArrayMapFactory();

    private MapFactory() {
    }

    public abstract Map newMap();

    public abstract Map newMap(int var1);

    public abstract <K1, V1> Map<K1, V1> setMap(Map<K1, V1> var1);

    public abstract <K1, V1> Map<K1, V1> setMap(Map<K1, V1> var1, int var2);

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class ArrayMapFactory
    extends MapFactory {
        private ArrayMapFactory() {
        }

        @Override
        public Map newMap() {
            return new ArrayMap();
        }

        @Override
        public Map newMap(int initCapacity) {
            return new ArrayMap(initCapacity);
        }

        @Override
        public <K1, V1> Map<K1, V1> setMap(Map<K1, V1> map) {
            return new ArrayMap();
        }

        @Override
        public <K1, V1> Map<K1, V1> setMap(Map<K1, V1> map, int initCapacity) {
            map = new ArrayMap<K1, V1>(initCapacity);
            return map;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class TreeMapFactory
    extends MapFactory {
        private static final long serialVersionUID = -9138736068025818670L;

        private TreeMapFactory() {
        }

        @Override
        public Map newMap() {
            return new TreeMap();
        }

        @Override
        public Map newMap(int initCapacity) {
            return this.newMap();
        }

        @Override
        public <K1, V1> Map<K1, V1> setMap(Map<K1, V1> map) {
            map = new TreeMap<K1, V1>();
            return map;
        }

        @Override
        public <K1, V1> Map<K1, V1> setMap(Map<K1, V1> map, int initCapacity) {
            map = new TreeMap<K1, V1>();
            return map;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class WeakHashMapFactory
    extends MapFactory {
        private static final long serialVersionUID = 4790014244304941000L;

        private WeakHashMapFactory() {
        }

        @Override
        public Map newMap() {
            return new WeakHashMap();
        }

        @Override
        public Map newMap(int initCapacity) {
            return new WeakHashMap(initCapacity);
        }

        @Override
        public <K1, V1> Map<K1, V1> setMap(Map<K1, V1> map) {
            map = new WeakHashMap<K1, V1>();
            return map;
        }

        @Override
        public <K1, V1> Map<K1, V1> setMap(Map<K1, V1> map, int initCapacity) {
            map = new WeakHashMap<K1, V1>(initCapacity);
            return map;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class IdentityHashMapFactory
    extends MapFactory {
        private static final long serialVersionUID = -9222344631596580863L;

        private IdentityHashMapFactory() {
        }

        @Override
        public Map newMap() {
            return new IdentityHashMap();
        }

        @Override
        public Map newMap(int initCapacity) {
            return new IdentityHashMap(initCapacity);
        }

        @Override
        public <K1, V1> Map<K1, V1> setMap(Map<K1, V1> map) {
            map = new IdentityHashMap<K1, V1>();
            return map;
        }

        @Override
        public <K1, V1> Map<K1, V1> setMap(Map<K1, V1> map, int initCapacity) {
            map = new IdentityHashMap<K1, V1>(initCapacity);
            return map;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class HashMapFactory
    extends MapFactory {
        private static final long serialVersionUID = -9222344631596580863L;

        private HashMapFactory() {
        }

        @Override
        public Map newMap() {
            return new HashMap();
        }

        @Override
        public Map newMap(int initCapacity) {
            return new HashMap(initCapacity);
        }

        @Override
        public <K1, V1> Map<K1, V1> setMap(Map<K1, V1> map) {
            map = new HashMap<K1, V1>();
            return map;
        }

        @Override
        public <K1, V1> Map<K1, V1> setMap(Map<K1, V1> map, int initCapacity) {
            map = new HashMap<K1, V1>(initCapacity);
            return map;
        }
    }
}

