/*
 * Decompiled with CFR 0.152.
 */
package edu.stanford.nlp.util;

import edu.stanford.nlp.stats.Counter;
import edu.stanford.nlp.util.EquivalenceClassEval;
import edu.stanford.nlp.util.EquivalenceClasser;
import edu.stanford.nlp.util.Pair;
import edu.stanford.nlp.util.Sets;
import java.io.PrintWriter;
import java.text.NumberFormat;
import java.util.AbstractCollection;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class EquivalenceClassEval {
    private boolean bagEval = false;
    public static final EquivalenceClasser NULL_EQUIVALENCE_CLASSER = new EquivalenceClasser(){

        public Object equivalenceClass(Object o) {
            return null;
        }
    };
    private boolean verbose = false;
    EquivalenceClasser eq;
    Eval.CollectionContainsChecker checker;
    String summaryName;
    Counter guessed = new Counter();
    Counter guessedCorrect = new Counter();
    Counter gold = new Counter();
    Counter goldCorrect = new Counter();
    private Counter lastPrecision = new Counter();
    private Counter lastRecall = new Counter();
    private Counter lastF1 = new Counter();
    private Counter previousGuessed;
    private Counter previousGuessedCorrect;
    private Counter previousGold;
    private Counter previousGoldCorrect;
    private static NumberFormat numberFormat = NumberFormat.getNumberInstance();
    public static final EqualityChecker DEFAULT_CHECKER = new EqualityChecker(){

        public boolean areEqual(Object o1, Object o2) {
            return o1.equals(o2);
        }
    };

    public void setBagEval(boolean bagEval) {
        this.bagEval = bagEval;
    }

    public EquivalenceClassEval() {
        this(NULL_EQUIVALENCE_CLASSER);
    }

    public EquivalenceClassEval(EquivalenceClasser eq) {
        this(eq, "");
    }

    public EquivalenceClassEval(EqualityChecker e) {
        this(NULL_EQUIVALENCE_CLASSER, e);
    }

    public EquivalenceClassEval(EquivalenceClasser eq, String name) {
        this(eq, DEFAULT_CHECKER, name);
    }

    public EquivalenceClassEval(EquivalenceClasser eq, EqualityChecker e) {
        this(eq, e, "");
    }

    public EquivalenceClassEval(EquivalenceClasser eq, EqualityChecker e, String summaryName) {
        this(eq, new Eval.CollectionContainsChecker(e), summaryName);
    }

    EquivalenceClassEval(EquivalenceClasser eq, Eval.CollectionContainsChecker checker, String summaryName) {
        numberFormat.setMaximumFractionDigits(4);
        numberFormat.setMinimumFractionDigits(4);
        numberFormat.setMinimumIntegerDigits(1);
        numberFormat.setMaximumIntegerDigits(1);
        this.eq = eq;
        this.checker = checker;
        this.summaryName = summaryName;
    }

    public void eval(Collection guesses, Collection golds) {
        this.eval(guesses, golds, new PrintWriter(System.out, true));
    }

    public void eval(Collection guesses, Collection golds, PrintWriter pw) {
        if (this.verbose) {
            System.out.println("evaluating precision...");
        }
        Pair precision = this.evalPrecision(guesses, golds);
        this.previousGuessed = (Counter)precision.first();
        this.guessed.addAll(this.previousGuessed);
        this.previousGuessedCorrect = (Counter)precision.second();
        this.guessedCorrect.addAll(this.previousGuessedCorrect);
        if (this.verbose) {
            System.out.println("evaluating recall...");
        }
        Pair recall = this.evalPrecision(golds, guesses);
        this.previousGold = (Counter)recall.first();
        this.gold.addAll(this.previousGold);
        this.previousGoldCorrect = (Counter)recall.second();
        this.goldCorrect.addAll(this.previousGoldCorrect);
    }

    Pair evalPrecision(Collection guesses, Collection golds) {
        AbstractCollection internalGuesses = null;
        AbstractCollection internalGolds = null;
        if (this.bagEval) {
            internalGuesses = new ArrayList(guesses.size());
            internalGolds = new ArrayList(golds.size());
        } else {
            internalGuesses = new HashSet(guesses.size());
            internalGolds = new HashSet(golds.size());
        }
        internalGuesses.addAll(guesses);
        internalGolds.addAll(golds);
        Counter<Object> thisGuessed = new Counter<Object>();
        Counter<Object> thisCorrect = new Counter<Object>();
        for (Object o : internalGuesses) {
            Object equivalenceClass = this.eq.equivalenceClass(o);
            thisGuessed.incrementCount(equivalenceClass);
            if (this.checker.contained(o, internalGolds)) {
                thisCorrect.incrementCount(equivalenceClass);
                EquivalenceClassEval.removeItem(o, internalGolds, this.checker);
                continue;
            }
            if (!this.verbose) continue;
            System.out.println("Eval missed " + o);
        }
        return new Pair(thisGuessed, thisCorrect);
    }

    private static void removeItem(Object o, Collection c, Eval.CollectionContainsChecker checker) {
        for (Object o1 : c) {
            if (!checker.contained(o, Collections.singleton(o1))) continue;
            c.remove(o1);
            return;
        }
    }

    public void display() {
        this.display(new PrintWriter(System.out, true));
    }

    public void display(PrintWriter pw) {
        pw.println("*********Final " + this.summaryName + " eval stats by antecedent category***********");
        HashSet keys = new HashSet();
        keys.addAll(this.guessed.keySet());
        keys.addAll(this.gold.keySet());
        this.displayHelper(keys, pw, this.guessed, this.guessedCorrect, this.gold, this.goldCorrect);
        pw.println("Finished final " + this.summaryName + " eval stats.");
    }

    public void displayLast() {
        this.displayLast(new PrintWriter(System.out, true));
    }

    public void displayLast(PrintWriter pw) {
        HashSet keys = new HashSet();
        keys.addAll(this.previousGuessed.keySet());
        keys.addAll(this.previousGold.keySet());
        this.displayHelper(keys, pw, this.previousGuessed, this.previousGuessedCorrect, this.previousGold, this.previousGoldCorrect);
    }

    public double precision(Object key) {
        return this.percentage(key, this.guessed, this.guessedCorrect);
    }

    public double recall(Object key) {
        return this.percentage(key, this.gold, this.goldCorrect);
    }

    public double lastPrecision(Object key) {
        return this.percentage(key, this.previousGuessed, this.previousGuessedCorrect);
    }

    public Counter lastPrecision() {
        Counter result = new Counter();
        result.addAll(this.previousGuessedCorrect);
        result.divideBy(this.previousGuessed);
        return result;
    }

    public double lastRecall(Object key) {
        return this.percentage(key, this.previousGold, this.previousGoldCorrect);
    }

    public Counter lastRecall() {
        Counter result = new Counter();
        result.addAll(this.previousGoldCorrect);
        result.divideBy(this.previousGold);
        return result;
    }

    public double lastNumGuessed(Object key) {
        return this.previousGuessed.getCount(key);
    }

    public Counter lastNumGuessed() {
        return this.previousGuessed;
    }

    public Counter lastNumGuessedCorrect() {
        return this.previousGuessedCorrect;
    }

    public double lastNumGolds(Object key) {
        return this.previousGold.getCount(key);
    }

    public Counter lastNumGolds() {
        return this.previousGold;
    }

    public Counter lastNumGoldsCorrect() {
        return this.previousGoldCorrect;
    }

    public double f1(Object key) {
        return EquivalenceClassEval.f1(this.precision(key), this.recall(key));
    }

    public double lastF1(Object key) {
        return EquivalenceClassEval.f1(this.lastPrecision(key), this.lastRecall(key));
    }

    public Counter lastF1() {
        Counter result = new Counter();
        Set keys = Sets.union(this.previousGuessed.keySet(), this.previousGold.keySet());
        for (Object key : keys) {
            result.setCount(key, this.lastF1(key));
        }
        return result;
    }

    public static double f1(double precision, double recall) {
        return precision == 0.0 || recall == 0.0 ? 0.0 : 2.0 * precision * recall / (precision + recall);
    }

    public static Counter f1(Counter precision, Counter recall) {
        Counter result = new Counter();
        for (Object key : Sets.intersection(precision.keySet(), recall.keySet())) {
            result.setCount(key, EquivalenceClassEval.f1(precision.getCount(key), recall.getCount(key)));
        }
        return result;
    }

    private double percentage(Object key, Counter guessed, Counter guessedCorrect) {
        double thisGuessed = guessed.getCount(key);
        double thisGuessedCorrect = guessedCorrect.getCount(key);
        return thisGuessed == 0.0 ? 0.0 : thisGuessedCorrect / thisGuessed;
    }

    private void displayHelper(Set keys, PrintWriter pw, Counter guessed, Counter guessedCorrect, Counter gold, Counter goldCorrect) {
        Map pads = EquivalenceClassEval.getPads(keys);
        for (Object key : keys) {
            double thisGuessed = guessed.getCount(key);
            double thisGuessedCorrect = guessedCorrect.getCount(key);
            double precision = thisGuessed == 0.0 ? 0.0 : thisGuessedCorrect / thisGuessed;
            this.lastPrecision.setCount(key, precision);
            double thisGold = gold.getCount(key);
            double thisGoldCorrect = goldCorrect.getCount(key);
            double recall = thisGold == 0.0 ? 0.0 : thisGoldCorrect / thisGold;
            this.lastRecall.setCount(key, recall);
            double f1 = EquivalenceClassEval.f1(precision, recall);
            this.lastF1.setCount(key, f1);
            String pad = (String)pads.get(key);
            pw.println(key + pad + "\t" + "P: " + EquivalenceClassEval.formatNumber(precision) + "\ton " + EquivalenceClassEval.formatCount(thisGuessed) + " objects\tR: " + EquivalenceClassEval.formatNumber(recall) + "\ton " + EquivalenceClassEval.formatCount(thisGold) + " objects\tF1: " + EquivalenceClassEval.formatNumber(f1));
        }
    }

    private static String formatNumber(double d) {
        return numberFormat.format(d);
    }

    private static int formatCount(double d) {
        return (int)Math.round(d);
    }

    private static Map getPads(Set keys) {
        String keyString;
        HashMap pads = new HashMap();
        int max = 0;
        for (Object key : keys) {
            keyString = key == null ? "null" : key.toString();
            if (keyString.length() <= max) continue;
            max = keyString.length();
        }
        for (Object key : keys) {
            keyString = key == null ? "null" : key.toString();
            int diff = max - keyString.length();
            String pad = "";
            for (int j = 0; j < diff; ++j) {
                pad = pad + " ";
            }
            pads.put(key, pad);
        }
        return pads;
    }

    public static void main(String[] args) {
        final Pattern p = Pattern.compile("^([^:]*):(.*)$");
        List<String> guesses = Arrays.asList("S:a", "S:b", "VP:c", "VP:d", "S:a");
        List<String> golds = Arrays.asList("S:a", "S:b", "S:b", "VP:d", "VP:a");
        EqualityChecker e = new EqualityChecker(){

            public boolean areEqual(Object o1, Object o2) {
                Matcher m1 = p.matcher((String)o1);
                m1.find();
                String s1 = m1.group(2);
                System.out.println(s1);
                Matcher m2 = p.matcher((String)o2);
                m2.find();
                String s2 = m2.group(2);
                System.out.println(s2);
                return s1.equals(s2);
            }
        };
        EquivalenceClasser eq = new EquivalenceClasser(){

            public Object equivalenceClass(Object o) {
                Matcher m = p.matcher((String)o);
                m.find();
                return m.group(1);
            }
        };
        EquivalenceClassEval eval = new EquivalenceClassEval(eq, e, "testing");
        eval.setBagEval(false);
        eval.eval(guesses, golds);
        eval.displayLast();
        eval.display();
    }

    public Factory factory() {
        return new Factory(){
            boolean bagEval1;
            EquivalenceClasser eq1;
            Eval.CollectionContainsChecker checker1;
            String summaryName1;
            {
                this.bagEval1 = EquivalenceClassEval.this.bagEval;
                this.eq1 = EquivalenceClassEval.this.eq;
                this.checker1 = EquivalenceClassEval.this.checker;
                this.summaryName1 = EquivalenceClassEval.this.summaryName;
            }

            public EquivalenceClassEval equivalenceClassEval() {
                EquivalenceClassEval e = new EquivalenceClassEval(this.eq1, this.checker1, this.summaryName1);
                e.setBagEval(this.bagEval1);
                return e;
            }
        };
    }

    static /* synthetic */ void access$000(Object x0, Collection x1, Eval.CollectionContainsChecker x2) {
        EquivalenceClassEval.removeItem(x0, x1, x2);
    }

    public static interface Factory {
        public EquivalenceClassEval equivalenceClassEval();
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static interface EqualityChecker<T> {
        public boolean areEqual(T var1, T var2);
    }
}

