/*
 * Decompiled with CFR 0.152.
 */
package edu.stanford.nlp.trees.tregex;

import edu.stanford.nlp.ling.StringLabelFactory;
import edu.stanford.nlp.trees.DiskTreebank;
import edu.stanford.nlp.trees.LabeledScoredTreeFactory;
import edu.stanford.nlp.trees.MemoryTreebank;
import edu.stanford.nlp.trees.PennTreeReader;
import edu.stanford.nlp.trees.Tree;
import edu.stanford.nlp.trees.TreeNormalizer;
import edu.stanford.nlp.trees.TreeReader;
import edu.stanford.nlp.trees.TreeReaderFactory;
import edu.stanford.nlp.trees.TreeVisitor;
import edu.stanford.nlp.trees.Treebank;
import edu.stanford.nlp.trees.tregex.TreePattern;
import edu.stanford.nlp.trees.tregex.TreePatternIterator;
import edu.stanford.nlp.util.Timing;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.Reader;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;

public class TreeMatcher {
    Tree root;
    TreePattern rootPattern;
    TreePatternIterator i;
    TreePattern currentPatternNode;
    List stack;
    Iterator currentTreeIterator;
    static Treebank treebank;

    TreeMatcher(Tree t, TreePattern p) {
        this.root = t;
        this.rootPattern = p;
        this.reset();
    }

    public boolean matches(Tree t) {
        this.reset();
        if (!this.rootPattern.descriptionPattern.matcher(t.label().value()).matches()) {
            return false;
        }
        while (this.find()) {
            if (t != this.getMatch()) continue;
            return true;
        }
        return false;
    }

    public TreeMatcher reset() {
        this.i = this.rootPattern.iterator();
        this.currentPatternNode = this.i.next();
        this.stack = new ArrayList(this.rootPattern.size());
        this.currentTreeIterator = this.root.iterator();
        return this;
    }

    public boolean find() {
        while (true) {
            boolean descriptionMatchesNode;
            if (!this.currentTreeIterator.hasNext()) {
                this.i.previous();
                while (!this.currentTreeIterator.hasNext()) {
                    if (!this.i.hasPrevious()) {
                        return false;
                    }
                    this.currentPatternNode = this.i.previous();
                    this.currentTreeIterator = (Iterator)this.stack.remove(this.stack.size() - 1);
                    if (!Verbose.verbose) continue;
                    System.out.println("###Stack: " + this.stack);
                }
                this.i.next();
            }
            Tree t = (Tree)this.currentTreeIterator.next();
            if (Verbose.verbose) {
                System.out.println("###" + t + "\t" + this.currentPatternNode.relation + "(" + (this.currentPatternNode.parent == null ? "--" : this.currentPatternNode.parent.description) + "," + this.currentPatternNode.description + ")");
            }
            if ((!(descriptionMatchesNode = this.currentPatternNode.descriptionPattern.matcher(t.label().value()).matches()) || this.currentPatternNode.negatedDescription) && (!this.currentPatternNode.negatedDescription || descriptionMatchesNode) || this.currentPatternNode.parent != null && !this.currentPatternNode.relation.satisfies(this.currentPatternNode.parent.node(), t, this.root)) continue;
            if (Verbose.verbose) {
                System.out.println("###matched node description " + this.currentPatternNode.descriptionPattern.pattern() + " at node " + t);
            }
            this.currentPatternNode.namesToNodes.put(this.currentPatternNode.name, t);
            if (!this.i.hasNext()) {
                return true;
            }
            this.currentPatternNode = this.i.next();
            this.stack.add(this.currentTreeIterator);
            if (Verbose.verbose) {
                System.out.println("###Stack: " + this.stack);
                System.out.println("Last iterator at: " + t);
            }
            this.currentTreeIterator = this.currentPatternNode.relation.searchNodeIterator(this.currentPatternNode.parent.node(), this.root);
        }
    }

    public Tree getMatch() {
        return this.rootPattern.node();
    }

    public Tree getNode(Object name) {
        if (Verbose.verbose) {
            System.out.println("###Here's the names to nodes map:\n" + this.rootPattern.namesToNodes);
        }
        return (Tree)this.rootPattern.namesToNodes.get(name);
    }

    public static void main(String[] args) {
        int i;
        Timing.startTime();
        if (args.length < 2) {
            System.err.println("Usage: java edu.stanford.nlp.trees.tregex.TreeMatcher [-T] [-C] [-w] [-f] pattern [handle] filepath");
            System.exit(0);
        }
        String tnClass = null;
        for (i = 0; i < args.length && args[i].charAt(0) == '-'; ++i) {
            if (args[i].equals("-T")) {
                Verbose.printTree = true;
                continue;
            }
            if (args[i].equals("-C")) {
                Verbose.printMatches = false;
                continue;
            }
            if (args[i].equals("-w")) {
                Verbose.printWholeTree = true;
                continue;
            }
            if (args[i].equals("-f")) {
                Verbose.printFilename = true;
                continue;
            }
            if (args[i].equals("-tn") && i + 1 < args.length) {
                tnClass = args[++i];
                continue;
            }
            System.err.println("Unknown flag: " + args[i]);
        }
        try {
            TreePattern p = TreePattern.compile(args[i++]);
            System.err.println("Parsed pattern: " + p.pattern());
            int j = i + 1;
            if (j >= args.length) {
                --j;
            }
            if (j < args.length) {
                System.err.println("Reading trees from file(s) " + args[j]);
                TreeNormalizer tn = null;
                if (tnClass != null) {
                    try {
                        tn = (TreeNormalizer)Class.forName(tnClass).newInstance();
                    }
                    catch (Exception e) {
                        // empty catch block
                    }
                }
                TRegexTreeReaderFactory trf = tn == null ? new TRegexTreeReaderFactory() : new TRegexTreeReaderFactory(tn);
                treebank = new DiskTreebank(trf);
                treebank.loadPath(args[j], null, true);
            } else {
                System.err.println("Using default tree");
                Tree t = Tree.valueOf("(VP (VP (VBZ Try) (NP (NP (DT this) (NN wine)) (CC and) (NP (DT these) (NNS snails)))) (PUNCT .))");
                treebank = new MemoryTreebank();
                treebank.add(t);
            }
            String label = null;
            if (j != i) {
                label = args[i];
            }
            TRegexTreeVisitor vis = new TRegexTreeVisitor(p, label);
            treebank.apply(vis);
            Timing.endTime();
            System.err.println("There were " + vis.numMatches() + " matches in total.");
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    static class Verbose {
        static boolean verbose = false;
        static boolean printTree = false;
        static boolean printWholeTree = false;
        static boolean printMatches = true;
        static boolean printFilename = false;

        Verbose() {
        }
    }

    public static class TRegexTreeReaderFactory
    implements TreeReaderFactory {
        private TreeNormalizer tn;

        public TRegexTreeReaderFactory() {
            this(new TreeNormalizer(){

                public String normalizeNonterminal(String str) {
                    if (str == null) {
                        return "";
                    }
                    return str;
                }
            });
        }

        public TRegexTreeReaderFactory(TreeNormalizer tn) {
            this.tn = tn;
        }

        public TreeReader newTreeReader(Reader in) {
            return new PennTreeReader(new BufferedReader(in), new LabeledScoredTreeFactory(new StringLabelFactory()), this.tn);
        }
    }

    static class TRegexTreeVisitor
    implements TreeVisitor {
        TreePattern p;
        String node;
        int numMatches;

        TRegexTreeVisitor(TreePattern p, String node) {
            this.p = p;
            this.node = node;
        }

        public void visitTree(Tree t) {
            if (Verbose.printTree) {
                System.out.println("Next tree read:");
                t.pennPrint();
            }
            TreeMatcher match = this.p.matcher(t);
            while (match.find()) {
                ++this.numMatches;
                if (Verbose.printFilename && treebank instanceof DiskTreebank) {
                    DiskTreebank dtb = (DiskTreebank)treebank;
                    System.out.print("# ");
                    System.out.println(dtb.getCurrentFile());
                }
                if (!Verbose.printMatches) continue;
                if (Verbose.printTree) {
                    System.out.println("Found a full match:");
                }
                if (Verbose.printWholeTree) {
                    t.pennPrint();
                } else if (this.node != null) {
                    if (Verbose.printTree) {
                        System.out.println("Here's the node you were interested in:");
                    }
                    match.getNode(this.node).pennPrint();
                } else {
                    match.getMatch().pennPrint();
                }
                System.out.println();
            }
        }

        public int numMatches() {
            return this.numMatches;
        }
    }
}

