/*
 * Decompiled with CFR 0.152.
 */
package edu.stanford.nlp.tagger.maxent;

import edu.stanford.nlp.tagger.maxent.GlobalHolder;
import edu.stanford.nlp.tagger.maxent.History;
import edu.stanford.nlp.tagger.maxent.PairsHolder;
import edu.stanford.nlp.tagger.maxent.TaggerFeature;
import edu.stanford.nlp.tagger.maxent.TestSentence;
import java.io.Serializable;

public class Extractor
implements Serializable {
    static final String zeroSt = "0";
    private int position;
    boolean isTag;
    private static final long serialVersionUID = -4694133872973560083L;

    public Extractor() {
    }

    public boolean Precondition(String tag) {
        return true;
    }

    public int leftContext() {
        if (this.isTag && this.position < 0) {
            return -this.position;
        }
        return 0;
    }

    public int rightContext() {
        if (this.isTag && this.position > 0) {
            return this.position;
        }
        return 0;
    }

    public boolean isPopulated(TaggerFeature f) {
        return f.indexedValues.length > GlobalHolder.threshold;
    }

    public Extractor(int position, boolean isTag) {
        this.position = position;
        this.isTag = isTag;
    }

    String extract(History h) {
        return this.extract(h, GlobalHolder.pairs);
    }

    String extractLV(History h) {
        int start = h.start;
        String lastverb = TestSentence.toSt("NA");
        int current = h.current;
        int index = current - 1;
        while (index >= start) {
            String tag = GlobalHolder.pairs.get(index, true);
            if (tag.startsWith("VB")) {
                lastverb = GlobalHolder.pairs.get(index, false);
                break;
            }
            if (tag.startsWith(",")) break;
            --index;
        }
        return lastverb;
    }

    String extract(History h, PairsHolder pH) {
        String s = pH.get(h, this.position, this.isTag);
        return s;
    }

    String extract(History h, int bound) {
        return this.extract(h);
    }

    public String toString() {
        String cl = this.getClass().getName();
        int ind = cl.lastIndexOf(".");
        return String.valueOf(cl.substring(ind + 1)) + "(" + this.position + "," + (this.isTag ? "tag" : "word") + ")";
    }
}

