/*
 * Decompiled with CFR 0.152.
 */
package edu.stanford.nlp.tagger.maxent;

import edu.stanford.nlp.io.InDataStreamFile;
import edu.stanford.nlp.io.OutDataStreamFile;
import edu.stanford.nlp.tagger.maxent.CountWrapper;
import edu.stanford.nlp.tagger.maxent.GlobalHolder;
import edu.stanford.nlp.tagger.maxent.TagCount;
import edu.stanford.nlp.tagger.maxent.TestSentence;
import java.util.HashMap;

public class Dictionary {
    HashMap dict = new HashMap();
    private HashMap partTakingVerbs = new HashMap();
    static String naWord = TestSentence.toSt("NA");

    public HashMap getDict() {
        return this.dict;
    }

    public void add(String word, String tag) {
        if (this.dict.containsKey(word)) {
            TagCount cT = (TagCount)this.dict.get(word);
            cT.add(tag);
            return;
        }
        TagCount cT = new TagCount();
        cT.add(tag);
        this.dict.put(word, cT);
    }

    public void release() {
        this.dict.clear();
    }

    public void addVPTaking(String verb, String tag, String partWord) {
        int h = verb.hashCode();
        Integer i = new Integer(h);
        if (tag.startsWith("RP")) {
            if (this.partTakingVerbs.containsKey(i)) {
                ((CountWrapper)this.partTakingVerbs.get(i)).incPart(partWord);
            } else {
                this.partTakingVerbs.put(i, new CountWrapper(verb, 0, 0, 0, 0));
                ((CountWrapper)this.partTakingVerbs.get(i)).incPart(partWord);
            }
        }
        if (tag.startsWith("RB")) {
            if (this.partTakingVerbs.containsKey(i)) {
                ((CountWrapper)this.partTakingVerbs.get(i)).incRB(partWord);
            } else {
                this.partTakingVerbs.put(i, new CountWrapper(verb, 0, 0, 0, 0));
                ((CountWrapper)this.partTakingVerbs.get(i)).incRB(partWord);
            }
        }
        if (tag.startsWith("IN")) {
            if (this.partTakingVerbs.containsKey(i)) {
                ((CountWrapper)this.partTakingVerbs.get(i)).incIn(partWord);
            } else {
                this.partTakingVerbs.put(i, new CountWrapper(verb, 0, 0, 0, 0));
                ((CountWrapper)this.partTakingVerbs.get(i)).incIn(partWord);
            }
        }
    }

    public void addVThatTaking(String verb) {
        int h = verb.hashCode();
        Integer i = new Integer(h);
        if (this.partTakingVerbs.containsKey(i)) {
            ((CountWrapper)this.partTakingVerbs.get(i)).incThat();
        } else {
            this.partTakingVerbs.put(i, new CountWrapper(verb, 0, 1, 0, 0));
        }
    }

    public int getCountPart(String verb) {
        int h = verb.hashCode();
        Integer i = new Integer(h);
        if (this.partTakingVerbs.containsKey(i)) {
            return ((CountWrapper)this.partTakingVerbs.get(i)).getCountPart();
        }
        return 0;
    }

    public int getCountThat(String verb) {
        int h = verb.hashCode();
        Integer i = new Integer(h);
        if (this.partTakingVerbs.containsKey(i)) {
            return ((CountWrapper)this.partTakingVerbs.get(i)).getCountThat();
        }
        return 0;
    }

    public int getCountIn(String verb) {
        int h = verb.hashCode();
        Integer i = new Integer(h);
        if (this.partTakingVerbs.containsKey(i)) {
            return ((CountWrapper)this.partTakingVerbs.get(i)).getCountIn();
        }
        return 0;
    }

    public int getCountRB(String verb) {
        int h = verb.hashCode();
        Integer i = new Integer(h);
        if (this.partTakingVerbs.containsKey(i)) {
            return ((CountWrapper)this.partTakingVerbs.get(i)).getCountRB();
        }
        return 0;
    }

    public int getCount(String word, String tag) {
        TagCount tc = (TagCount)this.dict.get(word);
        if (tc == null) {
            return 0;
        }
        return tc.get(tag);
    }

    public String[] getTags(String word) {
        TagCount tC = this.get(word);
        if (tC == null) {
            return null;
        }
        return tC.getTags();
    }

    public TagCount get(String word) {
        return (TagCount)this.dict.get(word);
    }

    public boolean known(String word) {
        return this.dict.containsKey(word);
    }

    public String getFirstTag(String word) {
        if (this.dict.containsKey(word)) {
            return ((TagCount)this.dict.get(word)).getFirstTag();
        }
        return null;
    }

    public int sum(String word) {
        if (this.dict.containsKey(word)) {
            return ((TagCount)this.dict.get(word)).sum();
        }
        return 0;
    }

    public void save(String filename) {
        Object[] arr = this.dict.keySet().toArray();
        try {
            OutDataStreamFile rf = new OutDataStreamFile(filename);
            rf.writeInt(arr.length);
            System.err.println("Saving dictionary ... words are " + arr.length);
            int i = 0;
            while (i < arr.length) {
                String word = (String)arr[i];
                TagCount tC = this.get(word);
                rf.writeUTF(word);
                tC.save(rf);
                ++i;
            }
            Object[] arrverbs = this.partTakingVerbs.keySet().toArray();
            rf.writeInt(arrverbs.length);
            int i2 = 0;
            while (i2 < arrverbs.length) {
                Integer iO = (Integer)arrverbs[i2];
                CountWrapper tC = (CountWrapper)this.partTakingVerbs.get(iO);
                rf.writeInt(iO);
                tC.save(rf);
                ++i2;
            }
            rf.close();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public void read(InDataStreamFile rf) {
        try {
            int len = rf.readInt();
            if (TestSentence.VERBOSE) {
                System.err.println("Reading dictionary of " + len + " words.");
            }
            int i = 0;
            while (i < len) {
                String word = rf.readUTF();
                TagCount tC = new TagCount();
                tC.read(rf);
                this.dict.put(word, tC);
                if (TestSentence.VERBOSE) {
                    System.err.println("Read " + word + ": " + tC);
                }
                ++i;
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public void read(String filename) {
        try {
            if (TestSentence.VERBOSE) {
                System.err.println("Reading Dictionary from " + filename);
            }
            InDataStreamFile rf = new InDataStreamFile(filename);
            this.read(rf);
            int len1 = rf.readInt();
            int i = 0;
            while (i < len1) {
                int code = rf.readInt();
                Integer iO = new Integer(code);
                CountWrapper tC = new CountWrapper();
                tC.read(rf);
                this.partTakingVerbs.put(iO, tC);
                ++i;
            }
            rf.close();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public void printAmbiguous() {
        Object[] arr = this.dict.keySet().toArray();
        int countAmbiguous = 0;
        int countUnAmbiguous = 0;
        int countAmbDisamb = 0;
        try {
            int i = 0;
            while (i < arr.length) {
                String word = (String)arr[i];
                if (word.indexOf("|") != -1) {
                    TagCount tC = this.get(word);
                    if (tC.numTags() > 1) {
                        System.out.print(word);
                        ++countAmbiguous;
                        tC.print();
                        System.out.println();
                    } else {
                        String wordA = word.substring(0, word.indexOf("|"));
                        if (this.get(wordA).numTags() > 1) {
                            System.out.print(word);
                            ++countAmbDisamb;
                            ++countUnAmbiguous;
                            tC.print();
                            System.out.println();
                        } else {
                            ++countUnAmbiguous;
                        }
                    }
                }
                ++i;
            }
            System.out.println(" ambg " + countAmbiguous + " unambg " + countUnAmbiguous + " disamb " + countAmbDisamb);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public void setAmbClasses() {
        Object[] arr = this.dict.keySet().toArray();
        int i = 0;
        while (i < arr.length) {
            String w = (String)arr[i];
            int ambClassId = GlobalHolder.ambClasses.getClass(w);
            ((TagCount)this.dict.get(w)).setAmbClassId(ambClassId);
            ++i;
        }
    }

    public int getAmbClass(String word) {
        if (word.equals(naWord)) {
            return -2;
        }
        if (this.get(word) == null) {
            return -1;
        }
        return this.get(word).getAmbClassId();
    }

    public static void main(String[] args) {
        String s = new String("word");
        String tag = new String("tag");
        Dictionary d = new Dictionary();
        System.out.println(d.getCount(s, tag));
        System.out.println(d.getFirstTag(s));
    }
}

