/*
 * Decompiled with CFR 0.152.
 */
package edu.stanford.nlp.tagger.maxent;

import edu.stanford.nlp.io.InDataStreamFile;
import edu.stanford.nlp.io.OutDataStreamFile;
import edu.stanford.nlp.tagger.maxent.Dictionary;
import edu.stanford.nlp.tagger.maxent.TestSentence;

public class CountWrapper {
    private String word;
    private int countPart;
    private int countThat;
    private int countIn;
    private int countRB;
    private Dictionary dictLocal = new Dictionary();
    static String rpTag = TestSentence.toSt("RP");
    static String inTag = TestSentence.toSt("IN");
    static String rbTag = TestSentence.toSt("RB");

    public CountWrapper() {
    }

    public CountWrapper(String word, int countPart, int countThat, int countIn, int countRB) {
        this.word = word;
        this.countPart = countPart;
        this.countThat = countThat;
        this.countIn = countIn;
        this.countRB = countRB;
    }

    public void incPart() {
        ++this.countPart;
    }

    public void incPart(String wordPart) {
        ++this.countPart;
        this.dictLocal.add(wordPart, rpTag);
    }

    public void incThat() {
        ++this.countThat;
    }

    public void incIn(String wordPart) {
        ++this.countIn;
        this.dictLocal.add(wordPart, inTag);
    }

    public void incRB(String wordPart) {
        ++this.countRB;
        this.dictLocal.add(wordPart, rbTag);
    }

    public int getCountPart() {
        return this.countPart;
    }

    public int getCountPart(String partWord) {
        return this.dictLocal.getCount(partWord, rpTag);
    }

    public int getCountThat() {
        return this.countThat;
    }

    public int getCountIn() {
        return this.countIn;
    }

    public int getCountIn(String wordPart) {
        return this.dictLocal.getCount(wordPart, inTag);
    }

    public int getCountRB() {
        return this.countRB;
    }

    public int getCountRB(String wordPart) {
        return this.dictLocal.getCount(wordPart, rbTag);
    }

    public void print() {
        System.out.println(String.valueOf(this.word) + " " + this.countPart + " " + this.countThat);
    }

    public String getWord() {
        return this.word;
    }

    public int hashCode() {
        return this.word.hashCode();
    }

    public void save(OutDataStreamFile rf) {
        try {
            rf.writeInt(this.word.length());
            rf.write(this.word.getBytes());
            rf.writeInt(this.countPart);
            rf.writeInt(this.countThat);
            rf.writeInt(this.countIn);
            rf.writeInt(this.countRB);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public void read(InDataStreamFile rf) {
        try {
            int len = rf.readInt();
            byte[] buff = new byte[len];
            rf.read(buff);
            this.word = new String(buff);
            this.countPart = rf.readInt();
            this.countThat = rf.readInt();
            this.countIn = rf.readInt();
            this.countRB = rf.readInt();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }
}

