/*
 * Decompiled with CFR 0.152.
 */
package edu.stanford.nlp.parser.lexparser;

import edu.stanford.nlp.ling.CategoryWordTag;
import edu.stanford.nlp.ling.StringLabel;
import edu.stanford.nlp.parser.lexparser.Train;
import edu.stanford.nlp.parser.lexparser.TreebankLangParserParams;
import edu.stanford.nlp.stats.Counter;
import edu.stanford.nlp.trees.HeadFinder;
import edu.stanford.nlp.trees.Tree;
import edu.stanford.nlp.trees.TreeFactory;
import edu.stanford.nlp.trees.TreeTransformer;
import java.util.ArrayList;
import java.util.Collections;

class PostSplitter
implements TreeTransformer {
    private Counter<String> nonTerms = new Counter();
    private TreebankLangParserParams tlpParams;
    private TreeFactory tf;
    private HeadFinder hf;

    public Tree transformTree(Tree t) {
        this.tf = t.treeFactory();
        return this.transformTreeHelper(t, t);
    }

    public Tree transformTreeHelper(Tree t, Tree root) {
        String grandParentStr;
        Tree grandParent;
        String parentStr;
        Tree parent;
        if (root == null || t.equals(root)) {
            parent = null;
            parentStr = "";
        } else {
            parent = t.parent(root);
            parentStr = parent.label().value();
        }
        if (parent == null || parent.equals(root)) {
            grandParent = null;
            grandParentStr = "";
        } else {
            grandParent = parent.parent(root);
            grandParentStr = grandParent.label().value();
        }
        String cat = t.label().value();
        String baseParentStr = this.tlpParams.treebankLanguagePack().basicCategory(parentStr);
        String baseGrandParentStr = this.tlpParams.treebankLanguagePack().basicCategory(grandParentStr);
        if (t.isLeaf()) {
            return this.tf.newLeaf(new StringLabel(t.label().value()));
        }
        String word = t.headTerminal(this.hf).value();
        if (t.isPreTerminal()) {
            this.nonTerms.incrementCount(t.label().value());
        } else {
            String cat2;
            this.nonTerms.incrementCount(t.label().value());
            if (Train.postPA && !Train.smoothing && baseParentStr.length() > 0) {
                cat2 = Train.postSplitWithBaseCategory ? cat + "^" + baseParentStr : cat + "^" + parentStr;
                if (!Train.selectivePostSplit || Train.postSplitters.contains(cat2)) {
                    cat = cat2;
                }
            }
            if (Train.postGPA && !Train.smoothing && grandParentStr.length() > 0) {
                cat2 = Train.postSplitWithBaseCategory ? cat + "~" + baseGrandParentStr : cat + "~" + grandParentStr;
                if (Train.selectivePostSplit) {
                    if (cat.indexOf("^") >= 0 && Train.postSplitters.contains(cat2)) {
                        cat = cat2;
                    }
                } else {
                    cat = cat2;
                }
            }
        }
        Tree result = this.tf.newTreeNode(new CategoryWordTag(cat, word, cat), Collections.EMPTY_LIST);
        ArrayList<Tree> newKids = new ArrayList<Tree>();
        Tree[] kids = t.children();
        for (int i = 0; i < kids.length; ++i) {
            newKids.add(this.transformTreeHelper(kids[i], root));
        }
        result.setChildren(newKids);
        return result;
    }

    public void dumpStats() {
        System.out.println("%% Counts of nonterminals:");
        ArrayList<String> biggestCounts = new ArrayList<String>(this.nonTerms.keySet());
        Collections.sort(biggestCounts, this.nonTerms.comparator(false));
        for (String str : biggestCounts) {
            System.out.println(str + ": " + this.nonTerms.getCount(str));
        }
    }

    public PostSplitter(TreebankLangParserParams tlpParams) {
        this.tlpParams = tlpParams;
        this.hf = tlpParams.headFinder();
    }
}

