/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.compare.internal;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.ResourceBundle;
import org.eclipse.compare.ICompareContainer;
import org.eclipse.compare.internal.MergeViewerAction;
import org.eclipse.compare.internal.Utilities;
import org.eclipse.core.commands.operations.IOperationHistory;
import org.eclipse.core.commands.operations.IOperationHistoryListener;
import org.eclipse.core.commands.operations.IUndoContext;
import org.eclipse.core.commands.operations.OperationHistoryEvent;
import org.eclipse.jface.action.GroupMarker;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.action.IContributionItem;
import org.eclipse.jface.action.IMenuListener;
import org.eclipse.jface.action.IMenuManager;
import org.eclipse.jface.action.MenuManager;
import org.eclipse.jface.action.Separator;
import org.eclipse.jface.preference.IPreferenceStore;
import org.eclipse.jface.preference.PreferenceConverter;
import org.eclipse.jface.text.BadLocationException;
import org.eclipse.jface.text.IDocument;
import org.eclipse.jface.text.IRegion;
import org.eclipse.jface.text.ITextListener;
import org.eclipse.jface.text.IUndoManager;
import org.eclipse.jface.text.IUndoManagerExtension;
import org.eclipse.jface.text.Position;
import org.eclipse.jface.text.TextEvent;
import org.eclipse.jface.text.source.CompositeRuler;
import org.eclipse.jface.text.source.ISharedTextColors;
import org.eclipse.jface.text.source.IVerticalRuler;
import org.eclipse.jface.text.source.IVerticalRulerColumn;
import org.eclipse.jface.text.source.LineNumberRulerColumn;
import org.eclipse.jface.text.source.SourceViewer;
import org.eclipse.jface.text.source.SourceViewerConfiguration;
import org.eclipse.jface.util.IPropertyChangeListener;
import org.eclipse.jface.util.PropertyChangeEvent;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.ISelectionProvider;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.swt.custom.StyledText;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Font;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.graphics.RGB;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.editors.text.EditorsUI;
import org.eclipse.ui.texteditor.ChangeEncodingAction;
import org.eclipse.ui.texteditor.FindReplaceAction;

public class MergeSourceViewer
extends SourceViewer
implements ISelectionChangedListener,
ITextListener,
IMenuListener,
IOperationHistoryListener {
    public static final String UNDO_ID = "undo";
    public static final String REDO_ID = "redo";
    public static final String CUT_ID = "cut";
    public static final String COPY_ID = "copy";
    public static final String PASTE_ID = "paste";
    public static final String DELETE_ID = "delete";
    public static final String SELECT_ALL_ID = "selectAll";
    public static final String SAVE_ID = "save";
    public static final String FIND_ID = "find";
    public static final String CHANGE_ENCODING_ID = "changeEncoding";
    private ResourceBundle fResourceBundle;
    private Position fRegion;
    private boolean fEnabled = true;
    private HashMap fActions = new HashMap();
    private IDocument fRememberedDocument;
    private boolean fAddSaveAction = true;
    private boolean isConfigured = false;
    private IPropertyChangeListener fPreferenceChangeListener;
    private boolean fShowLineNumber = false;
    private LineNumberRulerColumn fLineNumberColumn;
    private List textActions = new ArrayList();

    public MergeSourceViewer(Composite parent, int style, ResourceBundle bundle, ICompareContainer container) {
        super(parent, (IVerticalRuler)new CompositeRuler(), style | 0x100 | 0x200);
        IOperationHistory history;
        this.fResourceBundle = bundle;
        MenuManager menu = new MenuManager();
        menu.setRemoveAllWhenShown(true);
        menu.addMenuListener((IMenuListener)this);
        StyledText te = this.getTextWidget();
        te.setMenu(menu.createContextMenu((Control)te));
        container.registerContextMenu(menu, (ISelectionProvider)this);
        this.fPreferenceChangeListener = new IPropertyChangeListener(){

            public void propertyChange(PropertyChangeEvent event) {
                MergeSourceViewer.this.handlePropertyChangeEvent(event);
            }
        };
        EditorsUI.getPreferenceStore().addPropertyChangeListener(this.fPreferenceChangeListener);
        this.fShowLineNumber = EditorsUI.getPreferenceStore().getBoolean("lineNumberRuler");
        if (this.fShowLineNumber) {
            this.updateLineNumberRuler();
        }
        if ((history = this.getHistory()) != null) {
            history.addOperationHistoryListener((IOperationHistoryListener)this);
        }
    }

    public void rememberDocument(IDocument doc) {
        this.fRememberedDocument = doc;
    }

    public IDocument getRememberedDocument() {
        return this.fRememberedDocument;
    }

    public void hideSaveAction() {
        this.fAddSaveAction = false;
    }

    public void setFont(Font font) {
        StyledText te = this.getTextWidget();
        if (te != null) {
            te.setFont(font);
        }
        if (this.fLineNumberColumn != null) {
            this.fLineNumberColumn.setFont(font);
            this.layoutViewer();
        }
    }

    public void setBackgroundColor(Color color) {
        StyledText te = this.getTextWidget();
        if (te != null) {
            te.setBackground(color);
        }
        if (this.fLineNumberColumn != null) {
            this.fLineNumberColumn.setBackground(color);
        }
    }

    public void setEnabled(boolean enabled) {
        if (enabled != this.fEnabled) {
            this.fEnabled = enabled;
            StyledText c = this.getTextWidget();
            if (c != null) {
                c.setEnabled(enabled);
                Display d = c.getDisplay();
                c.setBackground(enabled ? d.getSystemColor(25) : null);
            }
        }
    }

    public boolean getEnabled() {
        return this.fEnabled;
    }

    public void setRegion(Position region) {
        this.fRegion = region;
    }

    public Position getRegion() {
        return this.fRegion;
    }

    public boolean isControlOkToUse() {
        StyledText t = this.getTextWidget();
        return t != null && !t.isDisposed();
    }

    public void setSelection(Position position) {
        if (position != null) {
            this.setSelectedRange(position.getOffset(), position.getLength());
        }
    }

    public void setLineBackground(Position position, Color c) {
        StyledText t = this.getTextWidget();
        if (t != null && !t.isDisposed()) {
            Point region = new Point(0, 0);
            this.getLineRange(position, region);
            region.x -= this.getDocumentRegionOffset();
            try {
                t.setLineBackground(region.x, region.y, c);
            }
            catch (IllegalArgumentException illegalArgumentException) {}
        }
    }

    public void resetLineBackground() {
        StyledText t = this.getTextWidget();
        if (t != null && !t.isDisposed()) {
            int lines = this.getLineCount();
            t.setLineBackground(0, lines, null);
        }
    }

    public int getLineCount() {
        IRegion region = this.getVisibleRegion();
        int length = region.getLength();
        if (length == 0) {
            return 0;
        }
        IDocument doc = this.getDocument();
        int startLine = 0;
        int endLine = 0;
        int start = region.getOffset();
        try {
            startLine = doc.getLineOfOffset(start);
        }
        catch (BadLocationException badLocationException) {}
        try {
            endLine = doc.getLineOfOffset(start + length);
        }
        catch (BadLocationException badLocationException) {}
        return endLine - startLine + 1;
    }

    public int getViewportLines() {
        StyledText te = this.getTextWidget();
        Rectangle clArea = te.getClientArea();
        if (!clArea.isEmpty()) {
            return clArea.height / te.getLineHeight();
        }
        return 0;
    }

    public int getViewportHeight() {
        StyledText te = this.getTextWidget();
        Rectangle clArea = te.getClientArea();
        if (!clArea.isEmpty()) {
            return clArea.height;
        }
        return 0;
    }

    public int getDocumentRegionOffset() {
        int start = this.getVisibleRegion().getOffset();
        IDocument doc = this.getDocument();
        if (doc != null) {
            try {
                return doc.getLineOfOffset(start);
            }
            catch (BadLocationException badLocationException) {}
        }
        return 0;
    }

    public int getVerticalScrollOffset() {
        StyledText st = this.getTextWidget();
        int lineHeight = st.getLineHeight();
        return this.getTopInset() - (this.getDocumentRegionOffset() * lineHeight + st.getTopPixel());
    }

    public Point getLineRange(Position p, Point region) {
        IDocument doc = this.getDocument();
        if (p == null || doc == null) {
            region.x = 0;
            region.y = 0;
            return region;
        }
        int start = p.getOffset();
        int length = p.getLength();
        int startLine = 0;
        try {
            startLine = doc.getLineOfOffset(start);
        }
        catch (BadLocationException badLocationException) {}
        int lineCount = 0;
        if (length != 0) {
            int endLine = 0;
            try {
                endLine = doc.getLineOfOffset(start + length - 1);
            }
            catch (BadLocationException badLocationException) {}
            lineCount = endLine - startLine + 1;
        }
        region.x = startLine;
        region.y = lineCount;
        return region;
    }

    public void vscroll(int line) {
        int srcExtentSize;
        int srcViewSize = this.getLineCount();
        if (srcViewSize > (srcExtentSize = this.getViewportLines())) {
            int cp;
            if (line < 0) {
                line = 0;
            }
            if ((cp = this.getTopIndex()) != line) {
                this.setTopIndex(line + this.getDocumentRegionOffset());
            }
        }
    }

    public void addAction(String actionId, MergeViewerAction action) {
        this.fActions.put(actionId, action);
    }

    public IAction getAction(String actionId) {
        MergeViewerAction mva;
        IAction action = (IAction)this.fActions.get(actionId);
        if (action == null) {
            action = this.createAction(actionId);
            if (action == null) {
                return null;
            }
            if (action instanceof MergeViewerAction) {
                mva = (MergeViewerAction)action;
                if (mva.isContentDependent()) {
                    this.addTextListener(this);
                }
                if (mva.isSelectionDependent()) {
                    this.addSelectionChangedListener(this);
                }
                Utilities.initAction(action, this.fResourceBundle, "action." + actionId + ".");
            }
            this.addAction(actionId, action);
        }
        if (action instanceof MergeViewerAction && (mva = (MergeViewerAction)action).isEditableDependent() && !this.isEditable()) {
            return null;
        }
        return action;
    }

    protected IAction createAction(String actionId) {
        if (UNDO_ID.equals(actionId)) {
            return new TextOperationAction(1, "org.eclipse.ui.edit.undo", true, false, true);
        }
        if (REDO_ID.equals(actionId)) {
            return new TextOperationAction(2, "org.eclipse.ui.edit.redo", true, false, true);
        }
        if (CUT_ID.equals(actionId)) {
            return new TextOperationAction(3, "org.eclipse.ui.edit.cut", true, true, false);
        }
        if (COPY_ID.equals(actionId)) {
            return new TextOperationAction(4, "org.eclipse.ui.edit.copy", false, true, false);
        }
        if (PASTE_ID.equals(actionId)) {
            return new TextOperationAction(5, "org.eclipse.ui.edit.paste", true, false, false);
        }
        if (DELETE_ID.equals(actionId)) {
            return new TextOperationAction(6, "org.eclipse.ui.edit.delete", true, false, false);
        }
        if (SELECT_ALL_ID.equals(actionId)) {
            return new TextOperationAction(7, "org.eclipse.ui.edit.selectAll", false, false, false);
        }
        return null;
    }

    public void selectionChanged(SelectionChangedEvent event) {
        Iterator e = this.fActions.values().iterator();
        while (e.hasNext()) {
            MergeViewerAction action;
            Object next = e.next();
            if (!(next instanceof MergeViewerAction) || !(action = (MergeViewerAction)((Object)next)).isSelectionDependent()) continue;
            action.update();
        }
    }

    public void textChanged(TextEvent event) {
        this.updateContentDependantActions();
    }

    void updateContentDependantActions() {
        Iterator e = this.fActions.values().iterator();
        while (e.hasNext()) {
            MergeViewerAction action;
            Object next = e.next();
            if (!(next instanceof MergeViewerAction) || !(action = (MergeViewerAction)((Object)next)).isContentDependent()) continue;
            action.update();
        }
    }

    public void menuAboutToShow(IMenuManager menu) {
        menu.add((IContributionItem)new Separator(UNDO_ID));
        this.addMenu(menu, UNDO_ID);
        this.addMenu(menu, REDO_ID);
        menu.add((IContributionItem)new GroupMarker(SAVE_ID));
        if (this.fAddSaveAction) {
            this.addMenu(menu, SAVE_ID);
        }
        menu.add((IContributionItem)new Separator("file"));
        menu.add((IContributionItem)new Separator("ccp"));
        this.addMenu(menu, CUT_ID);
        this.addMenu(menu, COPY_ID);
        this.addMenu(menu, PASTE_ID);
        this.addMenu(menu, DELETE_ID);
        this.addMenu(menu, SELECT_ALL_ID);
        menu.add((IContributionItem)new Separator("edit"));
        this.addMenu(menu, CHANGE_ENCODING_ID);
        menu.add((IContributionItem)new Separator(FIND_ID));
        this.addMenu(menu, FIND_ID);
        menu.add((IContributionItem)new Separator("additions"));
        menu.add((IContributionItem)new Separator("text"));
        Iterator iterator = this.textActions.iterator();
        while (iterator.hasNext()) {
            IAction action = (IAction)iterator.next();
            menu.add(action);
        }
        menu.add((IContributionItem)new Separator("rest"));
        this.updateActions();
    }

    private void addMenu(IMenuManager menu, String actionId) {
        IAction action = this.getAction(actionId);
        if (action != null) {
            menu.add(action);
        }
    }

    protected void handleDispose() {
        this.removeTextListener(this);
        this.removeSelectionChangedListener(this);
        EditorsUI.getPreferenceStore().removePropertyChangeListener(this.fPreferenceChangeListener);
        IOperationHistory history = this.getHistory();
        if (history != null) {
            history.removeOperationHistoryListener((IOperationHistoryListener)this);
        }
        super.handleDispose();
    }

    public void updateActions() {
        Iterator e = this.fActions.values().iterator();
        while (e.hasNext()) {
            MergeViewerAction action;
            Object next = e.next();
            if (next instanceof MergeViewerAction) {
                action = (MergeViewerAction)((Object)next);
                action.update();
            }
            if (next instanceof FindReplaceAction) {
                action = (FindReplaceAction)next;
                action.update();
                continue;
            }
            if (!(next instanceof ChangeEncodingAction)) continue;
            action = (ChangeEncodingAction)next;
            action.update();
        }
    }

    public void configure(SourceViewerConfiguration configuration) {
        if (this.isConfigured) {
            this.unconfigure();
        }
        this.isConfigured = true;
        super.configure(configuration);
    }

    public void setBounds(int x, int y, int width, int height) {
        if (this.getControl() instanceof Composite) {
            ((Composite)this.getControl()).setBounds(x, y, width, height);
        } else {
            this.getTextWidget().setBounds(x, y, width, height);
        }
    }

    protected void handlePropertyChangeEvent(PropertyChangeEvent event) {
        String key = event.getProperty();
        if (key.equals("lineNumberRuler")) {
            boolean b = EditorsUI.getPreferenceStore().getBoolean("lineNumberRuler");
            if (b != this.fShowLineNumber) {
                this.toggleLineNumberRuler();
            }
        } else if (key.equals("lineNumberColor")) {
            this.updateLineNumberColumnPresentation(true);
        }
    }

    private void updateLineNumberRuler() {
        IVerticalRuler v = this.getVerticalRuler();
        if (v != null && v instanceof CompositeRuler) {
            CompositeRuler c = (CompositeRuler)v;
            if (!this.fShowLineNumber) {
                if (this.fLineNumberColumn != null) {
                    c.removeDecorator((IVerticalRulerColumn)this.fLineNumberColumn);
                }
            } else {
                if (this.fLineNumberColumn == null) {
                    this.fLineNumberColumn = new LineNumberRulerColumn();
                    this.updateLineNumberColumnPresentation(false);
                }
                c.addDecorator(0, (IVerticalRulerColumn)this.fLineNumberColumn);
            }
        }
    }

    private void updateLineNumberColumnPresentation(boolean refresh) {
        if (this.fLineNumberColumn == null) {
            return;
        }
        RGB rgb = this.getColorFromStore(EditorsUI.getPreferenceStore(), "lineNumberColor");
        if (rgb == null) {
            rgb = new RGB(0, 0, 0);
        }
        ISharedTextColors sharedColors = this.getSharedColors();
        this.fLineNumberColumn.setForeground(sharedColors.getColor(rgb));
        if (refresh) {
            this.fLineNumberColumn.redraw();
        }
    }

    private void layoutViewer() {
        Control parent = this.getControl();
        if (parent instanceof Composite && !parent.isDisposed()) {
            ((Composite)parent).layout(true);
        }
    }

    private ISharedTextColors getSharedColors() {
        return EditorsUI.getSharedTextColors();
    }

    private RGB getColorFromStore(IPreferenceStore store, String key) {
        RGB rgb = null;
        if (store.contains(key)) {
            rgb = store.isDefault(key) ? PreferenceConverter.getDefaultColor((IPreferenceStore)store, (String)key) : PreferenceConverter.getColor((IPreferenceStore)store, (String)key);
        }
        return rgb;
    }

    private void toggleLineNumberRuler() {
        this.fShowLineNumber = !this.fShowLineNumber;
        this.updateLineNumberRuler();
    }

    public void addTextAction(IAction textEditorPropertyAction) {
        this.textActions.add(textEditorPropertyAction);
    }

    public void addAction(String id, IAction action) {
        this.fActions.put(id, action);
    }

    private IOperationHistory getHistory() {
        if (PlatformUI.getWorkbench() == null) {
            return null;
        }
        return PlatformUI.getWorkbench().getOperationSupport().getOperationHistory();
    }

    public void historyNotification(OperationHistoryEvent event) {
        IUndoContext context = this.getUndoContext();
        if (context != null && event.getOperation().hasContext(context)) {
            Display.getDefault().asyncExec(new Runnable(){

                public void run() {
                    MergeSourceViewer.this.updateContentDependantActions();
                }
            });
        }
    }

    private IUndoContext getUndoContext() {
        IUndoManager undoManager = this.getUndoManager();
        if (undoManager instanceof IUndoManagerExtension) {
            return ((IUndoManagerExtension)undoManager).getUndoContext();
        }
        return null;
    }

    class TextOperationAction
    extends MergeViewerAction {
        private int fOperationCode;

        TextOperationAction(int operationCode, boolean mutable, boolean selection, boolean content) {
            this(operationCode, null, mutable, selection, content);
        }

        public TextOperationAction(int operationCode, String actionDefinitionId, boolean mutable, boolean selection, boolean content) {
            super(mutable, selection, content);
            if (actionDefinitionId != null) {
                this.setActionDefinitionId(actionDefinitionId);
            }
            this.fOperationCode = operationCode;
            this.update();
        }

        public void run() {
            if (this.isEnabled()) {
                MergeSourceViewer.this.doOperation(this.fOperationCode);
            }
        }

        public boolean isEnabled() {
            return this.fOperationCode != -1 && MergeSourceViewer.this.canDoOperation(this.fOperationCode);
        }

        public void update() {
            this.setEnabled(this.isEnabled());
        }
    }
}

