/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.equinox.internal.p2.ui.dialogs;

import java.util.ArrayList;
import java.util.List;
import org.eclipse.equinox.internal.provisional.p2.engine.ProvisioningContext;
import org.eclipse.equinox.internal.provisional.p2.metadata.IInstallableUnit;
import org.eclipse.equinox.internal.provisional.p2.ui.ProvUI;
import org.eclipse.equinox.internal.provisional.p2.ui.policy.IQueryProvider;
import org.eclipse.jface.dialogs.Dialog;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.StructuredViewer;
import org.eclipse.swt.graphics.Drawable;
import org.eclipse.swt.graphics.Font;
import org.eclipse.swt.graphics.FontMetrics;
import org.eclipse.swt.graphics.GC;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;

public abstract class StructuredIUGroup {
    private IQueryProvider queryProvider;
    private ProvisioningContext context;
    private FontMetrics fm;
    protected StructuredViewer viewer;
    private Composite composite;
    static /* synthetic */ Class class$0;

    protected StructuredIUGroup(Composite parent, IQueryProvider queryProvider, Font font, ProvisioningContext context) {
        this.queryProvider = queryProvider;
        this.context = context;
        GC gc = new GC((Drawable)parent);
        gc.setFont(font);
        this.fm = gc.getFontMetrics();
        gc.dispose();
    }

    protected void createGroupComposite(Composite parent) {
        this.composite = new Composite(parent, 0);
        GridData gd = new GridData(4, 4, true, true);
        this.composite.setLayoutData((Object)gd);
        GridLayout layout = new GridLayout();
        layout.marginWidth = 0;
        layout.marginHeight = 0;
        this.composite.setLayout((Layout)layout);
        this.viewer = this.createViewer(this.composite);
        GridData data = new GridData(1808);
        data.grabExcessHorizontalSpace = true;
        data.grabExcessVerticalSpace = true;
        this.viewer.getControl().setLayoutData((Object)data);
    }

    protected abstract StructuredViewer createViewer(Composite var1);

    protected Composite getComposite() {
        return this.composite;
    }

    protected Shell getShell() {
        return this.composite.getShell();
    }

    protected StructuredViewer getStructuredViewer() {
        return this.viewer;
    }

    protected IInstallableUnit[] getSelectedIUs() {
        List elements = ((IStructuredSelection)this.viewer.getSelection()).toList();
        ArrayList<IInstallableUnit> iusList = new ArrayList<IInstallableUnit>(elements.size());
        int i = 0;
        while (i < elements.size()) {
            IInstallableUnit iu = this.getIU(elements.get(i));
            if (iu != null) {
                iusList.add(iu);
            }
            ++i;
        }
        return iusList.toArray(new IInstallableUnit[iusList.size()]);
    }

    protected IInstallableUnit getIU(Object element) {
        Class<?> clazz = class$0;
        if (clazz == null) {
            try {
                clazz = class$0 = Class.forName("org.eclipse.equinox.internal.provisional.p2.metadata.IInstallableUnit");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        return (IInstallableUnit)ProvUI.getAdapter(element, clazz);
    }

    protected ProvisioningContext getProvisioningContext() {
        return this.context;
    }

    protected int convertHorizontalDLUsToPixels(int dlus) {
        return Dialog.convertHorizontalDLUsToPixels((FontMetrics)this.fm, (int)dlus);
    }

    protected IQueryProvider getQueryProvider() {
        return this.queryProvider;
    }

    protected Control getDefaultFocusControl() {
        if (this.viewer != null) {
            return this.viewer.getControl();
        }
        return null;
    }
}

