/*
 * Decompiled with CFR 0.152.
 */
package edu.mit.story.ui.widgets;

import edu.mit.story.core.descriptor.IHasDescription;
import edu.mit.story.core.descriptor.IHasName;
import edu.mit.story.core.validation.Message;
import edu.mit.story.ui.widgets.ButtonEnumGroup;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Layout;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class RadioButtonEnumGroup<T extends Enum<T>>
extends ButtonEnumGroup<T> {
    public static final Message selectAValueMessage = new Message("A value must be selected", 3);
    protected T value = null;

    public RadioButtonEnumGroup(Class<T> enumType) {
        super(enumType);
    }

    public T getValue() {
        return this.value;
    }

    public void setValue(T newValue) {
        if (this.value == newValue) {
            return;
        }
        if (this.buttons != null) {
            Button[] buttonArray = this.buttons;
            int n = this.buttons.length;
            int n2 = 0;
            while (n2 < n) {
                Button button;
                button.setSelection(newValue == (button = buttonArray[n2]).getData());
                ++n2;
            }
        }
        this.value = newValue;
        this.outOfSync = true;
        this.notifyChangeListeners();
    }

    @Override
    protected void createButtonGroup(Composite parent) {
        GridLayout layout = new GridLayout();
        layout.horizontalSpacing = this.HORIZONTAL_GAP;
        layout.numColumns = this.numColumns;
        if (this.useGroup) {
            this.buttonGroup = new Group(parent, 0);
            if (this.groupTitle != null) {
                ((Group)this.buttonGroup).setText(this.groupTitle);
            }
        } else {
            this.buttonGroup = new Composite(parent, 0);
            layout.marginWidth = 0;
            layout.marginHeight = 0;
        }
        this.buttonGroup.setLayout((Layout)layout);
        GridData gd = new GridData();
        gd.horizontalAlignment = 4;
        gd.verticalAlignment = 4;
        this.buttonGroup.setLayoutData((Object)gd);
    }

    @Override
    protected void createButtons(Composite parent) {
        Enum[] valArray = (Enum[])this.enumType.getEnumConstants();
        if (valArray == null || valArray.length == 0) {
            throw new IllegalStateException();
        }
        boolean hasName = IHasName.class.isAssignableFrom(this.getEnumType());
        boolean hasDesc = IHasDescription.class.isAssignableFrom(this.getEnumType());
        this.buttons = new Button[valArray.length];
        int i = 0;
        while (i < valArray.length) {
            Button button;
            Enum enumValue = valArray[i];
            this.buttons[i] = button = new Button(parent, 16400);
            String text = hasName ? ((IHasName)enumValue).getName() : enumValue.name();
            button.setText(text);
            if (hasDesc) {
                button.setToolTipText(((IHasDescription)enumValue).getDescription());
            }
            button.setData((Object)enumValue);
            button.setSelection(enumValue == this.value);
            button.addSelectionListener((SelectionListener)new SelectionAdapter(button){
                Button myButton;
                {
                    this.myButton = button;
                }

                public void widgetSelected(SelectionEvent event) {
                    if (!this.myButton.getSelection()) {
                        return;
                    }
                    Enum newValue = (Enum)this.myButton.getData();
                    if (RadioButtonEnumGroup.this.value == newValue) {
                        return;
                    }
                    RadioButtonEnumGroup.this.value = newValue;
                    Button[] buttonArray = RadioButtonEnumGroup.this.buttons;
                    int n = RadioButtonEnumGroup.this.buttons.length;
                    int n2 = 0;
                    while (n2 < n) {
                        Button button = buttonArray[n2];
                        if (button != this.myButton && button.getSelection()) {
                            button.setSelection(false);
                        }
                        ++n2;
                    }
                    RadioButtonEnumGroup.this.notifyChangeListeners();
                    RadioButtonEnumGroup.this.notifySelectionListeners(event);
                }
            });
            ++i;
        }
    }

    @Override
    protected void doValidate() {
        this.message = this.getValue() == null ? selectAValueMessage : Message.NO_MESSAGE;
        this.outOfSync = false;
    }
}

