/*
 * Decompiled with CFR 0.152.
 */
package edu.mit.story.ui.widgets;

import edu.mit.story.core.manager.IHasRepManager;
import edu.mit.story.core.model.change.Change;
import edu.mit.story.core.model.change.Flag;
import edu.mit.story.core.model.change.IFlag;
import edu.mit.story.core.model.change.IModelListener;
import edu.mit.story.core.model.change.StoryChangeEvent;
import edu.mit.story.core.rep.IRep;
import edu.mit.story.core.util.Debug;
import edu.mit.story.ui.StoryUIPlugin;
import edu.mit.story.ui.editor.IStoryEditor;
import edu.mit.story.ui.helpers.IHelperDescriptor;
import edu.mit.story.ui.helpers.IHelperPage;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.SortedMap;
import java.util.TreeMap;
import org.eclipse.core.commands.Command;
import org.eclipse.core.commands.IParameter;
import org.eclipse.core.commands.Parameterization;
import org.eclipse.core.commands.ParameterizedCommand;
import org.eclipse.core.commands.common.NotDefinedException;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.core.runtime.ISafeRunnable;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.ListenerList;
import org.eclipse.core.runtime.Status;
import org.eclipse.jface.action.Action;
import org.eclipse.jface.action.ActionContributionItem;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.action.IContributionItem;
import org.eclipse.jface.action.IMenuCreator;
import org.eclipse.jface.bindings.TriggerSequence;
import org.eclipse.jface.util.SafeRunnable;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.ISelectionProvider;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Menu;
import org.eclipse.ui.IActionBars;
import org.eclipse.ui.PartInitException;
import org.eclipse.ui.SubActionBars;
import org.eclipse.ui.commands.ICommandService;
import org.eclipse.ui.keys.IBindingService;
import org.eclipse.ui.part.IPageSite;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class HelperPageBookWidget<H extends IHelperPage>
extends Composite
implements IModelListener,
ISelectionProvider {
    public static final int PageChanged = 2094818356;
    private final IStoryEditor editor;
    private final IPageSite site;
    private final HelperPageDesc defaultPage;
    private final ListenerList selectionListeners = new ListenerList();
    private SelectHelperDropDownAction selectAction;
    private HelperPageDesc currentPage = null;
    private SortedMap<String, HelperPageDesc> pageMap = new TreeMap<String, HelperPageDesc>();
    private IHasRepManager<H, ? extends IHelperDescriptor<H>> manager;
    private ISelectionProvider provider = null;
    private ISelectionChangedListener selectionListener = new ISelectionChangedListener(){

        public void selectionChanged(SelectionChangedEvent event) {
            HelperPageBookWidget.this.helperPageSelectionChanged(event);
        }
    };

    public HelperPageBookWidget(IStoryEditor editor, IPageSite site, IHasRepManager<H, ? extends IHelperDescriptor<H>> manager, Composite parent, int style) {
        super(parent, style);
        if (editor == null) {
            throw new NullPointerException();
        }
        if (site == null) {
            throw new NullPointerException();
        }
        if (manager == null) {
            throw new NullPointerException();
        }
        this.editor = editor;
        this.site = site;
        this.manager = manager;
        this.site.setSelectionProvider((ISelectionProvider)this);
        editor.getStoryModel().addModelListener((IModelListener)this);
        this.createActions();
        this.defaultPage = this.createDefaultPage();
        this.defaultPage.getHelper().createControl((Composite)this);
        this.setLayout(new HelperBookLayout());
        this.updatePages();
    }

    public IStoryEditor getStoryEditor() {
        return this.editor;
    }

    protected void createActions() {
        this.selectAction = this.createSelectAction();
        this.getSite().getActionBars().getToolBarManager().add((IAction)this.selectAction);
    }

    public void modelChanged(StoryChangeEvent e) {
        for (Change c : e.changes.values()) {
            if (!c.changed((IFlag)Flag.REPS)) continue;
            this.updatePages();
            return;
        }
    }

    protected abstract HelperPageDesc createDefaultPage();

    protected abstract SelectHelperDropDownAction createSelectAction();

    protected void updatePages() {
        Map<String, IHelperDescriptor<H>> shouldAppear = this.getHelpers();
        boolean currentPageRemoved = false;
        Iterator<Map.Entry<String, HelperPageDesc>> i = this.pageMap.entrySet().iterator();
        while (i.hasNext()) {
            Map.Entry<String, HelperPageDesc> entry = i.next();
            if (shouldAppear.remove(entry.getKey()) != null) continue;
            if (entry.getValue() == this.currentPage) {
                currentPageRemoved = true;
            }
            entry.getValue().getHelper().dispose();
            i.remove();
            this.selectAction.dispose();
        }
        boolean pagesChanged = false;
        for (IHelperDescriptor<H> desc : shouldAppear.values()) {
            IHelperPage helper = (IHelperPage)desc.create();
            if (helper == null) continue;
            helper.setStoryEditor(this.editor);
            this.pageMap.put(desc.getID(), this.createPageDesc(desc, helper));
            this.selectAction.dispose();
            pagesChanged = true;
        }
        if (this.currentPage == null || this.currentPage == this.defaultPage || currentPageRemoved) {
            HelperPageDesc pageToShow = this.pageMap.isEmpty() ? this.defaultPage : this.pageMap.entrySet().iterator().next().getValue();
            this.showPage(pageToShow);
            pagesChanged = true;
        }
        this.selectAction.setEnabled(!this.pageMap.isEmpty());
        if (pagesChanged) {
            this.layout(true);
        }
    }

    protected abstract HelperPageDesc createPageDesc(IHelperDescriptor<H> var1, H var2);

    protected Map<String, IHelperDescriptor<H>> getHelpers() {
        HashMap<String, IHelperDescriptor<H>> result = new HashMap<String, IHelperDescriptor<H>>();
        for (IRep rep : this.editor.getStoryModel().getData().getSupported()) {
            List descs = this.manager.getDescriptors(rep);
            if (descs == null) continue;
            for (IHelperDescriptor desc : descs) {
                result.put(desc.getID(), desc);
            }
        }
        return result;
    }

    public HelperPageDesc showPage(String id) {
        if (id == null) {
            throw new NullPointerException();
        }
        HelperPageDesc page = (HelperPageDesc)((Object)this.pageMap.get(id));
        if (page != null) {
            this.showPage(page);
        }
        return page;
    }

    public void showPage(HelperPageDesc page) {
        Control control;
        if (page == null) {
            throw new NullPointerException();
        }
        if (page == this.currentPage) {
            return;
        }
        boolean changed = false;
        HelperPageDesc oldPage = this.currentPage;
        IActionBars actionBars = this.getSite().getActionBars();
        if (oldPage != null) {
            if (this.provider != null) {
                this.provider.removeSelectionChangedListener(this.selectionListener);
            }
            this.provider = null;
            oldPage.getActionBars().deactivate();
            Map oldActionHandlers = oldPage.getActionBars().getGlobalActionHandlers();
            if (oldActionHandlers != null) {
                for (Map.Entry entry : oldActionHandlers.entrySet()) {
                    actionBars.setGlobalActionHandler((String)entry.getKey(), null);
                }
            }
            changed = true;
        }
        if ((control = page.getHelper().getControl()) == null) {
            try {
                page.getHelper().init(this.getSite());
            }
            catch (PartInitException e) {
                e.printStackTrace();
            }
            page.getHelper().createControl((Composite)this);
            control = page.getHelper().getControl();
            control.setVisible(false);
            this.layout(true);
        }
        if (!control.isDisposed()) {
            control.setVisible(true);
            this.currentPage = page;
            changed = true;
            this.provider = this.extractSelectionProvider(this.currentPage);
            if (this.provider != null) {
                this.provider.addSelectionChangedListener(this.selectionListener);
            }
            page.getActionBars().activate();
            Map newActionHandlers = this.currentPage.getActionBars().getGlobalActionHandlers();
            if (newActionHandlers != null) {
                for (Map.Entry entry : newActionHandlers.entrySet()) {
                    actionBars.setGlobalActionHandler((String)entry.getKey(), (IAction)entry.getValue());
                }
            }
        }
        if (oldPage != null && oldPage.getHelper().getControl() != null && !oldPage.getHelper().getControl().isDisposed()) {
            oldPage.getHelper().getControl().setVisible(false);
        }
        if (changed) {
            this.layout(true);
            actionBars.updateActionBars();
            Event e = new Event();
            e.data = this.currentPage;
            this.notifyListeners(2094818356, e);
        }
    }

    protected ISelectionProvider extractSelectionProvider(HelperPageDesc page) {
        IAdaptable adaptable;
        Object o;
        Object helper = page.getHelper();
        if (helper instanceof ISelectionProvider) {
            return (ISelectionProvider)helper;
        }
        if (helper instanceof IAdaptable && (o = (adaptable = (IAdaptable)helper).getAdapter(ISelectionProvider.class)) != null) {
            return (ISelectionProvider)o;
        }
        return null;
    }

    public HelperPageDesc getCurrentPage() {
        return this.currentPage;
    }

    public IPageSite getSite() {
        return this.site;
    }

    public void dispose() {
        this.editor.getStoryModel().removeModelListener((IModelListener)this);
        for (HelperPageDesc desc : this.pageMap.values()) {
            desc.getHelper().dispose();
        }
        this.pageMap.clear();
        this.pageMap = null;
        super.dispose();
    }

    protected void helperPageSelectionChanged(final SelectionChangedEvent e) {
        Object[] listeners;
        if (e == null) {
            throw new NullPointerException();
        }
        Object[] objectArray = listeners = this.selectionListeners.getListeners();
        int n = listeners.length;
        int n2 = 0;
        while (n2 < n) {
            final Object listener = objectArray[n2];
            SafeRunnable.run((ISafeRunnable)new SafeRunnable(){

                public void run() throws Exception {
                    ((ISelectionChangedListener)listener).selectionChanged(e);
                }
            });
            ++n2;
        }
    }

    public void addSelectionChangedListener(ISelectionChangedListener listener) {
        this.selectionListeners.add((Object)listener);
    }

    public ISelection getSelection() {
        return StructuredSelection.EMPTY;
    }

    public void removeSelectionChangedListener(ISelectionChangedListener listener) {
        this.selectionListeners.remove((Object)listener);
    }

    public void setSelection(ISelection selection) {
        if (this.provider != null) {
            this.provider.setSelection(selection);
        }
    }

    protected class HelperBookLayout
    extends Layout {
        protected HelperBookLayout() {
        }

        protected Point computeSize(Composite composite, int wHint, int hHint, boolean flushCache) {
            if (wHint != -1 && hHint != -1) {
                return new Point(wHint, hHint);
            }
            Point result = null;
            result = HelperPageBookWidget.this.currentPage != null ? HelperPageBookWidget.this.currentPage.getHelper().getControl().computeSize(wHint, hHint, flushCache) : new Point(0, 0);
            if (wHint != -1) {
                result.x = wHint;
            }
            if (hHint != -1) {
                result.y = hHint;
            }
            return result;
        }

        protected void layout(Composite composite, boolean flushCache) {
            if (HelperPageBookWidget.this.currentPage == null) {
                return;
            }
            Control c = HelperPageBookWidget.this.currentPage.getHelper().getControl();
            if (c != null) {
                c.setBounds(composite.getClientArea());
            }
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class HelperPageDesc
    extends Action {
        private final H helper;
        private final IHelperDescriptor<H> desc;
        private final IContributionItem item;
        private final String commandID;
        private final String paramID;
        private SubActionBars subActionBars;
        final /* synthetic */ HelperPageBookWidget this$0;

        public HelperPageDesc(IHelperDescriptor<H> desc, H helper) {
            this(var1_1, desc, (IHelperPage)helper, null, null);
        }

        public HelperPageDesc(IHelperDescriptor<H> desc, H helper, String commandID, String paramID) {
            this.this$0 = var1_1;
            super(null, 2);
            if (helper == null) {
                throw new NullPointerException();
            }
            this.desc = desc;
            this.helper = helper;
            this.item = new ActionContributionItem((IAction)this);
            this.commandID = commandID;
            this.paramID = paramID;
        }

        public IHelperDescriptor<H> getDescriptor() {
            return this.desc;
        }

        public H getHelper() {
            return this.helper;
        }

        public SubActionBars getActionBars() {
            if (this.subActionBars == null) {
                this.subActionBars = new SubActionBars(this.this$0.getSite().getActionBars());
                this.helper.setActionBars((IActionBars)this.subActionBars);
            }
            return this.subActionBars;
        }

        public IContributionItem getItem() {
            return this.item;
        }

        public String getText() {
            if (this.commandID == null || this.paramID == null) {
                return this.getDescriptor().getName();
            }
            ICommandService commands = (ICommandService)this.this$0.getSite().getService(ICommandService.class);
            Command command = commands.getCommand(this.commandID);
            IParameter param = null;
            try {
                param = command.getParameter(this.paramID);
            }
            catch (NotDefinedException e) {
                Status status = new Status(4, StoryUIPlugin.getDefault().getID(), null, (Throwable)e);
                StoryUIPlugin.getDefault().getLog().log((IStatus)status);
            }
            if (param == null) {
                Debug.out();
            }
            Parameterization p = new Parameterization(param, this.desc.getID());
            ParameterizedCommand pCommand = new ParameterizedCommand(command, new Parameterization[]{p});
            IBindingService bindings = (IBindingService)this.this$0.getSite().getService(IBindingService.class);
            TriggerSequence seq = bindings.getBestActiveBindingFor(pCommand);
            String text = this.getDescriptor().getName();
            return seq == null ? text : String.valueOf(text) + "\t" + seq.format();
        }

        public String getDescription() {
            return this.desc.getDescription();
        }

        public String getToolTipText() {
            return this.getDescription();
        }

        public boolean isChecked() {
            return this.this$0.currentPage == this;
        }

        public void run() {
            this.this$0.showPage(this);
        }
    }

    public abstract class SelectHelperDropDownAction
    extends Action
    implements IMenuCreator {
        protected Menu menu;

        public SelectHelperDropDownAction(String text) {
            super(text, 4);
            this.setMenuCreator(this);
        }

        public Menu getMenu(Menu parent) {
            return null;
        }

        public Menu getMenu(Control parent) {
            if (this.menu != null) {
                this.menu.dispose();
            }
            this.menu = new Menu(parent);
            int i = 0;
            for (HelperPageDesc page : HelperPageBookWidget.this.pageMap.values()) {
                page.getItem().fill(this.menu, i++);
            }
            return this.menu;
        }

        public void dispose() {
            if (this.menu != null) {
                this.menu.dispose();
            }
            this.menu = null;
        }
    }
}

