/*
 * Decompiled with CFR 0.152.
 */
package edu.mit.story.ui.editor;

import edu.mit.story.ui.StoryUIMessages;
import edu.mit.story.ui.editor.IStoryEditor;
import java.util.Iterator;
import org.eclipse.core.resources.IMarker;
import org.eclipse.jface.text.IDocument;
import org.eclipse.jface.text.ITextViewer;
import org.eclipse.jface.text.contentassist.ICompletionProposal;
import org.eclipse.jface.text.contentassist.IContentAssistProcessor;
import org.eclipse.jface.text.contentassist.IContextInformation;
import org.eclipse.jface.text.contentassist.IContextInformationValidator;
import org.eclipse.jface.text.source.Annotation;
import org.eclipse.jface.text.source.IAnnotationModel;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.Point;
import org.eclipse.ui.IMarkerHelpRegistry;
import org.eclipse.ui.IMarkerResolution;
import org.eclipse.ui.IMarkerResolution2;
import org.eclipse.ui.ide.IDE;
import org.eclipse.ui.texteditor.MarkerAnnotation;

public class StoryContentAssistProcessor
implements IContentAssistProcessor {
    IStoryEditor fEditor;
    IMarkerHelpRegistry fIDEMarkerHelpRegistry = IDE.getMarkerHelpRegistry();
    public static final ICompletionProposal[] nullCompletionProposalArray = new ICompletionProposal[]{new EmptyCompletionProposal()};

    public StoryContentAssistProcessor(IStoryEditor editor) {
        if (editor == null) {
            throw new NullPointerException();
        }
        this.fEditor = editor;
    }

    public ICompletionProposal[] computeCompletionProposals(ITextViewer viewer, int offset) {
        IAnnotationModel model = this.fEditor.getDocumentProvider().getAnnotationModel((Object)this.fEditor.getEditorInput());
        if (model == null) {
            return nullCompletionProposalArray;
        }
        Iterator i = model.getAnnotationIterator();
        while (i.hasNext()) {
            MarkerAnnotation ma;
            IMarker m;
            Annotation a = (Annotation)i.next();
            if (a.isMarkedDeleted() || !(a instanceof MarkerAnnotation) || (m = (ma = (MarkerAnnotation)a).getMarker()) == null) continue;
            int start = m.getAttribute("charStart", -1);
            int end = m.getAttribute("charEnd", -1);
            if (start == -1 || end == -1 || end < start || offset < start || end < offset || !this.fIDEMarkerHelpRegistry.hasResolutions(m)) continue;
            IMarkerResolution[] resolutions = this.fIDEMarkerHelpRegistry.getResolutions(m);
            ICompletionProposal[] proposals = new ICompletionProposal[resolutions.length];
            int j = 0;
            while (j < resolutions.length) {
                proposals[j] = new MarkerResolutionWrapper(m, resolutions[j]);
                ++j;
            }
            return proposals;
        }
        return nullCompletionProposalArray;
    }

    public IContextInformation[] computeContextInformation(ITextViewer viewer, int offset) {
        return null;
    }

    public char[] getCompletionProposalAutoActivationCharacters() {
        return null;
    }

    public char[] getContextInformationAutoActivationCharacters() {
        return null;
    }

    public String getErrorMessage() {
        return null;
    }

    public IContextInformationValidator getContextInformationValidator() {
        return null;
    }

    public static class EmptyCompletionProposal
    implements ICompletionProposal {
        public void apply(IDocument document) {
        }

        public Point getSelection(IDocument document) {
            return null;
        }

        public String getAdditionalProposalInfo() {
            return null;
        }

        public String getDisplayString() {
            return StoryUIMessages.MSG_NoProposalsAvailable;
        }

        public Image getImage() {
            return null;
        }

        public IContextInformation getContextInformation() {
            return null;
        }
    }

    public static class MarkerResolutionWrapper
    implements ICompletionProposal {
        final IMarker fMarker;
        final IMarkerResolution fResolution;

        public MarkerResolutionWrapper(IMarker marker, IMarkerResolution resolution) {
            if (marker == null || resolution == null) {
                throw new NullPointerException();
            }
            this.fResolution = resolution;
            this.fMarker = marker;
        }

        public void apply(IDocument document) {
            this.fResolution.run(this.fMarker);
        }

        public Point getSelection(IDocument document) {
            return null;
        }

        public String getAdditionalProposalInfo() {
            if (this.fResolution instanceof IMarkerResolution2) {
                return ((IMarkerResolution2)this.fResolution).getDescription();
            }
            return null;
        }

        public String getDisplayString() {
            return this.fResolution.getLabel();
        }

        public Image getImage() {
            if (this.fResolution instanceof IMarkerResolution2) {
                return ((IMarkerResolution2)this.fResolution).getImage();
            }
            return null;
        }

        public IContextInformation getContextInformation() {
            return null;
        }
    }
}

