/*
 * Decompiled with CFR 0.152.
 */
package edu.mit.story.ui.editor;

import edu.mit.story.core.model.IStoryModel;
import edu.mit.story.core.model.IUndoableStoryModel;
import edu.mit.story.core.model.change.IModelListener;
import edu.mit.story.core.model.change.StoryChangeEvent;
import edu.mit.story.ui.actions.ActionUtils;
import edu.mit.story.ui.actions.SelectionUtils;
import edu.mit.story.ui.actions.groups.CompositeActionGroup;
import edu.mit.story.ui.actions.groups.EditDescriptionGroup;
import edu.mit.story.ui.actions.groups.StoryEditorUndoRedoActionGroup;
import edu.mit.story.ui.content.IHasTreeViewer;
import edu.mit.story.ui.content.StoryModelContentProvider;
import edu.mit.story.ui.editor.IStoryEditor;
import edu.mit.story.ui.label.StoryContentLabelProvider;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.core.runtime.ISafeRunnable;
import org.eclipse.core.runtime.ListenerList;
import org.eclipse.core.runtime.SafeRunner;
import org.eclipse.jface.action.IMenuManager;
import org.eclipse.jface.action.MenuManager;
import org.eclipse.jface.util.SafeRunnable;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.ISelectionProvider;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.jface.viewers.TreeViewer;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Menu;
import org.eclipse.ui.ISelectionListener;
import org.eclipse.ui.IWorkbenchPart;
import org.eclipse.ui.actions.ActionGroup;
import org.eclipse.ui.part.IPageSite;
import org.eclipse.ui.part.Page;
import org.eclipse.ui.views.contentoutline.ContentOutline;
import org.eclipse.ui.views.contentoutline.IContentOutlinePage;

public class StoryContentOutlinePage
extends Page
implements IHasTreeViewer,
IAdaptable,
IModelListener,
ISelectionListener,
IContentOutlinePage,
ISelectionChangedListener {
    ListenerList selectionChangedListeners = new ListenerList();
    IStoryEditor fEditor = null;
    TreeViewer treeViewer;
    ActionGroup actionGroup;

    public StoryContentOutlinePage(IStoryEditor editor) {
        this.fEditor = editor;
    }

    public Object getAdapter(Class adapter) {
        return this.fEditor.getAdapter(adapter);
    }

    public void init(IPageSite pageSite) {
        super.init(pageSite);
        pageSite.setSelectionProvider((ISelectionProvider)this);
    }

    public void createControl(Composite parent) {
        if (this.fEditor == null) {
            return;
        }
        this.fEditor.getStoryModel().addModelListener((IModelListener)this);
        this.treeViewer = new TreeViewer(parent, 772);
        this.treeViewer.setUseHashlookup(true);
        this.treeViewer.setAutoExpandLevel(2);
        this.treeViewer.addSelectionChangedListener((ISelectionChangedListener)this);
        this.treeViewer.setContentProvider((IContentProvider)new StoryModelContentProvider(this.fEditor));
        this.treeViewer.setLabelProvider((IBaseLabelProvider)new StoryContentLabelProvider(this.fEditor));
        this.getSite().setSelectionProvider((ISelectionProvider)this);
        this.getSite().getPage().addPostSelectionListener((ISelectionListener)this);
        this.treeViewer.setInput((Object)this.fEditor);
        this.treeViewer.expandToLevel(2);
        this.createActions();
    }

    protected void createActions() {
        this.actionGroup = new CompositeActionGroup(new StoryEditorUndoRedoActionGroup(this.fEditor), new EditDescriptionGroup(this.fEditor, (ISelectionProvider)this.getTreeViewer()));
        this.actionGroup.fillActionBars(this.getSite().getActionBars());
        MenuManager manager = new MenuManager("StoryContentOutlinePopupMenu");
        ActionUtils.createPopupGroups((IMenuManager)manager);
        this.getSite().registerContextMenu("edu.mit.story.popup.storyOutline", manager, (ISelectionProvider)this.getTreeViewer());
        Menu menu = manager.createContextMenu(this.getControl());
        this.getControl().setMenu(menu);
        this.actionGroup.fillContextMenu((IMenuManager)manager);
    }

    public TreeViewer getTreeViewer() {
        return this.treeViewer;
    }

    public Control getControl() {
        return this.getTreeViewer().getTree();
    }

    public void setFocus() {
        this.getControl().setFocus();
    }

    public void dispose() {
        super.dispose();
        if (this.fEditor != null) {
            IUndoableStoryModel provider = this.fEditor.getStoryModel();
            provider.removeModelListener((IModelListener)this);
        }
        this.getSite().setSelectionProvider(null);
        this.getSite().getPage().removePostSelectionListener((ISelectionListener)this);
        this.fEditor = null;
    }

    public void modelChanged(StoryChangeEvent e) {
        if (e != null) {
            this.getTreeViewer().refresh();
        }
    }

    public void selectionChanged(IWorkbenchPart part, ISelection selection) {
        if (part instanceof ContentOutline) {
            return;
        }
        this.setSelection(selection);
    }

    public void selectionChanged(SelectionChangedEvent event) {
        IStoryModel model = SelectionUtils.extractFirst(event.getSelection(), IStoryModel.class);
        if (model == null) {
            this.fireSelectionChanged(event.getSelection());
        }
    }

    public ISelection getSelection() {
        return this.getTreeViewer().getSelection();
    }

    public void setSelection(ISelection selection) {
        this.getTreeViewer().setSelection(selection);
    }

    public void addSelectionChangedListener(ISelectionChangedListener listener) {
        this.selectionChangedListeners.add((Object)listener);
    }

    public void removeSelectionChangedListener(ISelectionChangedListener listener) {
        this.selectionChangedListeners.remove((Object)listener);
    }

    protected void fireSelectionChanged(ISelection selection) {
        final SelectionChangedEvent event = new SelectionChangedEvent((ISelectionProvider)this, selection);
        Object[] listeners = this.selectionChangedListeners.getListeners();
        int i = 0;
        while (i < listeners.length) {
            final ISelectionChangedListener l = (ISelectionChangedListener)listeners[i];
            SafeRunner.run((ISafeRunnable)new SafeRunnable(){

                public void run() {
                    l.selectionChanged(event);
                }
            });
            ++i;
        }
    }
}

