/*
 * Decompiled with CFR 0.152.
 */
package edu.mit.story.ui.dialogs;

import edu.mit.story.ui.StoryUIMessages;
import edu.mit.story.ui.editor.IStoryEditor;
import org.eclipse.jface.dialogs.Dialog;
import org.eclipse.jface.text.Position;
import org.eclipse.jface.text.source.Annotation;
import org.eclipse.jface.text.source.IAnnotationModelExtension;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Spinner;

public class SpecifyInsertionIndexDialog
extends Dialog {
    private IStoryEditor fEditor;
    Button beginButton;
    Button endButton;
    Button indexButton;
    Spinner indexInput;
    IAnnotationModelExtension fModel;
    Annotation fIdxAnnotation = new Annotation("edu.mit.story.ui.annotation.target0", false, StoryUIMessages.ANNOTATION_DescriptionEditing_text);
    int fSelection = 0;

    public SpecifyInsertionIndexDialog(IStoryEditor editor, Shell parent) {
        super(parent);
        this.fEditor = editor;
        if (this.fEditor != null) {
            this.fModel = (IAnnotationModelExtension)this.fEditor.getDocumentProvider().getAnnotationModel((Object)this.fEditor.getEditorInput());
        }
    }

    protected Control createDialogArea(Composite parent) {
        Composite composite = (Composite)super.createDialogArea(parent);
        GridLayout layout = new GridLayout();
        layout.numColumns = 2;
        composite.setLayout((Layout)layout);
        final int max = this.fEditor.getStoryModel().getLength();
        if (this.fModel != null) {
            this.fModel.modifyAnnotationPosition(this.fIdxAnnotation, new Position(max, 0));
        }
        this.beginButton = new Button(composite, 16);
        this.beginButton.setText("Beginning (index = 0)");
        this.beginButton.setSelection(false);
        this.beginButton.addSelectionListener(new SelectionListener(){

            public void widgetSelected(SelectionEvent e) {
                if (SpecifyInsertionIndexDialog.this.beginButton.getSelection()) {
                    SpecifyInsertionIndexDialog.this.fSelection = 0;
                    SpecifyInsertionIndexDialog.this.endButton.setSelection(false);
                    SpecifyInsertionIndexDialog.this.indexButton.setSelection(false);
                    if (SpecifyInsertionIndexDialog.this.fModel != null) {
                        SpecifyInsertionIndexDialog.this.fModel.modifyAnnotationPosition(SpecifyInsertionIndexDialog.this.fIdxAnnotation, new Position(0, 0));
                    }
                }
            }

            public void widgetDefaultSelected(SelectionEvent e) {
            }
        });
        Label blank = new Label(composite, 0);
        blank.setText("\t\t");
        this.endButton = new Button(composite, 16);
        this.endButton.setText("End (index = " + max + ")");
        this.endButton.setSelection(true);
        this.endButton.addSelectionListener(new SelectionListener(){

            public void widgetSelected(SelectionEvent e) {
                if (SpecifyInsertionIndexDialog.this.endButton.getSelection()) {
                    SpecifyInsertionIndexDialog.this.fSelection = max;
                    SpecifyInsertionIndexDialog.this.beginButton.setSelection(false);
                    SpecifyInsertionIndexDialog.this.indexButton.setSelection(false);
                    if (SpecifyInsertionIndexDialog.this.fModel != null) {
                        SpecifyInsertionIndexDialog.this.fModel.modifyAnnotationPosition(SpecifyInsertionIndexDialog.this.fIdxAnnotation, new Position(max, 0));
                    }
                }
            }

            public void widgetDefaultSelected(SelectionEvent e) {
            }
        });
        new Label(composite, 0);
        this.indexButton = new Button(composite, 16);
        this.indexButton.setText("At Index:");
        this.indexButton.setSelection(false);
        this.indexButton.addSelectionListener(new SelectionListener(){

            public void widgetSelected(SelectionEvent e) {
                boolean selected = SpecifyInsertionIndexDialog.this.indexButton.getSelection();
                SpecifyInsertionIndexDialog.this.indexInput.setEnabled(selected);
                if (selected) {
                    SpecifyInsertionIndexDialog.this.beginButton.setSelection(false);
                    SpecifyInsertionIndexDialog.this.endButton.setSelection(false);
                    SpecifyInsertionIndexDialog.this.fSelection = SpecifyInsertionIndexDialog.this.indexInput.getSelection();
                    if (SpecifyInsertionIndexDialog.this.fModel != null) {
                        SpecifyInsertionIndexDialog.this.fModel.modifyAnnotationPosition(SpecifyInsertionIndexDialog.this.fIdxAnnotation, new Position(SpecifyInsertionIndexDialog.this.indexInput.getSelection(), 0));
                    }
                }
            }

            public void widgetDefaultSelected(SelectionEvent e) {
            }
        });
        this.indexInput = new Spinner(composite, 2048);
        GridData data = new GridData();
        data.grabExcessHorizontalSpace = true;
        data.horizontalAlignment = 4;
        this.indexInput.setLayoutData((Object)data);
        this.indexInput.setEnabled(false);
        this.indexInput.setMinimum(0);
        this.indexInput.setMaximum(max);
        this.indexInput.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                if (SpecifyInsertionIndexDialog.this.fModel != null) {
                    SpecifyInsertionIndexDialog.this.fModel.modifyAnnotationPosition(SpecifyInsertionIndexDialog.this.fIdxAnnotation, new Position(SpecifyInsertionIndexDialog.this.indexInput.getSelection(), 0));
                }
            }
        });
        return composite;
    }

    public int getSelection() {
        return this.fSelection;
    }

    protected void configureShell(Shell newShell) {
        super.configureShell(newShell);
        newShell.setText(StoryUIMessages.DIALOG_InsertAt_title);
    }

    public boolean close() {
        if (this.fModel != null) {
            this.fModel.modifyAnnotationPosition(this.fIdxAnnotation, null);
        }
        return super.close();
    }
}

