/*
 * Decompiled with CFR 0.152.
 */
package edu.mit.story.ui.content;

import edu.mit.story.core.desc.IDesc;
import edu.mit.story.core.desc.IDescSet;
import edu.mit.story.core.meta.IMetaDataMap;
import edu.mit.story.core.meta.IMetaDataSet;
import edu.mit.story.core.meta.IMetaDesc;
import edu.mit.story.core.meta.MetaDataMap;
import edu.mit.story.core.model.IStoryData;
import edu.mit.story.core.model.IStoryModel;
import edu.mit.story.core.rep.IRep;
import edu.mit.story.ui.editor.IStoryEditor;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.LinkedList;
import org.eclipse.jface.viewers.ITreeContentProvider;
import org.eclipse.jface.viewers.Viewer;

public class StoryModelContentProvider
implements ITreeContentProvider {
    IStoryEditor fEditor;

    public StoryModelContentProvider(IStoryEditor input) {
        this.inputChanged(null, null, input);
    }

    public void inputChanged(Viewer viewer, Object oldInput, Object newInput) {
        if (newInput instanceof IStoryEditor) {
            this.fEditor = (IStoryEditor)newInput;
        }
    }

    public boolean hasChildren(Object element) {
        if (element == null) {
            return false;
        }
        if (element instanceof IStoryEditor) {
            return ((IStoryEditor)element).getStoryModel().repSize() > 0;
        }
        if (element instanceof IStoryModel) {
            return ((IStoryModel)element).repSize() > 0;
        }
        if (element instanceof IDescSet) {
            IDescSet descs = (IDescSet)element;
            if (!descs.isEmpty()) {
                return true;
            }
            IRep rep = descs.getRep();
            Iterator i = this.fEditor.getStoryModel().getData().getMetadata().iterator();
            while (i.hasNext()) {
                if (((IMetaDesc)i.next()).getRep() != rep) continue;
                return true;
            }
            return false;
        }
        if (element instanceof IDesc) {
            IDesc d = (IDesc)element;
            return d.getMetaData().iterator().hasNext();
        }
        return element instanceof IMetaDataSet;
    }

    public Object[] getElements(Object inputElement) {
        return this.getChildren(inputElement);
    }

    public Object[] getChildren(Object parent) {
        if (parent instanceof IStoryEditor) {
            IStoryEditor editor = (IStoryEditor)parent;
            return new Object[]{editor.getStoryModel()};
        }
        if (parent instanceof IStoryModel) {
            IStoryModel model = (IStoryModel)parent;
            ArrayList<IDescSet> result = new ArrayList<IDescSet>(model.getSupported().size());
            for (IRep rep : model.getSupported()) {
                result.add(model.getData().getDescriptions(rep));
            }
            return result.toArray();
        }
        if (parent instanceof IDescSet) {
            IDescSet descs = (IDescSet)parent;
            IRep rep = descs.getRep();
            IStoryData data = this.fEditor.getStoryModel().getData();
            MetaDataMap map = new MetaDataMap();
            for (IMetaDesc metaDesc : data.getMetadata()) {
                if (metaDesc.getRep() != rep) continue;
                map.addDesc(metaDesc);
            }
            int size = descs.size() + (map.isEmpty() ? 0 : 1);
            Object[] array = descs.toArray(new Object[size]);
            if (!map.isEmpty()) {
                array[size - 1] = map;
            }
            return array;
        }
        if (parent instanceof IDesc) {
            IDesc desc = (IDesc)parent;
            Collection values = desc.getMetaData().values();
            ArrayList<IMetaDataSet> children = new ArrayList<IMetaDataSet>(values.size());
            for (IMetaDataSet set : values) {
                if (set.isEmpty()) continue;
                children.add(set);
            }
            return children.toArray();
        }
        if (parent instanceof IMetaDataMap) {
            IMetaDataMap map = (IMetaDataMap)parent;
            LinkedList<IMetaDataSet> result = new LinkedList<IMetaDataSet>();
            for (IMetaDataSet set : map.values()) {
                if (set.isEmpty()) continue;
                result.add(set);
            }
            return result.toArray();
        }
        if (parent instanceof IMetaDataSet) {
            return ((IMetaDataSet)parent).toArray();
        }
        return null;
    }

    public Object getParent(Object child) {
        return null;
    }

    public void dispose() {
        this.fEditor = null;
    }
}

