/*
 * Decompiled with CFR 0.152.
 */
package edu.mit.story.ui.build.rules;

import edu.mit.story.core.build.IStoryProblem;
import edu.mit.story.core.model.IStoryModel;
import edu.mit.story.core.position.HasPositionSet;
import edu.mit.story.core.position.IHasPositionSet;
import edu.mit.story.core.rep.IRep;
import edu.mit.story.core.rep.RepSet;
import edu.mit.story.core.rep.character.CharRep;
import edu.mit.story.ui.build.StoryNature;
import edu.mit.story.ui.build.problems.ModelHasUnsupportedProblem;
import edu.mit.story.ui.build.problems.ModelLacksRequiredProblem;
import edu.mit.story.ui.build.problems.ModelLacksSupportedProblem;
import edu.mit.story.ui.build.rules.AbstractContextBuildRule;
import java.util.Collection;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ModelCorpusRepsRule
extends AbstractContextBuildRule {
    public ModelCorpusRepsRule() {
        super(CharRep.getInstance());
    }

    @Override
    public IHasPositionSet<IStoryProblem> build(IStoryModel model, StoryNature nature) {
        HasPositionSet result = new HasPositionSet();
        RepSet reps = new RepSet((Collection)nature.getRequired());
        reps.removeAll((Collection)model.getSupported());
        if (!reps.isEmpty()) {
            if (this.isCompressing()) {
                result.add((Object)new ModelLacksRequiredProblem((Collection<? extends IRep>)reps, this.getID()));
            } else {
                for (IRep rep : reps) {
                    result.add((Object)new ModelLacksRequiredProblem(rep, this.getID()));
                }
            }
        }
        reps = new RepSet((Collection)nature.getSupported());
        reps.removeAll((Collection)model.getSupported());
        if (!reps.isEmpty()) {
            if (this.isCompressing()) {
                result.add((Object)new ModelLacksSupportedProblem((Collection<? extends IRep>)reps, this.getID()));
            } else {
                for (IRep rep : reps) {
                    result.add((Object)new ModelLacksSupportedProblem(rep, this.getID()));
                }
            }
        }
        reps = new RepSet((Collection)model.getSupported());
        reps.removeAll((Collection)nature.getSupported());
        if (!reps.isEmpty()) {
            if (this.isCompressing()) {
                result.add((Object)new ModelHasUnsupportedProblem((Collection<? extends IRep>)reps, this.getID()));
            } else {
                for (IRep rep : reps) {
                    result.add((Object)new ModelHasUnsupportedProblem(rep, this.getID()));
                }
            }
        }
        return result;
    }
}

