/*
 * Decompiled with CFR 0.152.
 */
package edu.mit.story.core.model.change;

import edu.mit.story.core.StoryMessages;
import edu.mit.story.core.StoryPlugin;
import edu.mit.story.core.desc.factory.IDescFactory;
import edu.mit.story.core.model.IMutableStoryModel;
import edu.mit.story.core.model.IStoryModel;
import edu.mit.story.core.model.change.AbstractModelChange;
import edu.mit.story.core.model.change.StoryChangeEvent;
import edu.mit.story.core.rep.IRep;
import edu.mit.story.core.util.LogUtils;
import edu.mit.story.core.util.StringUtils;
import org.eclipse.core.runtime.ISafeRunnable;
import org.eclipse.core.runtime.Plugin;
import org.eclipse.core.runtime.SafeRunner;
import org.eclipse.osgi.util.NLS;

public class DescFactoryChange
extends AbstractModelChange {
    final IRep rep;
    final StoryChangeEvent event;

    public DescFactoryChange(IRep rep, StoryChangeEvent event) {
        super(StoryMessages.CHANGE_NAME_FactoryChange);
        if (rep == null) {
            throw new NullPointerException();
        }
        if (event == null) {
            throw new NullPointerException();
        }
        this.rep = rep;
        this.event = event;
    }

    protected StoryChangeEvent doApply(Object source, IMutableStoryModel provider) {
        SafeFactoryRunner runner = new SafeFactoryRunner(provider, this.event);
        SafeRunner.run((ISafeRunnable)runner);
        return runner.getResult();
    }

    public String toString() {
        return StringUtils.getClassName(DescFactoryChange.class);
    }

    protected class SafeFactoryRunner
    implements ISafeRunnable {
        final IStoryModel model;
        final StoryChangeEvent event;
        private StoryChangeEvent result = null;

        public SafeFactoryRunner(IStoryModel model, StoryChangeEvent event) {
            if (model == null || event == null) {
                throw new NullPointerException();
            }
            this.model = model;
            this.event = event;
        }

        public void run() throws Exception {
            IDescFactory factory = this.model.getFactory(DescFactoryChange.this.rep);
            if (factory != null) {
                this.result = factory.applyChanges(this.event);
            }
        }

        public void handleException(Throwable e) {
            String msg = NLS.bind((String)StoryMessages.MSG_ERR_ExceptionThrownDuringFactoryChange, (Object)DescFactoryChange.this.rep.getID());
            LogUtils.logError((Plugin)StoryPlugin.getDefault(), e, msg);
        }

        public StoryChangeEvent getResult() {
            return this.result;
        }
    }
}

