/*
 * Decompiled with CFR 0.152.
 */
package edu.mit.story.core.desc;

import edu.mit.story.core.align.IAlignedStoryModel;
import edu.mit.story.core.desc.Desc;
import edu.mit.story.core.desc.DescComparator;
import edu.mit.story.core.desc.IData;
import edu.mit.story.core.desc.IDesc;
import edu.mit.story.core.desc.IDescSet;
import edu.mit.story.core.element.IStoryElement;
import edu.mit.story.core.meta.IMetaDataMap;
import edu.mit.story.core.meta.timing.ITiming;
import edu.mit.story.core.position.IHasPosition;
import edu.mit.story.core.rep.IRep;
import edu.mit.story.core.rep.RepUtils;
import gnu.trove.map.hash.TLongObjectHashMap;
import java.util.AbstractSet;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.Iterator;
import java.util.NoSuchElementException;
import java.util.Set;
import java.util.SortedSet;
import java.util.TreeSet;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DescSet
extends AbstractSet<IDesc>
implements IDescSet {
    private static final long serialVersionUID = 8321419692835268154L;
    private final IRep rep;
    private final int lowerBound;
    private final boolean openSet;
    private final SortedSet<IDesc> backingSet;
    private final TLongObjectHashMap<IDesc> idMap;

    public DescSet(IRep rep) {
        this(rep, Collections.emptySet());
    }

    public DescSet(IDesc desc) {
        this(desc.getRep(), Collections.singleton(desc));
    }

    public DescSet(IDescSet descSet) {
        this(descSet.getRep(), descSet);
    }

    public DescSet(IRep rep, Collection<? extends IDesc> elements) {
        if (rep == null) {
            throw new NullPointerException();
        }
        this.rep = rep;
        this.lowerBound = -1;
        this.openSet = true;
        this.backingSet = new TreeSet<IDesc>(DescComparator.getInstance());
        this.idMap = new TLongObjectHashMap();
        this.addAll(elements);
    }

    protected DescSet(IRep rep, int lowerBound, boolean openSet, SortedSet<IDesc> backingSet, TLongObjectHashMap<IDesc> idMap) {
        if (rep == null) {
            throw new NullPointerException();
        }
        if (backingSet == null) {
            throw new NullPointerException();
        }
        if (lowerBound < -1) {
            throw new IllegalArgumentException();
        }
        this.rep = rep;
        this.lowerBound = lowerBound;
        this.openSet = openSet;
        this.backingSet = backingSet;
        this.idMap = idMap;
    }

    protected boolean insideLowerBound(IHasPosition p) {
        if (this.lowerBound < 0) {
            return true;
        }
        if (p.getRightOffset() < this.lowerBound) {
            return false;
        }
        return !this.openSet || p.getRightOffset() != this.lowerBound || p.getLength() <= 0;
    }

    @Override
    public boolean add(IDesc d) {
        if (d.getRep() != this.rep) {
            throw new IllegalArgumentException();
        }
        if (this.insideLowerBound(d)) {
            boolean result = this.backingSet.add(d);
            if (result) {
                this.idMap.put(d.getID(), (Object)d);
                this.elementAdded(d);
            }
            return result;
        }
        throw new IllegalArgumentException("element out of bounds for range of set");
    }

    @Override
    public boolean remove(Object o) {
        if (o instanceof IDesc) {
            boolean result;
            IDesc d = (IDesc)o;
            boolean bl = result = this.insideLowerBound(d) && this.backingSet.remove(d);
            if (result) {
                this.idMap.remove(d.getID());
                this.elementRemoved(d);
            }
            return result;
        }
        return false;
    }

    protected void elementAdded(IDesc d) {
    }

    protected void elementRemoved(IDesc d) {
    }

    @Override
    public boolean contains(Object o) {
        if (o instanceof IDesc) {
            IDesc d = (IDesc)o;
            return this.idMap.get(d.getID()) == d && this.insideLowerBound(d) && this.backingSet.contains(d);
        }
        return false;
    }

    @Override
    public int size() {
        if (this.lowerBound == -1) {
            return this.backingSet.size();
        }
        int size = 0;
        Iterator<IDesc> iterator = this.iterator();
        while (iterator.hasNext()) {
            iterator.next();
            ++size;
        }
        return size;
    }

    @Override
    public IDescSet closedSet(IHasPosition range) {
        return this.rangeSet(range, false);
    }

    @Override
    public IDescSet openSet(IHasPosition range) {
        return this.rangeSet(range, true);
    }

    protected IDescSet rangeSet(IHasPosition range, boolean isOpen) {
        LimitDesc toElement = new LimitDesc(range.getRightOffset(), isOpen);
        return this.rangeSet(this.rep, range.getOffset(), isOpen, this.backingSet.headSet(toElement), this.idMap);
    }

    protected IDescSet rangeSet(IRep rep, int lowerBound, boolean isOpen, SortedSet<IDesc> backing, TLongObjectHashMap<IDesc> idMap) {
        return new DescSet(rep, lowerBound, isOpen, backing, idMap);
    }

    @Override
    public IDescSet matchSet(IHasPosition position) {
        LimitDesc lower = new LimitDesc(position, false);
        LimitDesc upper = new LimitDesc(position, true);
        return this.rangeSet(this.rep, this.lowerBound, this.openSet, this.backingSet.subSet(lower, upper), this.idMap);
    }

    @Override
    public IDescSet headSet(IDesc toElement) {
        return this.rangeSet(this.rep, this.lowerBound, this.openSet, this.backingSet.headSet(toElement), this.idMap);
    }

    @Override
    public IDescSet subSet(IDesc fromElement, IDesc toElement) {
        return this.rangeSet(this.rep, this.lowerBound, this.openSet, this.backingSet.subSet(fromElement, toElement), this.idMap);
    }

    @Override
    public IDescSet tailSet(IDesc fromElement) {
        return this.rangeSet(this.rep, this.lowerBound, this.openSet, this.backingSet.tailSet(fromElement), this.idMap);
    }

    @Override
    public Iterator<IDesc> iterator() {
        return this.lowerBound < 0 ? this.backingSet.iterator() : new DescSetIterator();
    }

    @Override
    public IDesc first() {
        return this.lowerBound < 0 ? this.backingSet.first() : this.iterator().next();
    }

    @Override
    public IDesc last() {
        if (this.lowerBound == -1) {
            return this.backingSet.last();
        }
        IDesc result2 = null;
        for (IDesc result2 : this) {
        }
        if (result2 == null) {
            throw new NoSuchElementException();
        }
        return result2;
    }

    @Override
    public int getOffset() {
        try {
            return this.first().getOffset();
        }
        catch (NoSuchElementException noSuchElementException) {
            return -1;
        }
    }

    @Override
    public int getLength() {
        int offset = this.getOffset();
        return offset == -1 ? -1 : this.getRightOffset() - offset;
    }

    @Override
    public int getRightOffset() {
        try {
            return this.last().getRightOffset();
        }
        catch (NoSuchElementException noSuchElementException) {
            return -1;
        }
    }

    @Override
    public IRep getRep() {
        return this.rep;
    }

    @Override
    public Comparator<? super IDesc> comparator() {
        return this.backingSet.comparator();
    }

    @Override
    public IDesc getDescription(long id) {
        IDesc d = (IDesc)this.idMap.get(id);
        return d != null && this.contains(d) ? d : null;
    }

    @Override
    public int compareTo(IDescSet o) {
        return RepUtils.compare(this.rep, o.getRep());
    }

    @Override
    public final int getImplementationCode() {
        return 6;
    }

    @Override
    public final String getImplementationName() {
        return IStoryElement.NAME_IDescriptionSet;
    }

    @Override
    public String getSerializedData() {
        return null;
    }

    public Object getAdapter(Class adapter) {
        return null;
    }

    @Override
    public boolean equals(IDescSet tgtDescs, IAlignedStoryModel model) {
        if (this == tgtDescs) {
            return true;
        }
        if (this.rep != tgtDescs.getRep()) {
            return false;
        }
        return Desc.equals(this, tgtDescs, model);
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    protected class DescSetIterator
    implements Iterator<IDesc> {
        protected Iterator<IDesc> itr;
        protected IDesc remove;
        protected IDesc next;

        protected DescSetIterator() {
            this.itr = DescSet.this.backingSet.iterator();
            this.remove = null;
            this.next = null;
        }

        @Override
        public IDesc next() {
            if (this.next == this.remove) {
                this.advance();
            }
            if (this.next == null) {
                throw new NoSuchElementException();
            }
            this.remove = this.next;
            return this.next;
        }

        @Override
        public boolean hasNext() {
            if (this.next == this.remove) {
                this.advance();
            }
            return this.next != null;
        }

        protected void advance() {
            this.next = null;
            while (this.itr.hasNext()) {
                IDesc p = this.itr.next();
                if (!DescSet.this.insideLowerBound(p)) continue;
                this.next = p;
                break;
            }
        }

        @Override
        public void remove() {
            if (this.remove == null) {
                throw new IllegalStateException();
            }
            if (this.next != this.remove) {
                this.itr = DescSet.this.backingSet.tailSet(this.remove).iterator();
                this.itr.next();
            }
            this.itr.remove();
            DescSet.this.idMap.remove(this.remove.getID());
            DescSet.this.elementRemoved(this.remove);
            this.advance();
            this.remove = null;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    protected class LimitDesc
    implements IDesc {
        private final int offset;
        private final int length;
        private final int rightOffset;
        private final long id;

        public LimitDesc(int limit, boolean open) {
            this.offset = open ? limit : limit + 1;
            this.length = 0;
            this.rightOffset = this.offset;
            this.id = open ? Long.MAX_VALUE : Long.MIN_VALUE;
        }

        public LimitDesc(IHasPosition match, boolean upper) {
            this.offset = match.getOffset();
            this.length = match.getLength();
            this.rightOffset = this.offset + this.length;
            this.id = upper ? Long.MAX_VALUE : Long.MIN_VALUE;
        }

        @Override
        public long getID() {
            return this.id;
        }

        @Override
        public IRep getRep() {
            return DescSet.this.rep;
        }

        @Override
        public int getLength() {
            return this.length;
        }

        @Override
        public int getOffset() {
            return this.offset;
        }

        @Override
        public int getRightOffset() {
            return this.rightOffset;
        }

        public boolean equals(Object obj) {
            return this == obj;
        }

        public Set<String> getChecks() {
            throw new UnsupportedOperationException();
        }

        @Override
        public IData getData() {
            throw new UnsupportedOperationException();
        }

        @Override
        public String getDataString() {
            throw new UnsupportedOperationException();
        }

        public SortedSet<ITiming> getTimings() {
            throw new UnsupportedOperationException();
        }

        public boolean isUserSpecified() {
            throw new UnsupportedOperationException();
        }

        @Override
        public int compareTo(IDesc o) {
            throw new UnsupportedOperationException();
        }

        @Override
        public IMetaDataMap getMetaData() {
            throw new UnsupportedOperationException();
        }

        @Override
        public boolean equals(IDesc tgtDesc, IAlignedStoryModel model) {
            throw new UnsupportedOperationException();
        }

        @Override
        public boolean equals(int offset, int length, IAlignedStoryModel model) {
            throw new UnsupportedOperationException();
        }
    }
}

