/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.swt.dnd;

import org.eclipse.swt.dnd.ClipboardProxy;
import org.eclipse.swt.dnd.DND;
import org.eclipse.swt.dnd.Transfer;
import org.eclipse.swt.dnd.TransferData;
import org.eclipse.swt.internal.Converter;
import org.eclipse.swt.internal.motif.OS;
import org.eclipse.swt.widgets.Display;

public class Clipboard {
    Display display;
    static /* synthetic */ Class class$0;

    public Clipboard(Display display) {
        this.checkSubclass();
        if (display == null && (display = Display.getCurrent()) == null) {
            display = Display.getDefault();
        }
        if (display.getThread() != Thread.currentThread()) {
            DND.error(22);
        }
        this.display = display;
    }

    protected void checkSubclass() {
        String validName;
        String name = this.getClass().getName();
        Class<?> clazz = class$0;
        if (clazz == null) {
            try {
                clazz = class$0 = Class.forName("org.eclipse.swt.dnd.Clipboard");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        if (!(validName = clazz.getName()).equals(name)) {
            DND.error(43);
        }
    }

    protected void checkWidget() {
        Display display = this.display;
        if (display == null) {
            DND.error(24);
        }
        if (display.getThread() != Thread.currentThread()) {
            DND.error(22);
        }
        if (display.isDisposed()) {
            DND.error(24);
        }
    }

    public void clearContents() {
        this.clearContents(1);
    }

    public void clearContents(int clipboards) {
        this.checkWidget();
        ClipboardProxy proxy = ClipboardProxy._getInstance(this.display);
        proxy.clear(this, clipboards);
    }

    public void dispose() {
        if (this.isDisposed()) {
            return;
        }
        if (this.display.getThread() != Thread.currentThread()) {
            DND.error(22);
        }
        this.display = null;
    }

    public Object getContents(Transfer transfer) {
        return this.getContents(transfer, 1);
    }

    public Object getContents(Transfer transfer, int clipboards) {
        this.checkWidget();
        if (transfer == null) {
            DND.error(4);
        }
        ClipboardProxy proxy = ClipboardProxy._getInstance(this.display);
        Object result = null;
        if ((clipboards & 1) != 0) {
            result = proxy.getContents(transfer, 1);
        }
        if (result != null) {
            return result;
        }
        if ((clipboards & 2) != 0) {
            result = proxy.getContents(transfer, 2);
        }
        return result;
    }

    public boolean isDisposed() {
        return this.display == null;
    }

    public TransferData[] getAvailableTypes() {
        return this.getAvailableTypes(1);
    }

    public TransferData[] getAvailableTypes(int clipboards) {
        this.checkWidget();
        ClipboardProxy proxy = ClipboardProxy._getInstance(this.display);
        int[] types = null;
        if ((clipboards & 1) != 0) {
            types = proxy.getAvailableTypes(1);
        }
        if ((clipboards & 2) != 0) {
            int[] primaryTypes = proxy.getAvailableTypes(2);
            if (types == null) {
                types = primaryTypes;
            } else {
                int[] newTypes = new int[types.length + primaryTypes.length];
                System.arraycopy(types, 0, newTypes, 0, types.length);
                System.arraycopy(primaryTypes, 0, newTypes, types.length, primaryTypes.length);
                types = newTypes;
            }
        }
        if (types == null) {
            return new TransferData[0];
        }
        TransferData[] result = new TransferData[types.length];
        int i = 0;
        while (i < types.length) {
            result[i] = new TransferData();
            result[i].type = types[i];
            ++i;
        }
        return result;
    }

    public String[] getAvailableTypeNames() {
        String name;
        byte[] nameBuf;
        int length;
        int ptr;
        this.checkWidget();
        ClipboardProxy proxy = ClipboardProxy._getInstance(this.display);
        int[] types = proxy.getAvailableTypes(1);
        int[] primaryTypes = proxy.getAvailableTypes(2);
        String[] names = new String[types.length + primaryTypes.length];
        int index = 0;
        int xDisplay = this.display.xDisplay;
        int i = 0;
        while (i < types.length) {
            ptr = OS.XmGetAtomName(xDisplay, types[i]);
            length = OS.strlen(ptr);
            nameBuf = new byte[length];
            OS.memmove(nameBuf, ptr, length);
            OS.XtFree(ptr);
            name = new String(Converter.mbcsToWcs(null, nameBuf));
            names[index++] = "CLIPBOARD " + name;
            ++i;
        }
        i = 0;
        while (i < primaryTypes.length) {
            ptr = OS.XmGetAtomName(xDisplay, primaryTypes[i]);
            length = OS.strlen(ptr);
            nameBuf = new byte[length];
            OS.memmove(nameBuf, ptr, length);
            OS.XtFree(ptr);
            name = new String(Converter.mbcsToWcs(null, nameBuf));
            names[index++] = "PRIMARY " + name;
            ++i;
        }
        return names;
    }

    public void setContents(Object[] data, Transfer[] dataTypes) {
        this.setContents(data, dataTypes, 1);
    }

    public void setContents(Object[] data, Transfer[] dataTypes, int clipboards) {
        this.checkWidget();
        if (data == null || dataTypes == null || data.length != dataTypes.length || data.length == 0) {
            DND.error(5);
        }
        int i = 0;
        while (i < data.length) {
            if (data[i] == null || dataTypes[i] == null || !dataTypes[i].validate(data[i])) {
                DND.error(5);
            }
            ++i;
        }
        ClipboardProxy proxy = ClipboardProxy._getInstance(this.display);
        proxy.setContents(this, data, dataTypes, clipboards);
    }
}

