/*
 * Decompiled with CFR 0.152.
 */
package edu.mit.semantics.ui.label;

import edu.mit.discourse.ui.DiscourseUIPlugin;
import edu.mit.semantics.core.rep.event.Aspect;
import edu.mit.semantics.core.rep.event.EventClass;
import edu.mit.semantics.core.rep.event.EventRep;
import edu.mit.semantics.core.rep.event.IEvent;
import edu.mit.semantics.core.rep.event.POS;
import edu.mit.semantics.core.rep.event.Tense;
import edu.mit.semantics.ui.SemanticsUIPlugin;
import edu.mit.story.core.desc.IDesc;
import edu.mit.story.core.desc.ISegment;
import edu.mit.story.core.desc.ISegmentSet;
import edu.mit.story.core.rep.IHasRep;
import edu.mit.story.ui.editor.IStoryEditor;
import edu.mit.story.ui.label.StoryModelLabelProvider;
import org.eclipse.jface.viewers.StyledString;
import org.eclipse.swt.graphics.Image;

public class EventLabelProvider
extends StoryModelLabelProvider {
    protected Image eventImg;
    protected Image headImg;
    protected Image featImg;
    protected Image polImg;
    protected Image cardImg;
    protected Image modeImg;

    public EventLabelProvider(IStoryEditor editor) {
        super(editor);
    }

    public StyledString getStyledText(Object element) {
        long id = -1L;
        IDesc desc = null;
        if (element instanceof IDesc && EventRep.getInstance().isType((IHasRep)((IDesc)element))) {
            desc = (IDesc)element;
            id = desc.getID();
            element = desc.getData();
        }
        if (element instanceof IEvent) {
            IEvent e = (IEvent)element;
            StyledString result = new StyledString();
            result.append(e.getEventTokens().getDisplayText());
            result = EventLabelProvider.appendID((StyledString)result, (long)id);
            return desc == null ? result : EventLabelProvider.appendMergeTags((StyledString)result, (IDesc)desc);
        }
        return super.getStyledText(element);
    }

    protected StyledString getStyledText(int type, Object parent, Object element) {
        IDesc desc = null;
        IEvent event = null;
        if (parent instanceof IDesc) {
            desc = (IDesc)parent;
            event = (IEvent)desc.getData();
        }
        if (event != null && type == 3) {
            StyledString result = new StyledString();
            if (event.getPolarityTokens() != null) {
                result.append(event.getPolarityTokens().getDisplayText());
                result.append(" : ", StyledString.DECORATIONS_STYLER);
            }
            result.append(Boolean.toString(event.getPolarity()));
            result.append(" (polarity)", StyledString.DECORATIONS_STYLER);
            return result;
        }
        if (event != null && type == 2) {
            String numStr;
            int num = event.getCardinality();
            String string = numStr = num == 0 ? "Unknown (0)" : Integer.toString(num);
            if (event.getCardinalityTokens() == null) {
                StyledString result = new StyledString();
                result.append(numStr);
                result.append(" (cardinality)", StyledString.DECORATIONS_STYLER);
                return result;
            }
            StyledString result = new StyledString();
            result.append(event.getCardinalityTokens().getDisplayText());
            result.append(" (cardinality of ", StyledString.DECORATIONS_STYLER);
            result.append(numStr);
            result.append(")", StyledString.DECORATIONS_STYLER);
            return result;
        }
        if (type == 1 && element instanceof ISegmentSet) {
            ISegmentSet head = (ISegmentSet)element;
            StyledString result = new StyledString();
            result.append(head.getDisplayText());
            result.append(" (head)", StyledString.DECORATIONS_STYLER);
            return result;
        }
        if (type == 4 && element instanceof ISegment) {
            ISegment mode = (ISegment)element;
            StyledString result = new StyledString();
            result.append(mode.getDisplayText());
            result.append(" (modality)", StyledString.DECORATIONS_STYLER);
            return result;
        }
        if (type == 5) {
            if (element instanceof EventClass) {
                EventClass ec = (EventClass)element;
                StyledString result = new StyledString();
                result.append(ec.getName());
                result.append(" (event class)", StyledString.DECORATIONS_STYLER);
                return result;
            }
            if (element instanceof POS) {
                POS pos = (POS)element;
                StyledString result = new StyledString();
                result.append(pos.getName());
                result.append(" (part of speech)", StyledString.DECORATIONS_STYLER);
                return result;
            }
            if (element instanceof Tense) {
                Tense t = (Tense)element;
                StyledString result = new StyledString();
                result.append(t.getName());
                result.append(" (tense)", StyledString.DECORATIONS_STYLER);
                return result;
            }
            if (element instanceof Aspect) {
                Aspect a = (Aspect)element;
                StyledString result = new StyledString();
                result.append(a.getName());
                result.append(" (aspect)", StyledString.DECORATIONS_STYLER);
                return result;
            }
        }
        return super.getStyledText(type, parent, element);
    }

    public Image getImage(Object element) {
        if (element instanceof IDesc && EventRep.getInstance().isType((IHasRep)((IDesc)element))) {
            return this.getEventImage();
        }
        if (element instanceof IEvent) {
            return this.getEventImage();
        }
        return super.getImage(element);
    }

    protected Image getImage(int type, Object parent, Object element) {
        switch (type) {
            case 1: {
                return this.getHeadImage();
            }
            case 4: {
                return this.getModalityImage();
            }
            case 3: {
                return this.getPolarityImage();
            }
            case 2: {
                return this.getCardinalityImage();
            }
            case 5: {
                return this.getFeatureImage();
            }
        }
        return super.getImage(type, parent, element);
    }

    public Image getEventImage() {
        if (this.eventImg == null) {
            this.eventImg = SemanticsUIPlugin.getDefault().getImageRegistry().get("obj16/event.gif");
        }
        return this.eventImg;
    }

    public Image getHeadImage() {
        if (this.headImg == null) {
            this.headImg = SemanticsUIPlugin.getDefault().getImageRegistry().get("obj16/head.gif");
        }
        return this.headImg;
    }

    public Image getFeatureImage() {
        if (this.featImg == null) {
            this.featImg = DiscourseUIPlugin.getDefault().getImageRegistry().get("obj16/property.gif");
        }
        return this.featImg;
    }

    public Image getPolarityImage() {
        if (this.polImg == null) {
            this.polImg = SemanticsUIPlugin.getDefault().getImageRegistry().get("obj16/polarity.gif");
        }
        return this.polImg;
    }

    public Image getCardinalityImage() {
        if (this.cardImg == null) {
            this.cardImg = SemanticsUIPlugin.getDefault().getImageRegistry().get("obj16/cardinality.gif");
        }
        return this.cardImg;
    }

    public Image getModalityImage() {
        if (this.modeImg == null) {
            this.modeImg = SemanticsUIPlugin.getDefault().getImageRegistry().get("obj16/modality.gif");
        }
        return this.modeImg;
    }
}

