/*
 * Decompiled with CFR 0.152.
 */
package edu.mit.semantics.core.propbank;

import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.OutputStreamWriter;

public class FrameFileGenerator {
    public static void main(String[] args) throws IOException {
        File frameDir = FrameFileGenerator.getFrameDir();
        File outputFile = FrameFileGenerator.getFrameFile();
        if (outputFile.exists()) {
            outputFile.delete();
        }
        outputFile.createNewFile();
        BufferedWriter writer = new BufferedWriter(new OutputStreamWriter(new FileOutputStream(outputFile)));
        String headerLine = "<!DOCTYPE";
        String openingTag = "<frameset>";
        String closingTag = "</frameset>";
        String xmlSuffix = ".xml";
        writer.write("<?xml version=\"1.0\"?>\n");
        writer.write(String.valueOf(openingTag) + '\n');
        File[] fileArray = frameDir.listFiles();
        int n = fileArray.length;
        int n2 = 0;
        while (n2 < n) {
            File file = fileArray[n2];
            if (file.getName().endsWith(xmlSuffix)) {
                String line;
                System.out.println(file.getName());
                BufferedReader reader = new BufferedReader(new InputStreamReader(new FileInputStream(file)));
                while ((line = reader.readLine()) != null) {
                    if ((line = line.trim()).startsWith(headerLine) || line.startsWith(openingTag) || line.startsWith(closingTag)) continue;
                    writer.write(line);
                    writer.write(10);
                }
                reader.close();
            }
            ++n2;
        }
        writer.write(String.valueOf(closingTag) + '\n');
        writer.flush();
        writer.close();
    }

    public static File getFrameDir() {
        File thisProject = new File(System.getProperty("user.dir"));
        File pluginsWorkspace = thisProject.getParentFile();
        File workspacesFolder = pluginsWorkspace.getParentFile();
        File projectsWorkspace = new File(workspacesFolder, "Projects Workspace");
        File propbankProject = new File(projectsWorkspace, "edu.upenn.propbank");
        File dataFolder = new File(propbankProject, "data");
        return new File(dataFolder, "frames");
    }

    public static File getFrameFile() {
        File thisProject = new File(System.getProperty("user.dir"));
        File dataDir = new File(thisProject, "data");
        return new File(dataDir, "frames.xml");
    }
}

