/*
 * Decompiled with CFR 0.152.
 */
package edu.stanford.nlp.trees.tregex;

import edu.stanford.nlp.process.Function;
import edu.stanford.nlp.trees.Tree;
import edu.stanford.nlp.trees.tregex.Relation;
import edu.stanford.nlp.trees.tregex.TregexMatcher;
import edu.stanford.nlp.trees.tregex.TregexPattern;
import edu.stanford.nlp.trees.tregex.VariableStrings;
import edu.stanford.nlp.util.Pair;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
class DescriptionPattern
extends TregexPattern {
    private Relation rel;
    private boolean negDesc;
    private Pattern descPattern;
    private String stringDesc;
    private Object name;
    private boolean isLink;
    private TregexPattern child;
    private List<Pair<Integer, String>> variableGroups;
    private Function<String, String> basicCatFunction;

    public DescriptionPattern(Relation rel, boolean negDesc, String desc, Object name, boolean useBasicCat) {
        this(rel, negDesc, desc, name, useBasicCat, new ArrayList(0));
    }

    public DescriptionPattern(Relation rel, boolean negDesc, String desc, Object name, boolean useBasicCat, List varGroups) {
        this(rel, negDesc, desc, name, useBasicCat, false, varGroups);
    }

    public DescriptionPattern(Relation rel, boolean negDesc, String desc, Object name, boolean useBasicCat, boolean ignoreCase, List variableGroups) {
        this.rel = rel;
        this.negDesc = negDesc;
        if (desc != null) {
            this.stringDesc = desc;
            this.descPattern = desc.equals("__") ? Pattern.compile(".*") : (desc.matches("/.*/") ? Pattern.compile(desc.substring(1, desc.length() - 1)) : Pattern.compile("^(" + desc + ")$"));
        } else {
            assert (name != null);
            this.stringDesc = " ";
            this.descPattern = null;
        }
        this.name = name;
        this.child = null;
        this.basicCatFunction = useBasicCat ? currentBasicCatFunction : null;
        this.variableGroups = variableGroups;
    }

    public void makeLink() {
        this.isLink = true;
    }

    @Override
    public String localString() {
        return this.rel.toString() + ' ' + (this.negDesc ? "!" : "") + (this.basicCatFunction != null ? "@" : "") + this.stringDesc + (this.name == null ? "" : '=' + this.name.toString());
    }

    @Override
    public String toString() {
        StringBuffer sb = new StringBuffer();
        if (this.isNegated()) {
            sb.append('!');
        }
        if (this.isOptional()) {
            sb.append('?');
        }
        sb.append(this.rel.toString());
        sb.append(' ');
        if (this.child != null) {
            sb.append('(');
        }
        if (this.negDesc) {
            sb.append('!');
        }
        if (this.basicCatFunction != null) {
            sb.append("@");
        }
        sb.append(this.stringDesc);
        if (this.name != null) {
            sb.append("=" + this.name.toString());
        }
        sb.append(' ');
        if (this.child != null) {
            sb.append(this.child.toString());
            sb.append(')');
        }
        return sb.toString();
    }

    public void setChild(TregexPattern n) {
        this.child = n;
    }

    @Override
    public List getChildren() {
        if (this.child == null) {
            return Collections.EMPTY_LIST;
        }
        return Collections.singletonList(this.child);
    }

    @Override
    public TregexMatcher matcher(Tree root, Tree tree, Map<Object, Tree> namesToNodes, VariableStrings variableStrings) {
        return new DescriptionMatcher(this, root, tree, namesToNodes, variableStrings);
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class DescriptionMatcher
    extends TregexMatcher {
        private Iterator treeNodeMatchCandidateIterator = null;
        private final DescriptionPattern myNode;
        private TregexMatcher childMatcher;
        private Tree nextTreeNodeMatchCandidate;
        private boolean finished = false;
        private boolean matchedOnce = false;
        private boolean committedVariables = false;

        public DescriptionMatcher(DescriptionPattern n, Tree root, Tree tree, Map<Object, Tree> namesToNodes, VariableStrings variableStrings) {
            super(root, tree, namesToNodes, variableStrings);
            this.myNode = n;
            this.resetChildIter();
        }

        @Override
        void resetChildIter() {
            this.treeNodeMatchCandidateIterator = this.myNode.rel.searchNodeIterator(this.tree, this.root);
            this.finished = false;
            this.nextTreeNodeMatchCandidate = null;
        }

        private void resetChild() {
            if (this.childMatcher == null) {
                if (this.myNode.child == null) {
                    this.matchedOnce = false;
                } else {
                    this.childMatcher = this.myNode.child.matcher(this.root, this.nextTreeNodeMatchCandidate, this.namesToNodes, this.variableStrings);
                }
            } else {
                this.childMatcher.resetChildIter(this.nextTreeNodeMatchCandidate);
            }
        }

        private void goToNextTreeNodeMatch() {
            this.decommitVariableGroups();
            this.finished = true;
            Matcher m = null;
            while (this.treeNodeMatchCandidateIterator.hasNext()) {
                this.nextTreeNodeMatchCandidate = (Tree)this.treeNodeMatchCandidateIterator.next();
                if (this.myNode.descPattern == null) {
                    if (this.myNode.isLink) {
                        String myValue;
                        String otherValue;
                        Tree otherTree = (Tree)this.namesToNodes.get(this.myNode.name);
                        if (otherTree == null || !(otherValue = this.myNode.basicCatFunction == null ? otherTree.value() : (String)this.myNode.basicCatFunction.apply(otherTree.value())).equals(myValue = this.myNode.basicCatFunction == null ? this.nextTreeNodeMatchCandidate.value() : (String)this.myNode.basicCatFunction.apply(this.nextTreeNodeMatchCandidate.value()))) continue;
                        this.finished = false;
                        break;
                    }
                    if (this.namesToNodes.get(this.myNode.name) != this.nextTreeNodeMatchCandidate) continue;
                    this.finished = false;
                    break;
                }
                String value = this.myNode.basicCatFunction == null ? this.nextTreeNodeMatchCandidate.value() : (String)this.myNode.basicCatFunction.apply(this.nextTreeNodeMatchCandidate.value());
                m = this.myNode.descPattern.matcher(value);
                boolean found = m.find();
                if (found) {
                    for (Pair varGroup : this.myNode.variableGroups) {
                        String thisVariable = (String)varGroup.second();
                        String thisVarString = this.variableStrings.getString(thisVariable);
                        if (thisVarString == null || thisVarString.equals(m.group((Integer)varGroup.first()))) continue;
                        found = false;
                        break;
                    }
                }
                if (found == this.myNode.negDesc) continue;
                this.finished = false;
                break;
            }
            if (!this.finished) {
                this.resetChild();
                if (this.myNode.name != null) {
                    this.namesToNodes.put(this.myNode.name, this.nextTreeNodeMatchCandidate);
                }
                this.commitVariableGroups(m);
            }
        }

        private void commitVariableGroups(Matcher m) {
            this.committedVariables = true;
            for (Pair varGroup : this.myNode.variableGroups) {
                String thisVarString = m.group((Integer)varGroup.first());
                this.variableStrings.setVar(varGroup.second(), thisVarString);
            }
        }

        private void decommitVariableGroups() {
            if (this.committedVariables) {
                for (Pair varGroup : this.myNode.variableGroups) {
                    this.variableStrings.unsetVar(varGroup.second());
                }
            }
            this.committedVariables = false;
        }

        private boolean matchChild() {
            if (this.nextTreeNodeMatchCandidate == null) {
                return false;
            }
            if (this.childMatcher == null) {
                if (!this.matchedOnce) {
                    this.matchedOnce = true;
                    return true;
                }
                return false;
            }
            return this.childMatcher.matches();
        }

        @Override
        public boolean matches() {
            if (this.finished) {
                return false;
            }
            while (!this.finished) {
                if (this.matchChild()) {
                    if (this.myNode.isNegated()) {
                        this.finished = true;
                        return false;
                    }
                    if (this.myNode.isOptional()) {
                        this.finished = true;
                    }
                    return true;
                }
                this.goToNextTreeNodeMatch();
            }
            if (this.myNode.isNegated()) {
                return true;
            }
            this.nextTreeNodeMatchCandidate = null;
            if (this.myNode.name != null) {
                this.namesToNodes.remove(this.myNode.name);
            }
            return this.myNode.isOptional();
        }

        @Override
        public Tree getMatch() {
            return this.nextTreeNodeMatchCandidate;
        }
    }
}

