/*
 * Decompiled with CFR 0.152.
 */
package edu.stanford.nlp.trees.international.pennchinese;

import edu.stanford.nlp.io.NumberRangesFileFilter;
import edu.stanford.nlp.parser.lexparser.ChineseTreebankParserParams;
import edu.stanford.nlp.parser.lexparser.LexicalizedParser;
import edu.stanford.nlp.parser.lexparser.Options;
import edu.stanford.nlp.parser.lexparser.Test;
import edu.stanford.nlp.trees.BobChrisTreeNormalizer;
import edu.stanford.nlp.trees.MemoryTreebank;
import edu.stanford.nlp.trees.Tree;
import edu.stanford.nlp.trees.TreeFactory;
import edu.stanford.nlp.trees.TreeTransformer;
import edu.stanford.nlp.trees.Treebank;
import edu.stanford.nlp.trees.TreebankLanguagePack;
import edu.stanford.nlp.trees.WordCatEqualityChecker;
import edu.stanford.nlp.trees.WordCatEquivalenceClasser;
import edu.stanford.nlp.trees.international.pennchinese.ChineseTreebankLanguagePack;
import edu.stanford.nlp.util.EquivalenceClassEval;
import edu.stanford.nlp.util.EquivalenceClasser;
import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileFilter;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.ObjectOutputStream;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.PrintWriter;
import java.io.Writer;
import java.util.ArrayList;
import java.util.Collections;
import java.util.zip.GZIPOutputStream;

public class CharacterLevelTagExtender
extends BobChrisTreeNormalizer
implements TreeTransformer {
    private static final boolean useTwoCharTags = false;

    public CharacterLevelTagExtender() {
        super(new ChineseTreebankLanguagePack());
    }

    public CharacterLevelTagExtender(TreebankLanguagePack tlp) {
        super(tlp);
    }

    public Tree normalizeWholeTree(Tree tree, TreeFactory tf) {
        return this.transformTree(super.normalizeWholeTree(tree, tf));
    }

    public Tree transformTree(Tree tree) {
        TreeFactory tf = tree.treeFactory();
        String tag = tree.label().value();
        if (tree.isPreTerminal()) {
            String word = tree.firstChild().label().value();
            ArrayList<Tree> newPreterms = new ArrayList<Tree>();
            int size = word.length();
            for (int i = 0; i < size; ++i) {
                String singleCharLabel = new String(new char[]{word.charAt(i)});
                Tree newLeaf = tf.newLeaf(singleCharLabel);
                String suffix = word.length() == 1 ? "_S" : (i == 0 ? "_B" : (i == word.length() - 1 ? "_E" : "_M"));
                newPreterms.add(tf.newTreeNode(tag + suffix, Collections.singletonList(newLeaf)));
            }
            return tf.newTreeNode(tag, newPreterms);
        }
        ArrayList<Tree> newChildren = new ArrayList<Tree>();
        for (int i = 0; i < tree.children().length; ++i) {
            Tree child = tree.children()[i];
            newChildren.add(this.transformTree(child));
        }
        return tf.newTreeNode(tag, newChildren);
    }

    public Tree untransformTree(Tree tree) {
        TreeFactory tf = tree.treeFactory();
        if (tree.isPrePreTerminal()) {
            if (tree.firstChild().label().value().matches(".*_.")) {
                StringBuffer word = new StringBuffer();
                for (int i = 0; i < tree.children().length; ++i) {
                    Tree child = tree.children()[i];
                    word.append(child.firstChild().label().value());
                }
                Tree newChild = tf.newLeaf(word.toString());
                tree.setChildren(Collections.singletonList(newChild));
            }
        } else {
            for (int i = 0; i < tree.children().length; ++i) {
                Tree child = tree.children()[i];
                this.untransformTree(child);
            }
        }
        return tree;
    }

    private static void testTransAndUntrans(CharacterLevelTagExtender e, Treebank tb, PrintWriter pw) {
        for (Tree tree : tb) {
            Tree oldTree = tree.deepCopy();
            e.transformTree(tree);
            e.untransformTree(tree);
            if (tree.equals(oldTree)) continue;
            pw.println("NOT EQUAL AFTER UNTRANSFORMATION!!!");
            pw.println();
            oldTree.pennPrint(pw);
            pw.println();
            tree.pennPrint(pw);
            pw.println("------------------");
        }
    }

    public static void main(String[] args) throws IOException {
        LexicalizedParser lp;
        if (args.length != 3) {
            throw new RuntimeException("args: treebankPath trainNums testNums");
        }
        ChineseTreebankParserParams ctpp = new ChineseTreebankParserParams();
        ctpp.charTags = true;
        Options op = new Options(ctpp);
        op.doDep = false;
        try {
            NumberRangesFileFilter trainFilt = new NumberRangesFileFilter(args[1], false);
            lp = new LexicalizedParser(args[0], trainFilt, op);
            try {
                String filename = "chineseCharTagPCFG.ser.gz";
                System.err.println("Writing parser in serialized format to file " + filename + " ");
                System.err.flush();
                ObjectOutputStream out2 = filename.endsWith(".gz") ? new ObjectOutputStream(new BufferedOutputStream(new GZIPOutputStream(new FileOutputStream(filename)))) : new ObjectOutputStream(new BufferedOutputStream(new FileOutputStream(filename)));
                out2.writeObject(lp.parserData());
                out2.close();
                System.err.println("done.");
            }
            catch (IOException ioe) {
                ioe.printStackTrace();
            }
        }
        catch (IllegalArgumentException e) {
            lp = new LexicalizedParser(args[1], op);
        }
        Test.maxLength = 90;
        NumberRangesFileFilter testFilt = new NumberRangesFileFilter(args[2], false);
        MemoryTreebank testTreebank = ctpp.memoryTreebank();
        testTreebank.loadPath(new File(args[0]), (FileFilter)testFilt);
        PrintWriter pw = new PrintWriter((Writer)new OutputStreamWriter((OutputStream)new FileOutputStream("out.chi"), "GB18030"), true);
        WordCatEquivalenceClasser eqclass = new WordCatEquivalenceClasser();
        WordCatEqualityChecker eqcheck = new WordCatEqualityChecker();
        EquivalenceClassEval eval = new EquivalenceClassEval((EquivalenceClasser)eqclass, eqcheck);
        System.out.println("Testing...");
        for (Tree gold : testTreebank) {
            try {
                lp.parse(gold.yield());
            }
            catch (Exception e) {
                e.printStackTrace();
                continue;
            }
            gold = gold.firstChild();
            pw.println(gold.preTerminalYield());
            pw.println(gold.yield());
            gold.pennPrint(pw);
            Tree tree = lp.getBestParse();
            pw.println(tree.preTerminalYield());
            pw.println(tree.yield());
            tree.pennPrint(pw);
            eval.displayLast();
        }
        System.out.println();
        System.out.println();
        eval.display();
    }
}

