/*
 * Decompiled with CFR 0.152.
 */
package edu.stanford.nlp.trees;

import edu.stanford.nlp.ling.AbstractMapLabel;
import edu.stanford.nlp.ling.HasTag;
import edu.stanford.nlp.ling.HasWord;
import edu.stanford.nlp.ling.Label;
import edu.stanford.nlp.ling.MapLabel;
import edu.stanford.nlp.ling.Sentence;
import edu.stanford.nlp.ling.StringLabel;
import edu.stanford.nlp.ling.StringLabelFactory;
import edu.stanford.nlp.ling.TaggedWord;
import edu.stanford.nlp.parser.lexparser.TreebankLangParserParams;
import edu.stanford.nlp.process.Function;
import edu.stanford.nlp.trees.CollinsHeadFinder;
import edu.stanford.nlp.trees.CollocationFinder;
import edu.stanford.nlp.trees.Dependency;
import edu.stanford.nlp.trees.DiskTreebank;
import edu.stanford.nlp.trees.GrammaticalStructure;
import edu.stanford.nlp.trees.GrammaticalStructureFactory;
import edu.stanford.nlp.trees.HeadFinder;
import edu.stanford.nlp.trees.LabeledScoredTreeFactory;
import edu.stanford.nlp.trees.PennTreeReader;
import edu.stanford.nlp.trees.PennTreebankLanguagePack;
import edu.stanford.nlp.trees.Tree;
import edu.stanford.nlp.trees.TreeFunctions;
import edu.stanford.nlp.trees.TreeNormalizer;
import edu.stanford.nlp.trees.TreeReader;
import edu.stanford.nlp.trees.TreeReaderFactory;
import edu.stanford.nlp.trees.TreeTransformer;
import edu.stanford.nlp.trees.TreebankLanguagePack;
import edu.stanford.nlp.trees.TypedDependency;
import edu.stanford.nlp.trees.WordNetConnection;
import edu.stanford.nlp.trees.WordStemmer;
import edu.stanford.nlp.trees.international.pennchinese.ChineseEnglishWordMap;
import edu.stanford.nlp.util.Filter;
import edu.stanford.nlp.util.Filters;
import edu.stanford.nlp.util.StringUtils;
import java.io.BufferedReader;
import java.io.InputStreamReader;
import java.io.PrintWriter;
import java.io.Reader;
import java.util.AbstractCollection;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.Set;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class TreePrint {
    public static final String rootLabelOnlyFormat = "rootSymbolOnly";
    public static final String[] outputTreeFormats = new String[]{"penn", "oneline", "rootSymbolOnly", "words", "wordsAndTags", "dependencies", "typedDependencies", "typedDependenciesCollapsed", "latexTree", "collocations"};
    public static final String headMark = "=H";
    private Properties formats;
    private Properties options;
    private boolean markHeadNodes = false;
    private boolean lexicalize = false;
    private boolean stem = false;
    private boolean transChinese = false;
    private HeadFinder hf;
    private TreebankLanguagePack tlp;
    private WordStemmer stemmer;
    private Filter<Dependency> dependencyFilter;
    private GrammaticalStructureFactory gsf;
    private PrintWriter pw = new PrintWriter(System.out, true);

    public TreePrint(String formats) {
        this(formats, "", new PennTreebankLanguagePack());
    }

    public TreePrint(String formats, TreebankLanguagePack tlp) {
        this(formats, "", tlp);
    }

    public TreePrint(String formats, String options, TreebankLanguagePack tlp) {
        this(formats, options, tlp, new CollinsHeadFinder());
    }

    public TreePrint(String formatString, String optionsString, TreebankLanguagePack tlp, HeadFinder hf) {
        Filter<String> puncWordFilter;
        this.formats = StringUtils.stringToProperties(formatString);
        this.options = StringUtils.stringToProperties(optionsString);
        List<String> okOutputs = Arrays.asList(outputTreeFormats);
        for (Object formObj : this.formats.keySet()) {
            String format = (String)formObj;
            if (okOutputs.contains(format)) continue;
            throw new RuntimeException("Error: output tree format " + format + " not supported");
        }
        this.setHeadFinder(hf);
        this.tlp = tlp;
        boolean includePunctuationDependencies = TreePrint.propertyToBoolean(this.options, "includePunctuationDependencies");
        if (includePunctuationDependencies) {
            this.dependencyFilter = Filters.acceptFilter();
            puncWordFilter = Filters.acceptFilter();
        } else {
            this.dependencyFilter = new DependencyRejectFilter(tlp.punctuationTagRejectFilter());
            puncWordFilter = tlp.punctuationWordRejectFilter();
        }
        this.stem = TreePrint.propertyToBoolean(this.options, "stem");
        if (this.stem) {
            this.stemmer = new WordStemmer();
        }
        if (this.formats.containsKey("typedDependenciesCollapsed") || this.formats.containsKey("typedDependencies")) {
            this.gsf = tlp.grammaticalStructureFactory(puncWordFilter);
        }
        this.lexicalize = TreePrint.propertyToBoolean(this.options, "lexicalize");
        this.markHeadNodes = TreePrint.propertyToBoolean(this.options, "markHeadNodes");
        this.transChinese = TreePrint.propertyToBoolean(this.options, "transChinese");
    }

    private static boolean propertyToBoolean(Properties prop, String key) {
        String val = prop.getProperty(key);
        if (val == null) {
            return false;
        }
        if ((val = val.trim()).equals("")) {
            return true;
        }
        if (val.equalsIgnoreCase("true")) {
            return true;
        }
        if (val.equalsIgnoreCase("false")) {
            return false;
        }
        throw new RuntimeException("Property " + key + " should have a boolean value but it's " + val);
    }

    public void printTree(Tree t) {
        this.printTree(t, this.pw);
    }

    public void printTree(Tree t, PrintWriter pw) {
        this.printTree(t, "", pw);
    }

    public void printTree(Tree t, String id, PrintWriter pw) {
        ArrayList<Dependency> sortedDeps;
        Function<Tree, Tree> a;
        String s;
        if (t == null) {
            if (TreePrint.propertyToBoolean(this.options, "xml")) {
                pw.print("<s");
                if (id != null && !"".equals(id)) {
                    pw.print(" id=\"" + id + "\"");
                }
                pw.println(" skipped=\"true\"/>");
                pw.println();
            } else {
                pw.println("SENTENCE_SKIPPED_OR_UNPARSABLE");
            }
            return;
        }
        Tree outputTree = t;
        if (TreePrint.propertyToBoolean(this.options, "xml")) {
            Sentence sentUnstemmed = outputTree.yield();
            pw.print("<s");
            if (id != null && !"".equals(id)) {
                pw.print(" id=\"" + id + "\"");
            }
            pw.println(">");
            if (this.formats.containsKey("words")) {
                pw.println("  <words>");
                int i = 1;
                for (HasWord w : sentUnstemmed) {
                    pw.println("    <word ind=\"" + i + "\">" + w + "</word>");
                    ++i;
                }
                pw.println("  </words>");
            }
        } else if (this.formats.containsKey("words")) {
            pw.println(outputTree.yield().toString(false));
            pw.println();
        }
        if (TreePrint.propertyToBoolean(this.options, "removeTopBracket") && this.tlp.isStartSymbol(s = outputTree.label().value())) {
            if (outputTree.isUnaryRewrite()) {
                outputTree = outputTree.firstChild();
            } else {
                System.err.println("TreePrint: can't remove top bracket: not unary");
            }
        }
        if (this.stem) {
            this.stemmer.visitTree(outputTree);
        }
        if (this.lexicalize) {
            a = TreeFunctions.getLabeledTreeToCategoryWordTagTreeFunction();
            outputTree = a.apply(outputTree);
            outputTree.percolateHeads(this.hf);
        }
        if (this.formats.containsKey("collocations")) {
            try {
                Class<?> cl = Class.forName("edu.stanford.nlp.trees.WordNetInstance");
                WordNetConnection wn = (WordNetConnection)cl.newInstance();
                CollocationFinder cf = new CollocationFinder(outputTree, wn, this.hf);
                outputTree = cf.getMangledTree();
            }
            catch (Exception e) {
                e.printStackTrace();
                System.err.println("Couldn't open WordNet Connection.  Aborting collocation detection.");
            }
        }
        if (!this.lexicalize) {
            a = TreeFunctions.getLabeledTreeToStringLabeledTreeFunction();
            outputTree = a.apply(outputTree);
        }
        Tree outputPSTree = outputTree;
        if (this.markHeadNodes) {
            outputPSTree = this.markHeadNodes(outputPSTree);
        }
        if (this.transChinese) {
            TreeTransformer tt = new TreeTransformer(){

                public Tree transformTree(Tree t) {
                    t = t.deepCopy();
                    for (Tree subtree : t) {
                        if (!subtree.isLeaf()) continue;
                        Label oldLabel = subtree.label();
                        String translation = ChineseEnglishWordMap.getStaticMap().getFirstTranslation(oldLabel.value());
                        if (translation == null) {
                            translation = "[UNK]";
                        }
                        StringLabel newLabel = new StringLabel(oldLabel.value() + ":" + translation);
                        subtree.setLabel(newLabel);
                    }
                    return t;
                }
            };
            outputPSTree = tt.transformTree(outputPSTree);
        }
        if (TreePrint.propertyToBoolean(this.options, "xml")) {
            if (this.formats.containsKey("wordsAndTags")) {
                Sentence sent = outputTree.taggedYield();
                pw.println("  <words pos=\"true\">");
                int i = 1;
                for (TaggedWord tw : sent) {
                    pw.println("    <word ind=\"" + i + "\" pos=\"" + tw.tag() + "\">" + tw.word() + "</word>");
                    ++i;
                }
                pw.println("  </words>");
            }
            if (this.formats.containsKey("penn")) {
                pw.println("  <tree style=\"penn\">");
                outputPSTree.pennPrint(pw);
                pw.println("  </tree>");
            }
            if (this.formats.containsKey("latexTree")) {
                pw.println("    <tree style=\"latexTrees\">");
                pw.println(".[");
                outputTree.indentedListPrint(pw, false);
                pw.println(".]");
                pw.println("  </tree>");
            }
            if (this.formats.containsKey("dependencies")) {
                Tree indexedTree = outputTree.deeperCopy(outputTree.treeFactory(), MapLabel.factory());
                indexedTree.indexLeaves();
                Set<Dependency> depsSet = indexedTree.mapDependencies(this.dependencyFilter, this.hf);
                sortedDeps = new ArrayList<Dependency>(depsSet);
                Collections.sort(sortedDeps, ComparatorHolder.dc);
                pw.println("<dependencies style=\"untyped\">");
                for (Dependency d : sortedDeps) {
                    pw.println(d.toString("xml"));
                }
                pw.println("</dependencies>");
            }
            if (this.formats.containsKey("typedDependencies")) {
                GrammaticalStructure gs = this.gsf.newGrammaticalStructure(outputTree);
                TreePrint.print(gs.typedDependencies(), "xml", pw);
            }
            if (this.formats.containsKey("typedDependenciesCollapsed")) {
                GrammaticalStructure gs = this.gsf.newGrammaticalStructure(outputTree);
                TreePrint.print(gs.typedDependenciesCollapsed(), "xml", pw);
            }
            pw.println("</s>");
            pw.println();
        } else {
            if (this.formats.containsKey("wordsAndTags")) {
                pw.println(outputTree.taggedYield().toString(false));
                pw.println();
            }
            if (this.formats.containsKey("oneline")) {
                pw.println(outputTree.toString());
            }
            if (this.formats.containsKey("penn")) {
                outputPSTree.pennPrint(pw);
                pw.println();
            }
            if (this.formats.containsKey(rootLabelOnlyFormat)) {
                pw.println(outputTree.label());
            }
            if (this.formats.containsKey("latexTree")) {
                pw.println(".[");
                outputTree.indentedListPrint(pw, false);
                pw.println(".]");
            }
            if (this.formats.containsKey("dependencies")) {
                Tree indexedTree = outputTree.deeperCopy(outputTree.treeFactory(), MapLabel.factory());
                indexedTree.indexLeaves();
                Set<Dependency> depsSet = indexedTree.mapDependencies(this.dependencyFilter, this.hf);
                sortedDeps = new ArrayList<Dependency>(depsSet);
                Collections.sort(sortedDeps, ComparatorHolder.dc);
                for (Dependency d : sortedDeps) {
                    pw.println(d.toString("predicate"));
                }
                pw.println();
            }
            if (this.formats.containsKey("typedDependencies")) {
                GrammaticalStructure gs = this.gsf.newGrammaticalStructure(outputTree);
                TreePrint.print(gs.typedDependencies(), pw);
                pw.println();
            }
            if (this.formats.containsKey("typedDependenciesCollapsed")) {
                GrammaticalStructure gs = this.gsf.newGrammaticalStructure(outputTree);
                TreePrint.print(gs.typedDependenciesCollapsed(), pw);
            }
        }
    }

    public void printHeader(PrintWriter pw, String charset) {
        if (TreePrint.propertyToBoolean(this.options, "xml")) {
            pw.println("<?xml version=\"1.0\" encoding=\"" + charset + "\"?>");
            pw.println("<corpus>");
        }
    }

    public void printFooter(PrintWriter pw) {
        if (TreePrint.propertyToBoolean(this.options, "xml")) {
            pw.println("</corpus>");
        }
    }

    public void setStem(boolean stem) {
        this.stem = stem;
        this.stemmer = stem ? new WordStemmer() : null;
    }

    public void setHeadFinder(HeadFinder hf) {
        this.hf = hf;
    }

    public HeadFinder getHeadFinder() {
        return this.hf;
    }

    public void setPrintWriter(PrintWriter pw) {
        this.pw = pw;
    }

    public PrintWriter getPrintWriter() {
        return this.pw;
    }

    public Tree markHeadNodes(Tree t) {
        return this.markHeadNodes(t, null);
    }

    private Tree markHeadNodes(Tree t, Tree head) {
        if (t.isLeaf()) {
            return t;
        }
        Label newLabel = t == head ? this.headMark(t.label()) : t.label();
        Tree newHead = this.hf.determineHead(t);
        return t.treeFactory().newTreeNode(newLabel, Arrays.asList(this.headMarkChildren(t, newHead)));
    }

    private Label headMark(Label l) {
        Label l1 = l.labelFactory().newLabel(l);
        l1.setValue(l1.value() + headMark);
        return l1;
    }

    private Tree[] headMarkChildren(Tree t, Tree head) {
        Tree[] kids = t.children();
        Tree[] newKids = new Tree[kids.length];
        int n = kids.length;
        for (int i = 0; i < n; ++i) {
            newKids[i] = this.markHeadNodes(kids[i], head);
        }
        return newKids;
    }

    public static void main(String[] args) {
        Iterator<Object> i;
        HeadFinder hf;
        TreebankLangParserParams tlpp;
        String format = "penn";
        String options = "";
        String tlppName = "edu.stanford.nlp.parser.lexparser.EnglishTreebankParserParams";
        String hfName = null;
        HashMap<String, Integer> flagMap = new HashMap<String, Integer>();
        flagMap.put("-format", 1);
        flagMap.put("-options", 1);
        flagMap.put("-tLPP", 1);
        flagMap.put("-hf", 1);
        Map<String, String[]> argsMap = StringUtils.argsToMap(args, flagMap);
        args = argsMap.get(null);
        if (argsMap.keySet().contains("-format")) {
            format = argsMap.get("-format")[0];
        }
        if (argsMap.keySet().contains("-options")) {
            options = argsMap.get("-options")[0];
        }
        if (argsMap.keySet().contains("-tLPP")) {
            tlppName = argsMap.get("-tLPP")[0];
        }
        if (argsMap.keySet().contains("-hf")) {
            hfName = argsMap.get("-hf")[0];
        }
        try {
            tlpp = (TreebankLangParserParams)Class.forName(tlppName).newInstance();
        }
        catch (Exception e) {
            e.printStackTrace();
            return;
        }
        try {
            hf = (HeadFinder)Class.forName(hfName).newInstance();
        }
        catch (Exception e) {
            e.printStackTrace();
            return;
        }
        TreePrint print = new TreePrint(format, options, tlpp.treebankLanguagePack(), hf == null ? tlpp.headFinder() : hf);
        if (args.length > 0) {
            DiskTreebank trees = argsMap.keySet().contains("-arabic") ? tlpp.diskTreebank() : new DiskTreebank(new TreeReaderFactory(){

                public TreeReader newTreeReader(Reader in) {
                    return new PennTreeReader(in, new LabeledScoredTreeFactory(new StringLabelFactory()), new TreeNormalizer());
                }
            });
            trees.loadPath(args[0]);
            i = ((AbstractCollection)trees).iterator();
        } else {
            i = tlpp.treeTokenizerFactory().getIterator(new BufferedReader(new InputStreamReader(System.in)));
        }
        while (i.hasNext()) {
            print.printTree((Tree)i.next());
        }
    }

    public static String toString(Collection<TypedDependency> dependencies, String format) {
        if (format != null && format.equals("xml")) {
            return TreePrint.toXMLString(dependencies);
        }
        if (format != null && format.equals("readable")) {
            return TreePrint.toReadableString(dependencies);
        }
        return TreePrint.toString(dependencies);
    }

    public static String toString(Collection<TypedDependency> dependencies) {
        StringBuilder buf = new StringBuilder();
        for (TypedDependency td : dependencies) {
            buf.append(td.toString()).append("\n");
        }
        return buf.toString();
    }

    private static String toReadableString(Collection<TypedDependency> dependencies) {
        StringBuilder buf = new StringBuilder();
        buf.append(String.format("%-20s%-20s%-20s%n", "dep", "reln", "gov"));
        buf.append(String.format("%-20s%-20s%-20s%n", "---", "----", "---"));
        for (TypedDependency td : dependencies) {
            buf.append(String.format("%-20s%-20s%-20s%n", td.dep(), td.reln(), td.gov()));
        }
        return buf.toString();
    }

    private static String toXMLString(Collection<TypedDependency> dependencies) {
        StringBuilder buf = new StringBuilder("<dependencies style=\"typed\">\n");
        for (TypedDependency td : dependencies) {
            String reln = td.reln().toString();
            String gov = td.gov().value();
            int govIdx = td.gov().index();
            String dep = td.dep().value();
            int depIdx = td.dep().index();
            buf.append("  <dep type=\"" + reln + "\">\n");
            buf.append("    <governor idx=\"" + govIdx + "\">" + gov + "</governor>\n");
            buf.append("    <dependent idx=\"" + depIdx + "\">" + dep + "</dependent>\n");
            buf.append("  </dep>\n");
        }
        buf.append("</dependencies>");
        return buf.toString();
    }

    public static void print(Collection<TypedDependency> dependencies, PrintWriter pw) {
        pw.println(TreePrint.toString(dependencies));
    }

    public static void print(Collection<TypedDependency> dependencies, String format, PrintWriter pw) {
        pw.println(TreePrint.toString(dependencies, format));
    }

    private static class ComparatorHolder {
        private static final Comparator dc = new DependencyIdxComparator();

        private ComparatorHolder() {
        }

        /*
         * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
         */
        private static class DependencyIdxComparator
        implements Comparator<Dependency> {
            private DependencyIdxComparator() {
            }

            @Override
            public int compare(Dependency dep1, Dependency dep2) {
                AbstractMapLabel dep1lab = (AbstractMapLabel)dep1.dependent();
                AbstractMapLabel dep2lab = (AbstractMapLabel)dep2.dependent();
                int dep1idx = dep1lab.index();
                int dep2idx = dep2lab.index();
                return dep1idx - dep2idx;
            }
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class DependencyRejectFilter
    implements Filter<Dependency> {
        private Filter tagRejectFilter;

        DependencyRejectFilter(Filter trf) {
            this.tagRejectFilter = trf;
        }

        @Override
        public boolean accept(Dependency ob) {
            if (!(ob instanceof Dependency)) {
                return false;
            }
            Dependency d = ob;
            if (!(d.dependent() instanceof HasTag)) {
                return false;
            }
            String tag = ((HasTag)((Object)d.dependent())).tag();
            return this.tagRejectFilter.accept(tag);
        }
    }
}

