/*
 * Decompiled with CFR 0.152.
 */
package edu.stanford.nlp.tagger.maxent;

import edu.stanford.nlp.tagger.maxent.GlobalHolder;
import java.util.ArrayList;
import java.util.HashSet;

public class AmbiguityClass {
    HashSet s = new HashSet();
    ArrayList sortedIds = new ArrayList();
    String key;
    String word;
    boolean single;
    public static AmbiguityClass naClass = new AmbiguityClass();

    public AmbiguityClass() {
    }

    public AmbiguityClass(String word) {
        this();
        String[] tags = GlobalHolder.dict.getTags(word);
        int i = 0;
        while (i < tags.length) {
            this.add(GlobalHolder.tags.getIndex(tags[i]));
            ++i;
        }
        this.init();
        this.word = word;
    }

    public AmbiguityClass(String word, boolean single) {
        this();
        this.word = word;
        this.single = true;
        this.init();
    }

    public String getWord() {
        return this.word;
    }

    public boolean belongs(String word) {
        String[] tags = GlobalHolder.dict.getTags(word);
        if (tags.length != this.sortedIds.size()) {
            return false;
        }
        int i = 0;
        while (i < tags.length) {
            if (!this.s.contains(tags[i])) {
                return false;
            }
            ++i;
        }
        return true;
    }

    public boolean add(int tagId) {
        int j = 0;
        while (j < this.sortedIds.size()) {
            if (tagId < (Integer)this.sortedIds.get(j)) {
                this.sortedIds.add(j, new Integer(tagId));
                return true;
            }
            if (tagId == (Integer)this.sortedIds.get(j)) {
                return false;
            }
            ++j;
        }
        this.sortedIds.add(new Integer(tagId));
        return true;
    }

    public String toString() {
        String s = "";
        int i = 0;
        while (i < this.sortedIds.size()) {
            s = String.valueOf(s) + ":" + (Integer)this.sortedIds.get(i);
            ++i;
        }
        if (this.single) {
            s = this.word;
        }
        return s;
    }

    public void print() {
        System.out.print(String.valueOf(this.word) + " ");
        int i = 0;
        while (i < this.sortedIds.size()) {
            System.out.print(GlobalHolder.tags.getTag((Integer)this.sortedIds.get(i)));
            ++i;
        }
        System.out.println();
    }

    public int hashCode() {
        return this.key.hashCode();
    }

    public boolean equals(Object o) {
        if (!(o instanceof AmbiguityClass)) {
            return false;
        }
        return this.key.equals(((AmbiguityClass)o).key);
    }

    public void init() {
        if (!this.single) {
            int i = 0;
            while (i < this.sortedIds.size()) {
                this.s.add(GlobalHolder.tags.getTag((Integer)this.sortedIds.get(i)));
                ++i;
            }
        }
        this.key = this.toString();
    }
}

